/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\r\u0010\u0006J\u000f\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u0006J\u000f\u0010\u000f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0006J\u0017\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2DataTypeProvider;", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "<init>", "()V", "", "binaryType", "()Ljava/lang/String;", "uuidType", "Ljava/util/UUID;", "value", "", "uuidToDB", "(Ljava/util/UUID;)Ljava/lang/Object;", "dateTimeType", "timestampWithTimeZoneType", "jsonBType", "hexString", "hexToDb", "(Ljava/lang/String;)Ljava/lang/String;", "exposed-core"})
public final class H2DataTypeProvider
extends DataTypeProvider {
    @NotNull
    public static final H2DataTypeProvider INSTANCE = new H2DataTypeProvider();

    private H2DataTypeProvider() {
    }

    @Override
    @NotNull
    public String binaryType() {
        return "VARBINARY";
    }

    @Override
    @NotNull
    public String uuidType() {
        return "UUID";
    }

    @Override
    @NotNull
    public Object uuidToDB(@NotNull UUID value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        String string = value2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public String dateTimeType() {
        return "DATETIME(9)";
    }

    @Override
    @NotNull
    public String timestampWithTimeZoneType() {
        return "TIMESTAMP(9) WITH TIME ZONE";
    }

    @Override
    @NotNull
    public String jsonBType() {
        return "JSON";
    }

    @Override
    @NotNull
    public String hexToDb(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter((Object)hexString, (String)"hexString");
        return "X'" + hexString + '\'';
    }
}

