/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TableKt;
import org.jetbrains.exposed.sql.TextColumnType;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.H2DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.H2FunctionProvider;
import org.jetbrains.exposed.sql.vendors.MariaDBDialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b2\b\u0016\u0018\u0000 \u0081\u00012\u00020\u0001:\u0006\u0082\u0001\u0083\u0001\u0081\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0011\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ5\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00112\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001b\u0010\u0019\u001a\u00020\u00182\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b!\u0010\u0006J)\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010(\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b(\u0010 J\u0017\u0010,\u001a\u00020+2\u0006\u0010*\u001a\u00020)H\u0016\u00a2\u0006\u0004\b,\u0010-J\u0015\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012H\u0016\u00a2\u0006\u0004\b.\u0010/R\u001b\u00103\u001a\u00020\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u0010\u0006R\u001b\u00108\u001a\u0002048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u00101\u001a\u0004\b6\u00107R\u0011\u00109\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u001d\u0010?\u001a\u0004\u0018\u00010;8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b<\u00101\u001a\u0004\b=\u0010>R\u0018\u0010@\u001a\u0004\u0018\u00010\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010AR\u0017\u0010C\u001a\u00020B8\u0006\u00a2\u0006\f\n\u0004\bC\u0010D\u001a\u0004\bE\u0010FR\u001b\u0010I\u001a\u00020B8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bG\u00101\u001a\u0004\bH\u0010FR\u0017\u0010K\u001a\u00020J8\u0006\u00a2\u0006\f\n\u0004\bK\u0010L\u001a\u0004\bM\u0010NR\u001b\u0010Q\u001a\u00020J8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bO\u00101\u001a\u0004\bP\u0010NR\u001d\u0010V\u001a\u0004\u0018\u00010R8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bS\u00101\u001a\u0004\bT\u0010UR\u001b\u0010\u001e\u001a\u00020\u00048VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bW\u00101\u001a\u0004\bX\u0010\u0006R\u001b\u0010[\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bY\u00101\u001a\u0004\bZ\u0010:R\u001b\u0010^\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\\\u00101\u001a\u0004\b]\u0010:R\u001b\u0010a\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b_\u00101\u001a\u0004\b`\u0010:R\u001b\u0010d\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bb\u00101\u001a\u0004\bc\u0010:R\u001b\u0010g\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\be\u00101\u001a\u0004\bf\u0010:R\u001b\u0010k\u001a\u00020+8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bh\u00101\u001a\u0004\bi\u0010jR\u001b\u0010n\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bl\u00101\u001a\u0004\bm\u0010:R\u001b\u0010q\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bo\u00101\u001a\u0004\bp\u0010:R\u001b\u0010t\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\br\u00101\u001a\u0004\bs\u0010:R\u001b\u0010w\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bu\u00101\u001a\u0004\bv\u0010:R\u001b\u0010z\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bx\u00101\u001a\u0004\by\u0010:R\u001b\u0010}\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b{\u00101\u001a\u0004\b|\u0010:R\u001c\u0010\u0080\u0001\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b~\u00101\u001a\u0004\b\u007f\u0010:\u00a8\u0006\u0084\u0001"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2Dialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "<init>", "()V", "", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "exactH2Version", "(Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "resolveDelegatedDialect", "()Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "", "Lorg/jetbrains/exposed/sql/Table;", "tables", "", "", "Lorg/jetbrains/exposed/sql/Index;", "existingIndices", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "Lorg/jetbrains/exposed/sql/Expression;", "e", "", "isAllowedAsColumnDefault", "(Lorg/jetbrains/exposed/sql/Expression;)Z", "index", "createIndex", "(Lorg/jetbrains/exposed/sql/Index;)Ljava/lang/String;", "name", "createDatabase", "(Ljava/lang/String;)Ljava/lang/String;", "listDatabases", "Lorg/jetbrains/exposed/sql/Column;", "column", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "columnDiff", "modifyColumn", "(Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/ColumnDiff;)Ljava/util/List;", "dropDatabase", "", "refOption", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "resolveRefOptionFromJdbc", "(I)Lorg/jetbrains/exposed/sql/ReferenceOption;", "sequences", "()Ljava/util/List;", "version$delegate", "Lkotlin/Lazy;", "getVersion$exposed_core", "version", "Lorg/jetbrains/exposed/sql/vendors/H2Dialect$H2MajorVersion;", "majorVersion$delegate", "getMajorVersion", "()Lorg/jetbrains/exposed/sql/vendors/H2Dialect$H2MajorVersion;", "majorVersion", "isSecondVersion", "()Z", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "delegatedDialectNameProvider$delegate", "getDelegatedDialectNameProvider", "()Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "delegatedDialectNameProvider", "delegatedDialect", "Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "originalFunctionProvider", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "getOriginalFunctionProvider", "()Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "functionProvider$delegate", "getFunctionProvider", "functionProvider", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "originalDataTypeProvider", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "getOriginalDataTypeProvider", "()Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "dataTypeProvider$delegate", "getDataTypeProvider", "dataTypeProvider", "Lorg/jetbrains/exposed/sql/vendors/H2Dialect$H2CompatibilityMode;", "h2Mode$delegate", "getH2Mode", "()Lorg/jetbrains/exposed/sql/vendors/H2Dialect$H2CompatibilityMode;", "h2Mode", "name$delegate", "getName", "supportsMultipleGeneratedKeys$delegate", "getSupportsMultipleGeneratedKeys", "supportsMultipleGeneratedKeys", "supportsOnlyIdentifiersInGeneratedKeys$delegate", "getSupportsOnlyIdentifiersInGeneratedKeys", "supportsOnlyIdentifiersInGeneratedKeys", "supportsIfNotExists$delegate", "getSupportsIfNotExists", "supportsIfNotExists", "supportsCreateSequence$delegate", "getSupportsCreateSequence", "supportsCreateSequence", "needsSequenceToAutoInc$delegate", "getNeedsSequenceToAutoInc", "needsSequenceToAutoInc", "defaultReferenceOption$delegate", "getDefaultReferenceOption", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "defaultReferenceOption", "supportsSequenceAsGeneratedKeys$delegate", "getSupportsSequenceAsGeneratedKeys", "supportsSequenceAsGeneratedKeys", "supportsTernaryAffectedRowValues$delegate", "getSupportsTernaryAffectedRowValues", "supportsTernaryAffectedRowValues", "supportsCreateSchema$delegate", "getSupportsCreateSchema", "supportsCreateSchema", "supportsSubqueryUnions$delegate", "getSupportsSubqueryUnions", "supportsSubqueryUnions", "supportsDualTableConcept$delegate", "getSupportsDualTableConcept", "supportsDualTableConcept", "supportsOrderByNullsFirstLast$delegate", "getSupportsOrderByNullsFirstLast", "supportsOrderByNullsFirstLast", "supportsWindowFrameGroupsMode$delegate", "getSupportsWindowFrameGroupsMode", "supportsWindowFrameGroupsMode", "Companion", "H2MajorVersion", "H2CompatibilityMode", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nH2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 H2.kt\norg/jetbrains/exposed/sql/vendors/H2Dialect\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,380:1\n462#2:381\n412#2:382\n503#2,7:389\n1246#3,2:383\n827#3:385\n855#3,2:386\n1249#3:388\n1755#3,3:396\n1557#3:399\n1628#3,3:400\n1#4:403\n*S KotlinDebug\n*F\n+ 1 H2.kt\norg/jetbrains/exposed/sql/vendors/H2Dialect\n*L\n312#1:381\n312#1:382\n313#1:389,7\n312#1:383,2\n312#1:385\n312#1:386,2\n312#1:388\n320#1:396,3\n345#1:399\n345#1:400,3\n*E\n"})
public class H2Dialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy version$delegate = LazyKt.lazy(() -> H2Dialect.version_delegate$lambda$0(this));
    @NotNull
    private final Lazy majorVersion$delegate = LazyKt.lazy(() -> H2Dialect.majorVersion_delegate$lambda$1(this));
    @NotNull
    private final Lazy delegatedDialectNameProvider$delegate = LazyKt.lazy(() -> H2Dialect.delegatedDialectNameProvider_delegate$lambda$3(this));
    @Nullable
    private DatabaseDialect delegatedDialect;
    @NotNull
    private final FunctionProvider originalFunctionProvider = H2FunctionProvider.INSTANCE;
    @NotNull
    private final Lazy functionProvider$delegate = LazyKt.lazy(() -> H2Dialect.functionProvider_delegate$lambda$6(this));
    @NotNull
    private final DataTypeProvider originalDataTypeProvider = H2DataTypeProvider.INSTANCE;
    @NotNull
    private final Lazy dataTypeProvider$delegate = LazyKt.lazy(() -> H2Dialect.dataTypeProvider_delegate$lambda$8(this));
    @NotNull
    private final Lazy h2Mode$delegate = LazyKt.lazy(() -> H2Dialect.h2Mode_delegate$lambda$10(this));
    @NotNull
    private final Lazy name$delegate = LazyKt.lazy(() -> H2Dialect.name_delegate$lambda$11(this));
    @NotNull
    private final Lazy supportsMultipleGeneratedKeys$delegate = LazyKt.lazy(() -> H2Dialect.supportsMultipleGeneratedKeys_delegate$lambda$12(this));
    @NotNull
    private final Lazy supportsOnlyIdentifiersInGeneratedKeys$delegate = LazyKt.lazy(() -> H2Dialect.supportsOnlyIdentifiersInGeneratedKeys_delegate$lambda$13(this));
    @NotNull
    private final Lazy supportsIfNotExists$delegate = LazyKt.lazy(() -> H2Dialect.supportsIfNotExists_delegate$lambda$14(this));
    @NotNull
    private final Lazy supportsCreateSequence$delegate = LazyKt.lazy(() -> H2Dialect.supportsCreateSequence_delegate$lambda$15(this));
    @NotNull
    private final Lazy needsSequenceToAutoInc$delegate = LazyKt.lazy(() -> H2Dialect.needsSequenceToAutoInc_delegate$lambda$16(this));
    @NotNull
    private final Lazy defaultReferenceOption$delegate = LazyKt.lazy(() -> H2Dialect.defaultReferenceOption_delegate$lambda$17(this));
    @NotNull
    private final Lazy supportsSequenceAsGeneratedKeys$delegate = LazyKt.lazy(() -> H2Dialect.supportsSequenceAsGeneratedKeys_delegate$lambda$18(this));
    @NotNull
    private final Lazy supportsTernaryAffectedRowValues$delegate = LazyKt.lazy(() -> H2Dialect.supportsTernaryAffectedRowValues_delegate$lambda$19(this));
    @NotNull
    private final Lazy supportsCreateSchema$delegate = LazyKt.lazy(() -> H2Dialect.supportsCreateSchema_delegate$lambda$20(this));
    @NotNull
    private final Lazy supportsSubqueryUnions$delegate = LazyKt.lazy(() -> H2Dialect.supportsSubqueryUnions_delegate$lambda$21(this));
    @NotNull
    private final Lazy supportsDualTableConcept$delegate = LazyKt.lazy(() -> H2Dialect.supportsDualTableConcept_delegate$lambda$22(this));
    @NotNull
    private final Lazy supportsOrderByNullsFirstLast$delegate = LazyKt.lazy(() -> H2Dialect.supportsOrderByNullsFirstLast_delegate$lambda$23(this));
    @NotNull
    private final Lazy supportsWindowFrameGroupsMode$delegate = LazyKt.lazy(() -> H2Dialect.supportsWindowFrameGroupsMode_delegate$lambda$24(this));

    public H2Dialect() {
        super(Companion.getDialectName(), H2DataTypeProvider.INSTANCE, H2FunctionProvider.INSTANCE);
    }

    @NotNull
    public String toString() {
        return "H2Dialect[" + Companion.getDialectName() + ", " + (Object)((Object)this.getH2Mode()) + ']';
    }

    @NotNull
    public final String getVersion$exposed_core() {
        Lazy lazy2 = this.version$delegate;
        return (String)lazy2.getValue();
    }

    @NotNull
    public final H2MajorVersion getMajorVersion() {
        Lazy lazy2 = this.majorVersion$delegate;
        return (H2MajorVersion)((Object)lazy2.getValue());
    }

    public final boolean isSecondVersion() {
        return this.getMajorVersion() == H2MajorVersion.Two;
    }

    private final String exactH2Version(Transaction transaction) {
        return (String)transaction.getDb().metadata$exposed_core(H2Dialect::exactH2Version$lambda$2);
    }

    @Nullable
    public final VendorDialect.DialectNameProvider getDelegatedDialectNameProvider() {
        Lazy lazy2 = this.delegatedDialectNameProvider$delegate;
        return (VendorDialect.DialectNameProvider)lazy2.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final DatabaseDialect resolveDelegatedDialect() {
        Object object;
        Object object3 = this.delegatedDialect;
        object3 = object3;
        if (object2 != null) return object3;
        VendorDialect.DialectNameProvider dialectNameProvider = this.getDelegatedDialectNameProvider();
        Object object4 = dialectNameProvider;
        if (dialectNameProvider == null) return null;
        String string = ((VendorDialect.DialectNameProvider)object4).getDialectName();
        object4 = string;
        if (string == null) return null;
        String string2 = ((String)object4).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        object4 = string2;
        if (string2 == null) return null;
        Object it = object4;
        boolean bl = false;
        Function0<DatabaseDialect> function0 = Database.Companion.getDialects$exposed_core().get(it);
        Object object5 = function0;
        if (function0 == null) throw new IllegalStateException(("Can't resolve dialect for " + (String)it).toString());
        if ((object5 = (DatabaseDialect)object5.invoke()) == null) {
            throw new IllegalStateException(("Can't resolve dialect for " + (String)it).toString());
        }
        this.delegatedDialect = object = object5;
        object3 = object;
        return object3;
    }

    @NotNull
    public final FunctionProvider getOriginalFunctionProvider() {
        return this.originalFunctionProvider;
    }

    @Override
    @NotNull
    public FunctionProvider getFunctionProvider() {
        Lazy lazy2 = this.functionProvider$delegate;
        return (FunctionProvider)lazy2.getValue();
    }

    @NotNull
    public final DataTypeProvider getOriginalDataTypeProvider() {
        return this.originalDataTypeProvider;
    }

    @Override
    @NotNull
    public DataTypeProvider getDataTypeProvider() {
        Lazy lazy2 = this.dataTypeProvider$delegate;
        return (DataTypeProvider)lazy2.getValue();
    }

    @Nullable
    public final H2CompatibilityMode getH2Mode() {
        Lazy lazy2 = this.h2Mode$delegate;
        return (H2CompatibilityMode)((Object)lazy2.getValue());
    }

    @Override
    @NotNull
    public String getName() {
        Lazy lazy2 = this.name$delegate;
        return (String)lazy2.getValue();
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        Lazy lazy2 = this.supportsMultipleGeneratedKeys$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        Lazy lazy2 = this.supportsOnlyIdentifiersInGeneratedKeys$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    public boolean getSupportsIfNotExists() {
        Lazy lazy2 = this.supportsIfNotExists$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    public boolean getSupportsCreateSequence() {
        Lazy lazy2 = this.supportsCreateSequence$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    public boolean getNeedsSequenceToAutoInc() {
        Lazy lazy2 = this.needsSequenceToAutoInc$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    @NotNull
    public ReferenceOption getDefaultReferenceOption() {
        Lazy lazy2 = this.defaultReferenceOption$delegate;
        return (ReferenceOption)((Object)lazy2.getValue());
    }

    @Override
    public boolean getSupportsSequenceAsGeneratedKeys() {
        Lazy lazy2 = this.supportsSequenceAsGeneratedKeys$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    public boolean getSupportsTernaryAffectedRowValues() {
        Lazy lazy2 = this.supportsTernaryAffectedRowValues$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    public boolean getSupportsCreateSchema() {
        Lazy lazy2 = this.supportsCreateSchema$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    public boolean getSupportsSubqueryUnions() {
        Lazy lazy2 = this.supportsSubqueryUnions$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    public boolean getSupportsDualTableConcept() {
        Lazy lazy2 = this.supportsDualTableConcept$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        Lazy lazy2 = this.supportsOrderByNullsFirstLast$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    public boolean getSupportsWindowFrameGroupsMode() {
        Lazy lazy2 = this.supportsWindowFrameGroupsMode$delegate;
        return (Boolean)lazy2.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Table, List<Index>> existingIndices(Table ... tables) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        Map<Table, List<Index>> $this$mapValues$iv = super.existingIndices(Arrays.copyOf(tables, tables.length));
        boolean $i$f$mapValues = false;
        Map<Table, List<Index>> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$filterNotTo$iv$iv;
            void entry;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            Iterable $this$filterNot$iv = (Iterable)entry.getValue();
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Index it = (Index)element$iv$iv;
                boolean bl3 = false;
                if (StringsKt.startsWith$default((String)it.getIndexName(), (String)"PRIMARY_KEY_", (boolean)false, (int)2, null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv2;
            map4.put(k, list2);
        }
        Map $this$filterValues$iv = destination$iv$iv;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            List it = (List)entry$iv.getValue();
            boolean bl = false;
            boolean bl4 = !((Collection)it).isEmpty();
            if (!bl4) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        return true;
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        if (this.getMajorVersion() == H2MajorVersion.One || this.getH2Mode() == H2CompatibilityMode.Oracle) {
            boolean bl;
            block7: {
                Iterable $this$any$iv = index.getColumns();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Column it = (Column)element$iv;
                        boolean bl2 = false;
                        if (!(it.getColumnType() instanceof TextColumnType)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                SQLLogKt.getExposedLogger().warn("Index on " + index.getTable().getTableName() + " for " + CollectionsKt.joinToString$default((Iterable)index.getColumns(), null, null, null, (int)0, null, H2Dialect::createIndex$lambda$29, (int)31, null) + " can't be created on CLOB in H2");
                return "";
            }
        }
        if (index.getIndexType() != null) {
            SQLLogKt.getExposedLogger().warn("Index of type " + index.getIndexType() + " on " + index.getTable().getTableName() + " for " + CollectionsKt.joinToString$default((Iterable)index.getColumns(), null, null, null, (int)0, null, H2Dialect::createIndex$lambda$30, (int)31, null) + " can't be created in H2");
            return "";
        }
        if (index.getFunctions() != null) {
            SQLLogKt.getExposedLogger().warn("Functional index on " + index.getTable().getTableName() + " using " + CollectionsKt.joinToString$default((Iterable)index.getFunctions(), null, null, null, (int)0, null, H2Dialect::createIndex$lambda$31, (int)31, null) + " can't be created in H2");
            return "";
        }
        return super.createIndex(index);
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return "CREATE SCHEMA IF NOT EXISTS " + DatabaseDialectKt.inProperCase(name);
    }

    @Override
    @NotNull
    public String listDatabases() {
        return "SHOW SCHEMAS";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, @NotNull ColumnDiff columnDiff) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)columnDiff, (String)"columnDiff");
        Iterable $this$map$iv = super.modifyColumn(column, columnDiff);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.replace$default((String)it, (String)"MODIFY COLUMN", (String)"ALTER COLUMN", (boolean)false, (int)4, null));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return "DROP SCHEMA IF EXISTS " + DatabaseDialectKt.inProperCase(name);
    }

    @Override
    @NotNull
    public ReferenceOption resolveRefOptionFromJdbc(int refOption) {
        boolean modeDelegatesRefOption = this.getH2Mode() == H2CompatibilityMode.Oracle || this.getH2Mode() == H2CompatibilityMode.SQLServer;
        return refOption == 1 && modeDelegatesRefOption ? ReferenceOption.NO_ACTION : (refOption == 1 ? ReferenceOption.RESTRICT : super.resolveRefOptionFromJdbc(refOption));
    }

    @Override
    @NotNull
    public List<String> sequences() {
        List sequences = new ArrayList();
        Transaction.exec$default(TransactionManager.Companion.current(), "SELECT SEQUENCE_NAME FROM INFORMATION_SCHEMA.SEQUENCES", null, null, arg_0 -> H2Dialect.sequences$lambda$33(this, sequences, arg_0), 6, null);
        return sequences;
    }

    private static final String version_delegate$lambda$0(H2Dialect this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.exactH2Version(TransactionManager.Companion.current());
    }

    private static final H2MajorVersion majorVersion_delegate$lambda$1(H2Dialect this$0) {
        H2MajorVersion h2MajorVersion;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (StringsKt.startsWith$default((String)this$0.getVersion$exposed_core(), (String)"1.", (boolean)false, (int)2, null)) {
            h2MajorVersion = H2MajorVersion.One;
        } else if (StringsKt.startsWith$default((String)this$0.getVersion$exposed_core(), (String)"2.", (boolean)false, (int)2, null)) {
            h2MajorVersion = H2MajorVersion.Two;
        } else {
            throw new IllegalStateException(("Unsupported H2 version: " + this$0.getVersion$exposed_core()).toString());
        }
        return h2MajorVersion;
    }

    private static final String exactH2Version$lambda$2(ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return StringsKt.substringBefore$default((String)$this$metadata.getDatabaseProductVersion(), (String)" (", null, (int)2, null);
    }

    private static final VendorDialect.DialectNameProvider delegatedDialectNameProvider_delegate$lambda$3(H2Dialect this$0) {
        VendorDialect.DialectNameProvider dialectNameProvider;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        H2CompatibilityMode h2CompatibilityMode = this$0.getH2Mode();
        switch (h2CompatibilityMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[h2CompatibilityMode.ordinal()]) {
            case 1: {
                dialectNameProvider = MysqlDialect.Companion;
                break;
            }
            case 2: {
                dialectNameProvider = MariaDBDialect.Companion;
                break;
            }
            case 3: {
                dialectNameProvider = PostgreSQLDialect.Companion;
                break;
            }
            case 4: {
                dialectNameProvider = OracleDialect.Companion;
                break;
            }
            case 5: {
                dialectNameProvider = SQLServerDialect.Companion;
                break;
            }
            default: {
                dialectNameProvider = null;
            }
        }
        return dialectNameProvider;
    }

    private static final FunctionProvider functionProvider_delegate$lambda$6(H2Dialect this$0) {
        Object object;
        block3: {
            block2: {
                DatabaseDialect databaseDialect;
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                object = this$0.resolveDelegatedDialect();
                if (object == null) break block2;
                DatabaseDialect it = databaseDialect = object;
                boolean bl = false;
                object = !(it instanceof MysqlDialect) ? databaseDialect : null;
                if (object != null && (object = object.getFunctionProvider()) != null) break block3;
            }
            object = this$0.originalFunctionProvider;
        }
        return object;
    }

    private static final DataTypeProvider dataTypeProvider_delegate$lambda$8(H2Dialect this$0) {
        Object object;
        block3: {
            block2: {
                DatabaseDialect databaseDialect;
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                object = this$0.resolveDelegatedDialect();
                if (object == null) break block2;
                DatabaseDialect it = databaseDialect = object;
                boolean bl = false;
                object = !(it instanceof MysqlDialect) ? databaseDialect : null;
                if (object != null && (object = object.getDataTypeProvider()) != null) break block3;
            }
            object = this$0.originalDataTypeProvider;
        }
        return object;
    }

    private static final String h2Mode_delegate$lambda$10$lambda$9(String $settingValueField, ResultSet rs) {
        Intrinsics.checkNotNullParameter((Object)$settingValueField, (String)"$settingValueField");
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        rs.next();
        return rs.getString($settingValueField);
    }

    private static final H2CompatibilityMode h2Mode_delegate$lambda$10(H2Dialect this$0) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        switch (WhenMappings.$EnumSwitchMapping$1[this$0.getMajorVersion().ordinal()]) {
            case 1: {
                pair = TuplesKt.to((Object)"NAME", (Object)"VALUE");
                break;
            }
            case 2: {
                pair = TuplesKt.to((Object)"SETTING_NAME", (Object)"SETTING_VALUE");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Pair pair2 = pair;
        String settingNameField = (String)pair2.component1();
        String settingValueField = (String)pair2.component2();
        String fetchModeQuery = "SELECT " + settingValueField + " FROM INFORMATION_SCHEMA.SETTINGS WHERE " + settingNameField + " = 'MODE'";
        String modeValue = (String)Transaction.exec$default(TransactionManager.Companion.current(), fetchModeQuery, null, null, arg_0 -> H2Dialect.h2Mode_delegate$lambda$10$lambda$9(settingValueField, arg_0), 6, null);
        return modeValue == null ? null : (StringsKt.equals((String)modeValue, (String)"MySQL", (boolean)true) ? H2CompatibilityMode.MySQL : (StringsKt.equals((String)modeValue, (String)"MariaDB", (boolean)true) ? H2CompatibilityMode.MariaDB : (StringsKt.equals((String)modeValue, (String)"MSSQLServer", (boolean)true) ? H2CompatibilityMode.SQLServer : (StringsKt.equals((String)modeValue, (String)"Oracle", (boolean)true) ? H2CompatibilityMode.Oracle : (StringsKt.equals((String)modeValue, (String)"PostgreSQL", (boolean)true) ? H2CompatibilityMode.PostgreSQL : null)))));
    }

    private static final String name_delegate$lambda$11(H2Dialect this$0) {
        String string;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        H2CompatibilityMode h2CompatibilityMode = this$0.getH2Mode();
        if ((h2CompatibilityMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[h2CompatibilityMode.ordinal()]) == -1) {
            string = Companion.getDialectName();
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(Companion.getDialectName()).append(" (");
            H2CompatibilityMode h2CompatibilityMode2 = this$0.getH2Mode();
            Intrinsics.checkNotNull((Object)((Object)h2CompatibilityMode2));
            string = stringBuilder.append(h2CompatibilityMode2.name()).append(" Mode)").toString();
        }
        return string;
    }

    private static final boolean supportsMultipleGeneratedKeys_delegate$lambda$12(H2Dialect this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DatabaseDialect databaseDialect = this$0.resolveDelegatedDialect();
        return databaseDialect != null ? databaseDialect.getSupportsMultipleGeneratedKeys() : false;
    }

    private static final boolean supportsOnlyIdentifiersInGeneratedKeys_delegate$lambda$13(H2Dialect this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DatabaseDialect databaseDialect = this$0.resolveDelegatedDialect();
        return databaseDialect != null ? databaseDialect.getSupportsOnlyIdentifiersInGeneratedKeys() : true;
    }

    private static final boolean supportsIfNotExists_delegate$lambda$14(H2Dialect this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DatabaseDialect databaseDialect = this$0.resolveDelegatedDialect();
        return databaseDialect != null ? databaseDialect.getSupportsIfNotExists() : super.getSupportsIfNotExists();
    }

    private static final boolean supportsCreateSequence_delegate$lambda$15(H2Dialect this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DatabaseDialect databaseDialect = this$0.resolveDelegatedDialect();
        return databaseDialect != null ? databaseDialect.getSupportsCreateSequence() : super.getSupportsCreateSequence();
    }

    private static final boolean needsSequenceToAutoInc_delegate$lambda$16(H2Dialect this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DatabaseDialect databaseDialect = this$0.resolveDelegatedDialect();
        return databaseDialect != null ? databaseDialect.getNeedsSequenceToAutoInc() : super.getNeedsSequenceToAutoInc();
    }

    private static final ReferenceOption defaultReferenceOption_delegate$lambda$17(H2Dialect this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = this$0.resolveDelegatedDialect();
        if (object == null || (object = object.getDefaultReferenceOption()) == null) {
            object = super.getDefaultReferenceOption();
        }
        return object;
    }

    private static final boolean supportsSequenceAsGeneratedKeys_delegate$lambda$18(H2Dialect this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DatabaseDialect databaseDialect = this$0.resolveDelegatedDialect();
        return databaseDialect != null ? databaseDialect.getSupportsSequenceAsGeneratedKeys() : super.getSupportsSequenceAsGeneratedKeys();
    }

    private static final boolean supportsTernaryAffectedRowValues_delegate$lambda$19(H2Dialect this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DatabaseDialect databaseDialect = this$0.resolveDelegatedDialect();
        return databaseDialect != null ? databaseDialect.getSupportsTernaryAffectedRowValues() : super.getSupportsTernaryAffectedRowValues();
    }

    private static final boolean supportsCreateSchema_delegate$lambda$20(H2Dialect this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DatabaseDialect databaseDialect = this$0.resolveDelegatedDialect();
        return databaseDialect != null ? databaseDialect.getSupportsCreateSchema() : super.getSupportsCreateSchema();
    }

    private static final boolean supportsSubqueryUnions_delegate$lambda$21(H2Dialect this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DatabaseDialect databaseDialect = this$0.resolveDelegatedDialect();
        return databaseDialect != null ? databaseDialect.getSupportsSubqueryUnions() : super.getSupportsSubqueryUnions();
    }

    private static final boolean supportsDualTableConcept_delegate$lambda$22(H2Dialect this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DatabaseDialect databaseDialect = this$0.resolveDelegatedDialect();
        return databaseDialect != null ? databaseDialect.getSupportsDualTableConcept() : super.getSupportsDualTableConcept();
    }

    private static final boolean supportsOrderByNullsFirstLast_delegate$lambda$23(H2Dialect this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DatabaseDialect databaseDialect = this$0.resolveDelegatedDialect();
        return databaseDialect != null ? databaseDialect.getSupportsOrderByNullsFirstLast() : super.getSupportsOrderByNullsFirstLast();
    }

    private static final boolean supportsWindowFrameGroupsMode_delegate$lambda$24(H2Dialect this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DatabaseDialect databaseDialect = this$0.resolveDelegatedDialect();
        return databaseDialect != null ? databaseDialect.getSupportsWindowFrameGroupsMode() : super.getSupportsWindowFrameGroupsMode();
    }

    private static final CharSequence createIndex$lambda$29(Column it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final CharSequence createIndex$lambda$30(Column it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final CharSequence createIndex$lambda$31(ExpressionWithColumnType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    private static final Unit sequences$lambda$33(H2Dialect this$0, List $sequences, ResultSet rs) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$sequences, (String)"$sequences");
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        while (rs.next()) {
            String string;
            String result = rs.getString("SEQUENCE_NAME");
            if (this$0.getH2Mode() == H2CompatibilityMode.Oracle) {
                Intrinsics.checkNotNull((Object)result);
                String q = StringsKt.contains$default((CharSequence)result, (char)'.', (boolean)false, (int)2, null) && !TableKt.isAlreadyQuoted(result) ? "\"" : "";
                string = q + result + q;
            } else {
                string = result;
            }
            String sequenceName = string;
            Intrinsics.checkNotNull((Object)sequenceName);
            $sequences.add(sequenceName);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2Dialect$Companion;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "<init>", "()V", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("H2");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2Dialect$H2CompatibilityMode;", "", "<init>", "(Ljava/lang/String;I)V", "MySQL", "MariaDB", "SQLServer", "Oracle", "PostgreSQL", "exposed-core"})
    public static final class H2CompatibilityMode
    extends Enum<H2CompatibilityMode> {
        public static final /* enum */ H2CompatibilityMode MySQL = new H2CompatibilityMode();
        public static final /* enum */ H2CompatibilityMode MariaDB = new H2CompatibilityMode();
        public static final /* enum */ H2CompatibilityMode SQLServer = new H2CompatibilityMode();
        public static final /* enum */ H2CompatibilityMode Oracle = new H2CompatibilityMode();
        public static final /* enum */ H2CompatibilityMode PostgreSQL = new H2CompatibilityMode();
        private static final /* synthetic */ H2CompatibilityMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static H2CompatibilityMode[] values() {
            return (H2CompatibilityMode[])$VALUES.clone();
        }

        public static H2CompatibilityMode valueOf(String value2) {
            return Enum.valueOf(H2CompatibilityMode.class, value2);
        }

        @NotNull
        public static EnumEntries<H2CompatibilityMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = h2CompatibilityModeArray = new H2CompatibilityMode[]{H2CompatibilityMode.MySQL, H2CompatibilityMode.MariaDB, H2CompatibilityMode.SQLServer, H2CompatibilityMode.Oracle, H2CompatibilityMode.PostgreSQL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2Dialect$H2MajorVersion;", "", "<init>", "(Ljava/lang/String;I)V", "One", "Two", "exposed-core"})
    public static final class H2MajorVersion
    extends Enum<H2MajorVersion> {
        public static final /* enum */ H2MajorVersion One = new H2MajorVersion();
        public static final /* enum */ H2MajorVersion Two = new H2MajorVersion();
        private static final /* synthetic */ H2MajorVersion[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static H2MajorVersion[] values() {
            return (H2MajorVersion[])$VALUES.clone();
        }

        public static H2MajorVersion valueOf(String value2) {
            return Enum.valueOf(H2MajorVersion.class, value2);
        }

        @NotNull
        public static EnumEntries<H2MajorVersion> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = h2MajorVersionArray = new H2MajorVersion[]{H2MajorVersion.One, H2MajorVersion.Two};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[H2CompatibilityMode.values().length];
            try {
                nArray[H2CompatibilityMode.MySQL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[H2CompatibilityMode.MariaDB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[H2CompatibilityMode.PostgreSQL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[H2CompatibilityMode.Oracle.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[H2CompatibilityMode.SQLServer.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[H2MajorVersion.values().length];
            try {
                nArray[H2MajorVersion.One.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[H2MajorVersion.Two.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

