/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.AutoIncColumnType;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.ColumnTypeKt;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.Sequence;
import org.jetbrains.exposed.sql.TableKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.PostgreSQLFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u001d\b\u0016\u0018\u0000 32\u00020\u0001:\u00013B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\t\u001a\u00020\b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ)\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0013J\u0017\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ7\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u001f\u0010 J/\u0010%\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b%\u0010&R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010'\u001a\u0004\b(\u0010\u0015R\u001a\u0010)\u001a\u00020\b8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\b8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b-\u0010*\u001a\u0004\b.\u0010,R\u001a\u0010/\u001a\u00020\b8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b/\u0010*\u001a\u0004\b0\u0010,R\u001a\u00101\u001a\u00020\b8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b1\u0010*\u001a\u0004\b2\u0010,\u00a8\u00064"}, d2={"Lorg/jetbrains/exposed/sql/vendors/PostgreSQLDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "", "name", "<init>", "(Ljava/lang/String;)V", "Lorg/jetbrains/exposed/sql/Expression;", "e", "", "isAllowedAsColumnDefault", "(Lorg/jetbrains/exposed/sql/Expression;)Z", "Lorg/jetbrains/exposed/sql/Column;", "column", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "columnDiff", "", "modifyColumn", "(Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/ColumnDiff;)Ljava/util/List;", "createDatabase", "(Ljava/lang/String;)Ljava/lang/String;", "listDatabases", "()Ljava/lang/String;", "dropDatabase", "Lorg/jetbrains/exposed/sql/Schema;", "schema", "setSchema", "(Lorg/jetbrains/exposed/sql/Schema;)Ljava/lang/String;", "table", "columns", "type", "filterCondition", "createIndexWithType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "dropIndex", "(Ljava/lang/String;Ljava/lang/String;ZZ)Ljava/lang/String;", "Ljava/lang/String;", "getName", "supportsSubqueryUnions", "Z", "getSupportsSubqueryUnions", "()Z", "supportsOrderByNullsFirstLast", "getSupportsOrderByNullsFirstLast", "requiresAutoCommitOnCreateDrop", "getRequiresAutoCommitOnCreateDrop", "supportsWindowFrameGroupsMode", "getSupportsWindowFrameGroupsMode", "Companion", "exposed-core"})
public class PostgreSQLDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final boolean supportsSubqueryUnions;
    private final boolean supportsOrderByNullsFirstLast;
    private final boolean requiresAutoCommitOnCreateDrop;
    private final boolean supportsWindowFrameGroupsMode;

    public PostgreSQLDialect(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(Companion.getDialectName(), PostgreSQLDataTypeProvider.INSTANCE, PostgreSQLFunctionProvider.INSTANCE);
        this.name = name;
        this.supportsSubqueryUnions = true;
        this.supportsOrderByNullsFirstLast = true;
        this.requiresAutoCommitOnCreateDrop = true;
        this.supportsWindowFrameGroupsMode = true;
    }

    public /* synthetic */ PostgreSQLDialect(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = Companion.getDialectName();
        }
        this(string);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean getSupportsSubqueryUnions() {
        return this.supportsSubqueryUnions;
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return this.supportsOrderByNullsFirstLast;
    }

    @Override
    public boolean getRequiresAutoCommitOnCreateDrop() {
        return this.requiresAutoCommitOnCreateDrop;
    }

    @Override
    public boolean getSupportsWindowFrameGroupsMode() {
        return this.supportsWindowFrameGroupsMode;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, @NotNull ColumnDiff columnDiff) {
        Object object;
        Object object2;
        Object object3;
        block10: {
            Expression<?> expression;
            String colName;
            void $this$modifyColumn_u24lambda_u242;
            block11: {
                StringBuilder stringBuilder;
                Intrinsics.checkNotNullParameter(column, (String)"column");
                Intrinsics.checkNotNullParameter((Object)columnDiff, (String)"columnDiff");
                object3 = new String[1];
                Object object4 = object2 = new StringBuilder();
                int n = 0;
                object = object3;
                boolean bl = false;
                Transaction tr = TransactionManager.Companion.current();
                $this$modifyColumn_u24lambda_u242.append("ALTER TABLE " + tr.identity(column.getTable()) + ' ');
                colName = tr.identity(column);
                if (columnDiff.getAutoInc() && ColumnTypeKt.getAutoIncColumnType(column) != null) {
                    Sequence sequence;
                    AutoIncColumnType<?> autoIncColumnType = ColumnTypeKt.getAutoIncColumnType(column);
                    Sequence sequence2 = sequence = autoIncColumnType != null ? autoIncColumnType.getSequence() : null;
                    if (sequence != null) {
                        $this$modifyColumn_u24lambda_u242.append("ALTER COLUMN " + colName + " TYPE " + column.getColumnType().sqlType());
                        stringBuilder = $this$modifyColumn_u24lambda_u242.append(", ALTER COLUMN " + colName + " DROP DEFAULT");
                    } else {
                        String fallbackSequenceName = TableKt.fallbackSequenceName(column.getTable().getTableName(), column.getName());
                        stringBuilder = $this$modifyColumn_u24lambda_u242.append("ALTER COLUMN " + colName + " SET DEFAULT nextval('" + fallbackSequenceName + "')");
                    }
                } else {
                    stringBuilder = $this$modifyColumn_u24lambda_u242.append("ALTER COLUMN " + colName + " TYPE " + column.getColumnType().sqlType());
                }
                if (columnDiff.getNullability()) {
                    $this$modifyColumn_u24lambda_u242.append(", ALTER COLUMN " + colName + ' ');
                    StringBuilder stringBuilder2 = column.getColumnType().getNullable() ? $this$modifyColumn_u24lambda_u242.append("DROP ") : $this$modifyColumn_u24lambda_u242.append("SET ");
                    $this$modifyColumn_u24lambda_u242.append("NOT NULL");
                }
                if (!columnDiff.getDefaults()) break block10;
                expression = column.getDbDefaultValue$exposed_core();
                if (expression == null) break block11;
                Expression<?> it = expression;
                boolean bl2 = false;
                StringBuilder stringBuilder3 = $this$modifyColumn_u24lambda_u242.append(", ALTER COLUMN " + colName + " SET DEFAULT " + PostgreSQLDataTypeProvider.INSTANCE.processForDefaultValue(it));
                expression = stringBuilder3;
                if (stringBuilder3 != null) break block10;
            }
            void $this$modifyColumn_u24lambda_u242_u24lambda_u241 = $this$modifyColumn_u24lambda_u242;
            boolean bl = false;
            expression = $this$modifyColumn_u24lambda_u242_u24lambda_u241.append(", ALTER COLUMN " + colName + " DROP DEFAULT");
        }
        Unit unit = Unit.INSTANCE;
        object[n] = ((StringBuilder)object2).toString();
        List list2 = CollectionsKt.mutableListOf((Object[])object3);
        if (columnDiff.getAutoInc() && ColumnTypeKt.getAutoIncColumnType(column) != null) {
            AutoIncColumnType<?> autoIncColumnType = ColumnTypeKt.getAutoIncColumnType(column);
            if ((autoIncColumnType != null ? autoIncColumnType.getSequence() : null) == null) {
                void $this$modifyColumn_u24lambda_u243;
                object2 = object3 = new StringBuilder();
                object = list2;
                boolean bl = false;
                String fallbackSequenceName = TableKt.fallbackSequenceName(column.getTable().getTableName(), column.getName());
                String q = StringsKt.contains$default((CharSequence)column.getTable().getTableName(), (char)'.', (boolean)false, (int)2, null) ? "\"" : "";
                $this$modifyColumn_u24lambda_u243.append("ALTER SEQUENCE " + fallbackSequenceName + " OWNED BY " + q + StringsKt.replace$default((String)column.getTable().getTableName(), (String)"\"", (String)"", (boolean)false, (int)4, null) + '.' + column.getName() + q);
                object.add(((StringBuilder)object3).toString());
            }
        }
        return list2;
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return "CREATE DATABASE " + DatabaseDialectKt.inProperCase(name);
    }

    @Override
    @NotNull
    public String listDatabases() {
        return "SELECT datname FROM pg_database";
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return "DROP DATABASE " + DatabaseDialectKt.inProperCase(name);
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return "SET search_path TO " + schema.getIdentifier();
    }

    @Override
    @NotNull
    protected String createIndexWithType(@NotNull String name, @NotNull String table, @NotNull String columns, @NotNull String type, @NotNull String filterCondition) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)filterCondition, (String)"filterCondition");
        return "CREATE INDEX " + name + " ON " + table + " USING " + type + ' ' + columns + filterCondition;
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName, boolean isUnique, boolean isPartialOrFunctional) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        return isUnique && !isPartialOrFunctional ? "ALTER TABLE IF EXISTS " + this.getIdentifierManager().quoteIfNecessary(tableName) + " DROP CONSTRAINT IF EXISTS " + this.getIdentifierManager().quoteIfNecessary(indexName) : "DROP INDEX IF EXISTS " + this.getIdentifierManager().quoteIfNecessary(indexName);
    }

    public PostgreSQLDialect() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/exposed/sql/vendors/PostgreSQLDialect$Companion;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "<init>", "()V", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("PostgreSQL");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

