/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.discordbridge;

import cc.reconnected.discordbridge.RccDiscord;
import cc.reconnected.discordbridge.Utils;
import cc.reconnected.discordbridge.discord.Client;
import java.util.Objects;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.entities.Activity;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.kyori.adventure.text.format.NamedTextColor;
import net.minecraft.class_3222;

public class BridgeEvents {
    public static void register(RccDiscord bridge) {
        Client client = bridge.getClient();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            if (!client.isReady()) {
                return;
            }
            bridge.sendServerStatus(":hourglass: **Server is starting...**", NamedTextColor.YELLOW.value());
            bridge.setStatus(OnlineStatus.DO_NOT_DISTURB, Activity.watching((String)"the server starting"));
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (!client.isReady()) {
                return;
            }
            bridge.sendServerStatus(":up: **Server started!**", NamedTextColor.GREEN.value());
            BridgeEvents.updatePlayerCount(0);
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            if (!client.isReady()) {
                return;
            }
            bridge.sendServerStatus(":electric_plug: **Server is stopping!**", NamedTextColor.RED.value());
            bridge.setStatus(OnlineStatus.DO_NOT_DISTURB, Activity.watching((String)"the server stopping"));
            bridge.getClient().client().shutdown();
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            RccDiscord.LOGGER.info("Attempting rcc-discord force shutdown...");
            try {
                JDA jda = bridge.getClient().client();
                jda.shutdownNow();
            }
            catch (Exception e) {
                RccDiscord.LOGGER.error("Force disconnect rcc-bridge failure", (Throwable)e);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (!client.isReady()) {
                return;
            }
            String playerName = handler.field_14140.method_5476().getString();
            bridge.sendPlayerStatus(String.format("%s joined the server", playerName), NamedTextColor.GREEN.value(), Utils.getAvatarThumbnailUrl(handler.field_14140));
            BridgeEvents.updatePlayerCount(server.method_3760().method_14574() + 1);
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            if (!client.isReady()) {
                return;
            }
            String playerName = handler.field_14140.method_5476().getString();
            bridge.sendPlayerStatus(String.format("%s left the server", playerName), NamedTextColor.RED.value(), Utils.getAvatarThumbnailUrl(handler.field_14140));
            BridgeEvents.updatePlayerCount(server.method_3760().method_14574() - 1);
        });
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (!client.isReady()) {
                return;
            }
            if (!(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
            String message = damageSource.method_5506(entity).getString();
            String avatarUrl = Utils.getAvatarThumbnailUrl(player);
            bridge.sendPlayerStatus(message, NamedTextColor.GRAY.value(), avatarUrl);
        });
        ServerMessageEvents.CHAT_MESSAGE.register((message, sender, params) -> {
            if (!client.isReady()) {
                return;
            }
            String playerName = sender.method_5476().getString();
            String avatarUrl = Utils.getAvatarUrl(sender);
            bridge.sendPlayerMessage(message.method_44862(), playerName, avatarUrl);
        });
        ServerMessageEvents.COMMAND_MESSAGE.register((message, source, params) -> {
            String avatarUrl = source.method_43737() ? Utils.getAvatarUrl(Objects.requireNonNull(source.method_44023())) : RccDiscord.CONFIG.serverAvatarUrl;
            String name = source.method_9223().getString();
            bridge.sendPlayerMessage(message.method_44862(), name, avatarUrl);
        });
    }

    private static void updatePlayerCount(int count) {
        if (!RccDiscord.CONFIG.usePresence) {
            return;
        }
        Object text = "with " + count + " players!";
        if (count <= 0) {
            text = "with no one :(";
        }
        RccDiscord.getInstance().setStatus(OnlineStatus.ONLINE, Activity.playing((String)text));
    }
}

