/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.discordbridge.discord;

import cc.reconnected.discordbridge.ChatComponents;
import cc.reconnected.discordbridge.Colors;
import cc.reconnected.discordbridge.RccDiscord;
import cc.reconnected.discordbridge.discord.Client;
import cc.reconnected.discordbridge.events.DiscordMessageEvents;
import cc.reconnected.discordbridge.parser.MentionNodeParser;
import cc.reconnected.library.RccLibrary;
import cc.reconnected.library.data.PlayerMeta;
import cc.reconnected.library.text.parser.MarkdownParser;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import eu.pb4.placeholders.api.parsers.NodeParser;
import java.awt.Color;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageReference;
import net.dv8tion.jda.api.entities.MessageType;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.UserSnowflake;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.entities.messages.MessageSnapshot;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.message.MessageUpdateEvent;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.json.JSONComponentSerializer;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.node.Node;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class Events {
    private final Cache<String, String> messageCache = Caffeine.newBuilder().maximumSize(5000L).build();

    private boolean isActuallyEdited(String id, String content) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            RccDiscord.LOGGER.error("sha256 no longer exists :(", (Throwable)e);
            return true;
        }
        String digest = new String(messageDigest.digest(content.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        if (!Objects.equals(this.messageCache.get((Object)id, k -> digest), digest)) {
            this.messageCache.put((Object)id, (Object)digest);
            return true;
        }
        return false;
    }

    public void onMessageCreate(MessageReceivedEvent event) {
        Message message = event.getMessage();
        MessageChannelUnion channel = message.getChannel();
        if (!channel.getId().equals(RccDiscord.CONFIG.channelId)) {
            return;
        }
        Member member = event.getMember();
        if (member == null) {
            return;
        }
        if (member.getUser().isBot()) {
            return;
        }
        this.buildMessage(message, member, false);
    }

    public void onMessageEdit(MessageUpdateEvent event) {
        Message message = event.getMessage();
        MessageChannelUnion channel = message.getChannel();
        if (!channel.getId().equals(RccDiscord.CONFIG.channelId)) {
            return;
        }
        Member member = event.getMember();
        if (member == null) {
            return;
        }
        if (member.getUser().isBot()) {
            return;
        }
        this.buildMessage(message, member, true);
    }

    public void buildMessage(Message message, Member member, boolean isEdited) {
        boolean isActuallyEdited = this.isActuallyEdited(message.getId(), message.getContentRaw());
        if (isEdited && !isActuallyEdited) {
            return;
        }
        isEdited = isActuallyEdited;
        if (isEdited) {
            ((DiscordMessageEvents.MessageEdit)DiscordMessageEvents.MESSAGE_EDIT.invoker()).onEdit(message, member);
        } else {
            ((DiscordMessageEvents.MessageCreate)DiscordMessageEvents.MESSAGE_CREATE.invoker()).onCreate(message, member);
        }
        int memberColor = NamedTextColor.WHITE.value();
        Color nullableMemberColor = member.getColor();
        if (nullableMemberColor != null) {
            memberColor = nullableMemberColor.getRGB();
        }
        Component memberComponent = ChatComponents.makeUser(member.getEffectiveName(), member.getAsMention() + ": ", memberColor, (Component)Component.empty());
        Component replyComponent = null;
        if (message.getType() == MessageType.INLINE_REPLY && message.getReferencedMessage() != null) {
            Component referenceMemberComponent;
            Message referencedMessage = message.getReferencedMessage();
            Member referenceMember = referencedMessage.getMember();
            if (referenceMember != null) {
                int referenceMemberColor = NamedTextColor.WHITE.value();
                Color nullableReferenceMemberColor = referenceMember.getColor();
                if (nullableReferenceMemberColor != null) {
                    referenceMemberColor = nullableReferenceMemberColor.getRGB();
                }
                referenceMemberComponent = ChatComponents.makeUser(referenceMember.getEffectiveName(), referenceMember.getAsMention() + ": ", referenceMemberColor, (Component)Component.empty());
            } else if (referencedMessage.getMember() != null) {
                User referenceAuthor = referencedMessage.getAuthor();
                referenceMemberComponent = ChatComponents.makeUser(referenceAuthor.getName(), referenceAuthor.getAsMention() + ": ", NamedTextColor.WHITE.value(), (Component)Component.empty());
            } else {
                User referenceAuthor = referencedMessage.getAuthor();
                referenceMemberComponent = ChatComponents.makeUser(referenceAuthor.getName(), referenceAuthor.getName() + ": ", NamedTextColor.WHITE.value(), (Component)Component.empty());
            }
            replyComponent = ChatComponents.makeReplyHeader(referenceMemberComponent, (Component)Component.text((String)referencedMessage.getContentDisplay()));
        }
        Component forwardComponent = null;
        if (message.getMessageReference() != null && message.getMessageReference().getType() == MessageReference.MessageReferenceType.FORWARD && !message.getMessageSnapshots().isEmpty()) {
            forwardComponent = ChatComponents.makeForwardHeader((Component)Component.text((String)((MessageSnapshot)message.getMessageSnapshots().get(0)).getContentRaw()));
        }
        String messageContent = message.getContentRaw();
        TextComponent messageComponent = Component.empty();
        NodeParser parser = NodeParser.merge((NodeParser[])new NodeParser[]{new MentionNodeParser(message), MarkdownParser.defaultParser});
        class_2561 mdContentVan = parser.parseNode(messageContent).toText();
        String json = class_2561.class_2562.method_10867((class_2561)mdContentVan);
        Component mdContent = JSONComponentSerializer.json().deserialize((Object)json);
        messageComponent = messageComponent.append(mdContent);
        List attachments = message.getAttachments();
        if (!messageContent.isEmpty()) {
            messageComponent = messageComponent.appendSpace();
        }
        for (Message.Attachment attachment : attachments) {
            messageComponent = messageComponent.append(ChatComponents.makeAttachment(attachment.getFileName(), attachment.getUrl()));
            messageComponent = messageComponent.appendSpace();
        }
        Component outputComponent = ChatComponents.makeMessage(memberComponent, replyComponent, forwardComponent, (Component)messageComponent);
        if (isEdited) {
            outputComponent = outputComponent.append((Component)Component.text((String)"(edited)", (TextColor)NamedTextColor.GRAY));
        }
        RccDiscord.enqueueMessage(outputComponent);
    }

    public void onSlashCommandInteraction(SlashCommandInteractionEvent event) {
        switch (event.getName()) {
            case "link": {
                this.onLinkCommand(event);
                break;
            }
            case "list": {
                this.onListCommand(event);
            }
        }
    }

    private void onLinkCommand(SlashCommandInteractionEvent event) {
        OptionMapping codeOption = event.getOption("code");
        if (codeOption == null) {
            event.reply("Please provide a link code via the `/discord link` command in-game.").setEphemeral(true).queue();
            return;
        }
        String code = codeOption.getAsString();
        if (!RccDiscord.linkCodes.containsKey(code)) {
            event.reply("Code not found! Run the `/discord link` command in-game to obtain a link code.").setEphemeral(true).queue();
            return;
        }
        UUID playerUuid = RccDiscord.linkCodes.get(code);
        Optional<class_3222> playerOpt = RccDiscord.getInstance().getPlayer(playerUuid);
        if (playerOpt.isEmpty()) {
            event.reply("You must be online to link your Discord profile!").setEphemeral(true).queue();
            return;
        }
        class_3222 player = playerOpt.get();
        PlayerMeta playerData = PlayerMeta.getPlayer((class_3222)player);
        RccDiscord.discordLinks.put(event.getUser().getId(), playerUuid);
        playerData.set("discord_id", event.getUser().getId()).join();
        RccDiscord.getInstance().saveData();
        Client client = RccDiscord.getInstance().getClient();
        Member member = event.getMember();
        if (member == null) {
            event.reply("You must run this command in a server channel to link your profile!").setEphemeral(true).queue();
            return;
        }
        Role clientRole = client.role();
        if (clientRole != null) {
            try {
                client.guild().addRoleToMember((UserSnowflake)member, clientRole).reason("Linked via link code").queue();
            }
            catch (Exception e) {
                RccDiscord.LOGGER.error("Could not add role to player", (Throwable)e);
            }
        }
        try {
            member.modifyNickname(playerData.getUsername()).reason("Linked via link code").queue();
        }
        catch (Exception e) {
            RccDiscord.LOGGER.error("Could not modify nickname", (Throwable)e);
        }
        LuckPerms luckperms = RccLibrary.getInstance().luckPerms();
        luckperms.getUserManager().modifyUser(playerUuid, user -> user.data().add((Node)Node.builder((String)RccDiscord.CONFIG.linkedPermissionNode).build()));
        RccDiscord.linkCodes.remove(code);
        event.reply("Your Discord profile is now linked with **" + playerData.getUsername() + "**!").setEphemeral(true).queue();
        TextComponent text = (TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append((Component)Component.text((String)"You linked your profile to "))).append(Component.text((String)member.getEffectiveName()).color(Colors.BLURPLE))).append((Component)Component.text((String)" on Discord!"))).color((TextColor)NamedTextColor.GREEN);
        player.sendMessage((Component)text);
    }

    private void onListCommand(SlashCommandInteractionEvent event) {
        CharSequence[] list = RccDiscord.getInstance().getPlayerNames();
        Object players = list.length == 0 ? "*There are no players online*" : "**Online players**: " + String.join((CharSequence)", ", list);
        event.reply((String)players).setEphemeral(true).queue();
    }
}

