/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.kromer;

import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;

public class ConcurrentLRUCache<K, V> {
    private final int capacity;
    private final Map<K, V> map = new ConcurrentHashMap();
    private final Deque<K> order = new ConcurrentLinkedDeque<K>();

    public ConcurrentLRUCache(int capacity) {
        this.capacity = capacity;
    }

    public synchronized void put(K key, V value) {
        if (this.map.containsKey(key)) {
            this.order.remove(key);
        } else if (this.map.size() >= this.capacity) {
            this.map.remove(this.order.removeFirst());
        }
        this.map.put(key, value);
        this.order.addLast(key);
    }

    public synchronized V get(K key) {
        if (!this.map.containsKey(key)) {
            return null;
        }
        this.order.remove(key);
        this.order.addLast(key);
        return this.map.get(key);
    }

    public String toString() {
        return this.map.toString();
    }
}

