/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.kromer;

import cc.reconnected.kromer.ConcurrentLRUCache;
import cc.reconnected.kromer.ConfigurationModel;
import cc.reconnected.kromer.KromerWebsockets;
import cc.reconnected.kromer.Locale;
import cc.reconnected.kromer.arguments.AddressArgumentType;
import cc.reconnected.kromer.arguments.KromerArgumentInfo;
import cc.reconnected.kromer.arguments.KromerArgumentType;
import cc.reconnected.kromer.commands.BalanceCommand;
import cc.reconnected.kromer.commands.KromerCommand;
import cc.reconnected.kromer.commands.PayCommand;
import cc.reconnected.kromer.commands.TransactionsCommand;
import cc.reconnected.kromer.common.CommonMetaParser;
import cc.reconnected.kromer.database.Database;
import cc.reconnected.kromer.database.Wallet;
import cc.reconnected.kromer.database.WelfareData;
import cc.reconnected.kromer.networking.BalanceRequestPacket;
import cc.reconnected.kromer.networking.BalanceResponsePacket;
import cc.reconnected.kromer.networking.TransactionPacket;
import com.mojang.authlib.GameProfile;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigBeanFactory;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.modules.afk.AfkModule;
import me.alexdevs.solstice.modules.afk.data.AfkPlayerData;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.server.MinecraftServer;
import org.flywaydb.core.Flyway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ovh.sad.jkromer.http.Result;
import ovh.sad.jkromer.http.addresses.GetAddress;
import ovh.sad.jkromer.http.internal.CreateWallet;
import ovh.sad.jkromer.http.internal.GiveMoney;
import ovh.sad.jkromer.http.misc.StartWs;
import ovh.sad.jkromer.jKromer;
import ovh.sad.jkromer.models.Transaction;

public class Kromer
implements DedicatedServerModInitializer {
    public static Logger LOGGER = LoggerFactory.getLogger((String)"rcc-kromer");
    public static Database database = new Database();
    public static final ExecutorService NETWORK_EXECUTOR = Executors.newCachedThreadPool();
    public static ConfigurationModel config;
    private static KromerWebsockets client;
    public static Boolean kromerStatus;
    public static int welfareQueued;
    public static ConcurrentLRUCache<String, Float> balanceCache;

    public static void connectWebsocket(final MinecraftServer server) throws URISyntaxException {
        LOGGER.debug("Connecting to Websocket..");
        ((CompletableFuture)CompletableFuture.supplyAsync(StartWs::execute, NETWORK_EXECUTOR).thenCompose(f -> f)).whenComplete((b, ex) -> {
            if (b instanceof Result.Ok) {
                Result.Ok ok = (Result.Ok)b;
                LOGGER.debug("Websocket URL found: {}", (Object)((StartWs.StartWsResponse)ok.value()).url);
                try {
                    client = new KromerWebsockets(new URI(((StartWs.StartWsResponse)ok.value()).url), server);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                client.connect();
                LOGGER.debug("Websocket connected.");
            } else if (b instanceof Result.Err) {
                LOGGER.debug("Websocket URL was not found. Retrying in 1 second.");
                new Timer("WebSocket-Retry", true).schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            Kromer.connectWebsocket(server);
                        }
                        catch (URISyntaxException ex2) {
                            throw new RuntimeException(ex2);
                        }
                    }
                }, 1000L);
            }
        });
    }

    public void onInitializeServer() {
        ArgumentTypeRegistry.registerArgumentType((class_2960)new class_2960("rcc-kromer", "kromer_amount"), KromerArgumentType.class, (class_2314)new KromerArgumentInfo());
        ArgumentTypeRegistry.registerArgumentType((class_2960)new class_2960("rcc-kromer", "kromer_address"), AddressArgumentType.class, (class_2314)class_2319.method_41999(AddressArgumentType::address));
        Flyway flyway = Flyway.configure().dataSource("jdbc:sqlite:rcc-kromer.sqlite", null, null).baselineOnMigrate(true).load();
        flyway.migrate();
        Solstice.playerData.registerData(Solstice.ID.method_45136("welfare"), WelfareData.class, WelfareData::new);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)BalanceRequestPacket.ID, (server, player, handler, buf, responseSender) -> server.execute(() -> {
            Wallet wallet = database.getWallet(player.method_5667());
            if (wallet == null) {
                LOGGER.error("BalanceRequestPacket: user " + player.method_5667().toString() + " has no valid wallet.");
                return;
            }
            AtomicReference<Float> balance = new AtomicReference<Float>(balanceCache.get(wallet.address));
            if (balance.get() == null) {
                ((CompletableFuture)CompletableFuture.supplyAsync(() -> GetAddress.execute((String)wallet.address), NETWORK_EXECUTOR).thenCompose(future -> future)).whenComplete((b, ex) -> {
                    if (ex != null) {
                        LOGGER.error("BalanceRequestPacket: for user " + player.method_5667().toString() + " failed balance retrival due to " + ex.getMessage());
                        return;
                    }
                    if (b instanceof Result.Ok) {
                        Result.Ok ok = (Result.Ok)b;
                        balance.set(Float.valueOf(((GetAddress.GetAddressBody)ok.value()).address.balance));
                        balanceCache.put(wallet.address, Float.valueOf(((GetAddress.GetAddressBody)ok.value()).address.balance));
                    } else if (b instanceof Result.Err) {
                        Result.Err err = (Result.Err)b;
                        LOGGER.error("BalanceRequestPacket: for user " + player.method_5667().toString() + " failed balance retrival due to " + err.toString());
                        return;
                    }
                });
            }
            if (balance.get() == null) {
                return;
            }
            ServerPlayNetworking.send((class_3222)player, (class_2960)BalanceResponsePacket.ID, (class_2540)BalanceResponsePacket.serialise(balance.get().floatValue()));
        }));
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            try {
                Kromer.connectWebsocket(server);
            }
            catch (URISyntaxException u) {
                u.printStackTrace();
            }
        });
        ServerPlayConnectionEvents.JOIN.register((a, b, c) -> {
            if (client == null) {
                LOGGER.error("Websocket client is null, cannot grant wallet nor calculate welfare.");
                return;
            }
            Kromer.grantWallet(a.field_14140.method_5820(), a.field_14140.method_5667(), a.field_14140);
            Kromer.checkTransfers(a.field_14140);
            float finalWelfare = Kromer.calculateWelfare();
            Kromer.executeWelfareForPlayer(a.field_14140, finalWelfare);
        });
        CommandRegistrationCallback.EVENT.register(PayCommand::register);
        CommandRegistrationCallback.EVENT.register(BalanceCommand::register);
        CommandRegistrationCallback.EVENT.register(KromerCommand::register);
        CommandRegistrationCallback.EVENT.register(TransactionsCommand::register);
        config = (ConfigurationModel)ConfigBeanFactory.create((Config)ConfigFactory.parseFile((File)FabricLoader.getInstance().getConfigDir().resolve("rcc-kromer.hocon").toFile(), (ConfigParseOptions)ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF)), ConfigurationModel.class);
        jKromer.endpoint_raw = Kromer.config.url;
        jKromer.endpoint = jKromer.endpoint_raw + "/api/krist";
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        long initialDelay = Kromer.getDelayUntilNextHourInSeconds();
        long oneHour = 3600L;
        scheduler.scheduleAtFixedRate(() -> {
            if (!kromerStatus.booleanValue()) {
                ++welfareQueued;
                return;
            }
            Kromer.executeWelfare();
        }, initialDelay, oneHour, TimeUnit.SECONDS);
    }

    private static float calculateWelfare() {
        if (client == null) {
            LOGGER.error("Websocket client is null, cannot calculate welfare.");
            return 0.0f;
        }
        List<class_3222> playersWithSupporter = Kromer.client.server.method_3760().method_14571().stream().filter(z -> Permissions.check((class_1297)z, (String)Kromer.config.supporter.group) && !Permissions.check((class_1297)z, (String)Kromer.config.bot)).toList();
        List<class_3222> playersWithoutSupporter = Kromer.client.server.method_3760().method_14571().stream().filter(z -> !Permissions.check((class_1297)z, (String)Kromer.config.supporter.group) && !Permissions.check((class_1297)z, (String)Kromer.config.bot)).toList();
        float welfare = Kromer.config.welfare;
        if (!playersWithSupporter.isEmpty() && !playersWithoutSupporter.isEmpty()) {
            welfare = Kromer.config.welfare * (Kromer.config.supporter.multiplier * (float)playersWithSupporter.size());
        }
        return welfare;
    }

    public static void executeWelfare() {
        if (client == null) {
            LOGGER.error("Websocket client is null, cannot execute welfare.");
            return;
        }
        float finalWelfare = Kromer.calculateWelfare();
        Kromer.client.server.method_3760().method_14571().forEach(p -> Kromer.executeWelfareForPlayer(p, finalWelfare));
    }

    private static void executeWelfareForPlayer(class_3222 player, float baseWelfare) {
        if (baseWelfare == 0.0f) {
            return;
        }
        if (Kromer.config.bot != null && Permissions.check((class_1297)player, (String)Kromer.config.bot)) {
            return;
        }
        Wallet wallet = database.getWallet(player.method_5667());
        if (wallet == null) {
            return;
        }
        WelfareData welfareData = (WelfareData)Solstice.playerData.get(player.method_5667()).getData(WelfareData.class);
        int interval = 3600;
        AfkPlayerData solsticeData = ((AfkModule)Solstice.modules.getModule(AfkModule.class).get()).getPlayerData(player.method_5667());
        int activeTime = solsticeData.activeTime;
        int oldActiveTime = welfareData.oldActiveTime;
        float deltaActiveTime = activeTime - oldActiveTime;
        float relativeDeltaActiveTime = deltaActiveTime / (float)interval;
        float finalWelfare = (float)Math.round(baseWelfare * relativeDeltaActiveTime * 100.0f) / 100.0f;
        if (finalWelfare == 0.0f) {
            return;
        }
        if (!welfareData.welfareMuted && !welfareData.optedOut) {
            player.method_43496(Locale.use(Locale.Messages.WELFARE_GIVEN, Float.valueOf(finalWelfare)));
        }
        if (!welfareData.optedOut) {
            CompletableFuture.supplyAsync(() -> GiveMoney.execute((String)Kromer.config.internal_key, (float)finalWelfare, (String)wallet.address), NETWORK_EXECUTOR).thenCompose(f -> f);
        }
        welfareData.oldActiveTime = activeTime;
    }

    public static String getNameFromWallet(String address) {
        Optional gf;
        String userName = address;
        class_3545<UUID, Wallet> fromWallet = database.getWallet(userName);
        if (fromWallet != null && (gf = Objects.requireNonNull(Kromer.client.server.method_3793()).method_14512((UUID)fromWallet.method_15442())).isPresent()) {
            userName = ((GameProfile)gf.get()).getName();
        }
        boolean found = !Objects.equals(userName, address);
        return found ? String.format("%s (%s)", userName, address) : address;
    }

    public static void notifyTransfer(class_3222 player, Transaction transaction) {
        CommonMetaParser.ParseResult result = CommonMetaParser.parseWithResult(transaction.metadata);
        if (result.success) {
            if (result.pairs.containsKey("message")) {
                player.method_43496(Locale.useSafe(Locale.Messages.NOTIFY_TRANSFER_MESSAGE, Float.valueOf(transaction.value), Kromer.getNameFromWallet(transaction.from), result.pairs.get("message")));
                Float balVal = balanceCache.get(transaction.to);
                if (balanceCache == null) {
                    balVal = Float.valueOf(-1.0f);
                } else {
                    balVal = Float.valueOf(balVal.floatValue() + transaction.value);
                    balanceCache.put(transaction.to, balVal);
                }
                ServerPlayNetworking.send((class_3222)player, (class_2960)TransactionPacket.ID, (class_2540)TransactionPacket.serialise(transaction, balVal));
            } else {
                player.method_43496(Locale.use(Locale.Messages.NOTIFY_TRANSFER, Float.valueOf(transaction.value), Kromer.getNameFromWallet(transaction.from)));
            }
        } else {
            player.method_43496(Locale.use(Locale.Messages.NOTIFY_TRANSFER, Float.valueOf(transaction.value), Kromer.getNameFromWallet(transaction.from)));
        }
    }

    public static void checkTransfers(class_3222 player) {
        Transaction transaction;
        int i;
        Wallet wallet = database.getWallet(player.method_5667());
        if (wallet == null) {
            return;
        }
        if (wallet.outgoingNotSeen.length != 0) {
            for (i = 0; i < wallet.outgoingNotSeen.length; ++i) {
                transaction = wallet.outgoingNotSeen[i];
                player.method_43496(Locale.use(Locale.Messages.OUTGOING_NOT_SEEN, Float.valueOf(transaction.value), Kromer.getNameFromWallet(transaction.to), transaction.time.toString()));
            }
        }
        if (wallet.incomingNotSeen.length != 0) {
            for (i = 0; i < wallet.incomingNotSeen.length; ++i) {
                transaction = wallet.incomingNotSeen[i];
                player.method_43496(Locale.use(Locale.Messages.INCOMING_NOT_SEEN, Kromer.getNameFromWallet(transaction.from), Float.valueOf(transaction.value), transaction.time.toString()));
            }
        }
        wallet.incomingNotSeen = new Transaction[0];
        wallet.outgoingNotSeen = new Transaction[0];
        database.setWallet(player.method_5667(), wallet);
    }

    private static long getDelayUntilNextHourInSeconds() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime nextHour = now.plusHours(1L).withMinute(0).withSecond(0).withNano(0);
        Duration duration = Duration.between(now, nextHour);
        return duration.getSeconds();
    }

    public static void grantWallet(String name, UUID uuid, class_3222 player) {
        AfkPlayerData solsticeData = ((AfkModule)Solstice.modules.getModule(AfkModule.class).get()).getPlayerData(uuid);
        WelfareData welfareData = (WelfareData)Solstice.playerData.get(player.method_5667()).getData(WelfareData.class);
        if (welfareData.oldActiveTime == 0) {
            welfareData.oldActiveTime = solsticeData.activeTime;
        }
        if (database.getWallet(uuid) != null) {
            return;
        }
        float kroAmountRaw = (float)((double)solsticeData.activeTime / 3600.0 * (double)Kromer.config.welfare);
        float kroAmount = (float)Math.round(kroAmountRaw * 100.0f) / 100.0f;
        if (kroAmount != 0.0f) {
            player.method_43496(Locale.use(Locale.Messages.RETROACTIVE, Float.valueOf(kroAmount)));
        }
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> CreateWallet.execute((String)Kromer.config.internal_key, (String)name, (String)uuid.toString()), NETWORK_EXECUTOR).thenCompose(f -> f)).whenComplete((createWalletResult, ex) -> {
            if (ex != null) {
                LOGGER.error("Failed to create wallet for user " + name, ex);
                return;
            }
            if (createWalletResult instanceof Result.Ok) {
                Result.Ok createWallet = (Result.Ok)createWalletResult;
                Transaction[] array = new Transaction[]{};
                Wallet wallet = new Wallet(((CreateWallet.CreateWalletResponse)createWallet.value()).address, ((CreateWallet.CreateWalletResponse)createWallet.value()).privatekey, array, array);
                database.setWallet(uuid, wallet);
                if (kroAmount != 0.0f) {
                    ((CompletableFuture)CompletableFuture.supplyAsync(() -> GiveMoney.execute((String)Kromer.config.internal_key, (float)kroAmount, (String)((CreateWallet.CreateWalletResponse)createWallet.value()).address), NETWORK_EXECUTOR).thenCompose(f -> f)).whenComplete((giveMoneyResult, ex2) -> {
                        if (ex2 != null) {
                            LOGGER.error("Failed to give retroactive kro to " + name, ex2);
                        }
                    });
                }
            } else if (createWalletResult instanceof Result.Err) {
                Result.Err err = (Result.Err)createWalletResult;
                LOGGER.warn("Was not able to give user " + name + " their wallet. " + err.error().error() + ", param: " + err.error().parameter());
            }
        });
    }

    static {
        kromerStatus = false;
        welfareQueued = 0;
        balanceCache = new ConcurrentLRUCache(500);
    }
}

