/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.kromer;

import cc.reconnected.kromer.Kromer;
import cc.reconnected.kromer.database.Wallet;
import com.google.gson.Gson;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.server.MinecraftServer;
import ovh.sad.jkromer.models.Transaction;
import ovh.sad.jkromer.websocket.AbstractKromerClient;

public class KromerWebsockets
extends AbstractKromerClient {
    public final MinecraftServer server;

    public KromerWebsockets(URI uri, MinecraftServer server) {
        super(uri, new Gson());
        this.server = server;
    }

    protected void onConnected() {
        Kromer.kromerStatus = true;
        for (int i = 0; i < Kromer.welfareQueued; ++i) {
            Kromer.executeWelfare();
        }
        Kromer.welfareQueued = 0;
    }

    protected void onDisconnected(int code, String reason, boolean remote) {
        Kromer.kromerStatus = false;
    }

    protected void onTransactionReceived(Transaction tx) {
        class_3222 fromPlayer;
        class_3545<UUID, Wallet> toWallet = Kromer.database.getWallet(tx.to);
        class_3545<UUID, Wallet> fromWallet = Kromer.database.getWallet(tx.from);
        if (toWallet == null) {
            return;
        }
        class_3222 toPlayer = this.server.method_3760().method_14602((UUID)toWallet.method_15442());
        if (toPlayer == null) {
            Wallet realWallet = (Wallet)toWallet.method_15441();
            realWallet.incomingNotSeen = this.appendTransaction(realWallet.incomingNotSeen, tx);
            Kromer.database.setWallet((UUID)toWallet.method_15442(), realWallet);
        } else {
            Kromer.notifyTransfer(toPlayer, tx);
        }
        if (fromWallet != null && (fromPlayer = this.server.method_3760().method_14602((UUID)fromWallet.method_15442())) == null) {
            Wallet realWallet = (Wallet)fromWallet.method_15441();
            realWallet.outgoingNotSeen = this.appendTransaction(realWallet.outgoingNotSeen, tx);
            Kromer.database.setWallet((UUID)fromWallet.method_15442(), realWallet);
        }
    }

    protected void onUnknownMessage(String eventType, String rawMessage) {
    }

    protected void reconnectClient() {
        try {
            Kromer.connectWebsocket(this.server);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Transaction[] appendTransaction(Transaction[] arr, Transaction tx) {
        ArrayList<Transaction> list = new ArrayList<Transaction>(List.of(arr));
        list.add(tx);
        return list.toArray(new Transaction[0]);
    }
}

