/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.kromer.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;

public class AddressArgumentType
implements ArgumentType<String> {
    private static final Collection<String> EXAMPLES = Arrays.asList("kr0merwelf", "reconnected.kro", "meta@reconnected.kro", "hartbreix", "g6ys", "Dimaguy", "EmmaKnijn");

    public static boolean isAllowed(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '@' || c == '.' || c == '_';
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        int amountOfDots = 0;
        int amountofAts = 0;
        while (reader.canRead() && AddressArgumentType.isAllowed(reader.peek())) {
            if (reader.peek() == '.') {
                if (++amountOfDots > 1) {
                    throw new SimpleCommandExceptionType((Message)new LiteralMessage("Unexpected .")).createWithContext((ImmutableStringReader)reader);
                }
            } else if (reader.peek() == '@' && ++amountofAts > 1) {
                throw new SimpleCommandExceptionType((Message)new LiteralMessage("Unexpected @")).createWithContext((ImmutableStringReader)reader);
            }
            reader.skip();
        }
        String result = reader.getString().substring(start, reader.getCursor());
        return result;
    }

    private AddressArgumentType() {
    }

    public static AddressArgumentType address() {
        return new AddressArgumentType();
    }

    public static String getAddress(CommandContext<?> context, String name) {
        return (String)context.getArgument(name, String.class);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

