/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.kromer.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;

public class KromerArgumentType
implements ArgumentType<BigDecimal> {
    private static final Collection<String> EXAMPLES = Arrays.asList("1", "1.2", "1.23", ".5", ".12", "1234.56");
    private static final Collection<String> EXAMPLESWITHNEGATIVEVALS = Arrays.asList("1", "-1.2", "1.23", ".5", ".12", "-1234.56");
    private final boolean allowNegativeValues;
    private final boolean allowZero;

    private KromerArgumentType(boolean allowNegativeValues, boolean allowZero) {
        this.allowNegativeValues = allowNegativeValues;
        this.allowZero = allowZero;
    }

    public static KromerArgumentType kromerArg() {
        return KromerArgumentType.kromerArg(false, false);
    }

    public static KromerArgumentType kromerArg(boolean allowNegativeValues, boolean allowZero) {
        return new KromerArgumentType(allowNegativeValues, allowZero);
    }

    public static BigDecimal getBigDecimal(CommandContext<?> context, String name) {
        return (BigDecimal)context.getArgument(name, BigDecimal.class);
    }

    public boolean getAllowNegativeValues() {
        return this.allowNegativeValues;
    }

    public boolean getAllowZero() {
        return this.allowZero;
    }

    public BigDecimal parse(StringReader reader) throws CommandSyntaxException {
        float value = reader.readFloat();
        if (!this.allowNegativeValues && value < 0.0f) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidFloat().createWithContext((ImmutableStringReader)reader, (Object)String.valueOf(value));
        }
        if (!this.allowZero && value == 0.0f) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidFloat().createWithContext((ImmutableStringReader)reader, (Object)String.valueOf(value));
        }
        return new BigDecimal(value, new MathContext(2, RoundingMode.DOWN));
    }

    public Collection<String> getExamples() {
        return this.allowNegativeValues ? EXAMPLESWITHNEGATIVEVALS : EXAMPLES;
    }
}

