/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.kromer.client;

import cc.reconnected.kromer.arguments.AddressArgumentType;
import cc.reconnected.kromer.arguments.KromerArgumentInfo;
import cc.reconnected.kromer.arguments.KromerArgumentType;
import cc.reconnected.kromer.networking.BalanceRequestPacket;
import cc.reconnected.kromer.networking.BalanceResponsePacket;
import cc.reconnected.kromer.networking.TransactionPacket;
import io.netty.buffer.Unpooled;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_433;
import net.minecraft.class_437;
import ovh.sad.jkromer.models.Transaction;

@Environment(value=EnvType.CLIENT)
public class mainClient
implements ClientModInitializer {
    private final AtomicReference<Float> balance = new AtomicReference<Float>(Float.valueOf(-1.0f));
    private boolean initialBalanceRequested = false;

    public void onInitializeClient() {
        ArgumentTypeRegistry.registerArgumentType((class_2960)new class_2960("rcc-kromer", "kromer_amount"), KromerArgumentType.class, (class_2314)new KromerArgumentInfo());
        ArgumentTypeRegistry.registerArgumentType((class_2960)new class_2960("rcc-kromer", "kromer_address"), AddressArgumentType.class, (class_2314)class_2319.method_41999(AddressArgumentType::address));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!this.initialBalanceRequested && client.field_1724 != null && client.method_1562().method_48296().method_10758()) {
                ClientPlayNetworking.send((class_2960)BalanceRequestPacket.ID, (class_2540)new class_2540(Unpooled.buffer()));
                this.initialBalanceRequested = true;
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)TransactionPacket.ID, (client, handler, buf, responseSender) -> {
            Transaction tx = TransactionPacket.readTransaction(buf);
            float bal = buf.readFloat();
            if (bal != -1.0f) {
                this.balance.set(Float.valueOf(bal));
            }
            if (client.method_1566().field_2240.size() < 3) {
                client.method_1566().method_1999((class_368)class_370.method_29047((class_310)client, (class_370.class_371)class_370.class_371.field_2218, (class_2561)class_2561.method_43470((String)"Transaction"), (class_2561)class_2561.method_43470((String)("Incoming " + tx.value + "KRO from " + tx.from + "! Balance is now " + String.format("%.2fKRO", Math.floor(this.balance.get().floatValue() * 100.0f) / 100.0)))));
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)BalanceResponsePacket.ID, (client, handler, buf, responseSender) -> this.balance.set(Float.valueOf(buf.readFloat())));
        ScreenEvents.AFTER_INIT.register((mc, screen, sw, sh) -> {
            if (screen instanceof class_433) {
                ScreenEvents.afterRender((class_437)screen).register((scr, guiGraphics, mouseX, mouseY, tickDelta) -> {
                    int x = 10;
                    int y = 10;
                    guiGraphics.method_51433(mc.field_1772, "Balance: ", x, y, 0x55FF55, true);
                    x += mc.field_1772.method_1727("Balance: ");
                    Float bal = this.balance.get();
                    if (bal.floatValue() == -1.0f) {
                        guiGraphics.method_51433(mc.field_1772, "Loading..", x, y, 0xAAAAAA, true);
                    } else if (bal.floatValue() == -2.0f) {
                        guiGraphics.method_51433(mc.field_1772, "Error..", x, y, 0xAA0000, true);
                    } else {
                        String balStr = String.format("%.2fKRO", Math.floor(bal.floatValue() * 100.0f) / 100.0);
                        guiGraphics.method_51433(mc.field_1772, balStr, x, y, 43520, true);
                    }
                });
            }
        });
    }
}

