/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.kromer.commands;

import cc.reconnected.kromer.Kromer;
import cc.reconnected.kromer.Locale;
import cc.reconnected.kromer.arguments.AddressArgumentType;
import cc.reconnected.kromer.database.Wallet;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import ovh.sad.jkromer.http.Result;
import ovh.sad.jkromer.http.addresses.GetAddress;

public class BalanceCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"balance").then(class_2170.method_9244((String)"recipient", (ArgumentType)AddressArgumentType.address()).executes(e -> BalanceCommand.runBalance((CommandContext<class_2168>)e, true)))).executes(e -> BalanceCommand.runBalance((CommandContext<class_2168>)e, false)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"bal").then(class_2170.method_9244((String)"recipient", (ArgumentType)AddressArgumentType.address()).executes(e -> BalanceCommand.runBalance((CommandContext<class_2168>)e, true)))).executes(e -> BalanceCommand.runBalance((CommandContext<class_2168>)e, false)));
    }

    private static int runBalance(CommandContext<class_2168> context, boolean hasRecipient) {
        String kristAddress;
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        assert (player != null);
        if (hasRecipient) {
            String recipientInput = AddressArgumentType.getAddress(context, "recipient");
            if (recipientInput.matches("^k[a-z0-9]{9}$") || recipientInput.matches("^(?:([a-z0-9-_]{1,32})@)?([a-z0-9]{1,64})\\.kro$")) {
                kristAddress = recipientInput;
            } else {
                GameProfile otherProfile;
                try {
                    otherProfile = ((class_2168)context.getSource()).method_9211().method_3793().method_14515(recipientInput).orElse(null);
                }
                catch (Exception e) {
                    otherProfile = null;
                }
                if (otherProfile == null) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"User not found and not a valid address.").method_27692(class_124.field_1061), false);
                    return 0;
                }
                Wallet otherWallet = Kromer.database.getWallet(otherProfile.getId());
                if (otherWallet == null) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Other user does not have a wallet. They haven't joined recently.").method_27692(class_124.field_1061), false);
                    return 0;
                }
                kristAddress = otherWallet.address;
            }
        } else {
            kristAddress = null;
        }
        Wallet myWallet = Kromer.database.getWallet(player.method_5667());
        if (!Kromer.kromerStatus.booleanValue()) {
            ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.KROMER_UNAVAILABLE, new Object[0]), false);
            return 0;
        }
        if (myWallet == null) {
            ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.NO_WALLET, new Object[0]), false);
            return 0;
        }
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> GetAddress.execute((String)(kristAddress == null ? myWallet.address : kristAddress)), Kromer.NETWORK_EXECUTOR).thenCompose(future -> future)).whenComplete((b, ex) -> {
            if (ex != null) {
                source.method_9211().execute(() -> source.method_9226(() -> Locale.use(Locale.Messages.ERROR, ex.getMessage()), false));
                return;
            }
            if (b instanceof Result.Ok) {
                Result.Ok ok = (Result.Ok)b;
                if (kristAddress == null) {
                    source.method_9211().execute(() -> {
                        source.method_9226(() -> Locale.use(Locale.Messages.BALANCE, Float.valueOf(((GetAddress.GetAddressBody)ok.value()).address.balance)), false);
                        Kromer.balanceCache.put(myWallet.address, Float.valueOf(((GetAddress.GetAddressBody)ok.value()).address.balance));
                    });
                } else {
                    source.method_9211().execute(() -> {
                        source.method_9226(() -> Locale.use(Locale.Messages.BALANCE_OTHERS, kristAddress, Float.valueOf(((GetAddress.GetAddressBody)ok.value()).address.balance)), false);
                        Kromer.balanceCache.put(kristAddress, Float.valueOf(((GetAddress.GetAddressBody)ok.value()).address.balance));
                    });
                }
            } else if (b instanceof Result.Err) {
                Result.Err err = (Result.Err)b;
                source.method_9211().execute(() -> source.method_9226(() -> Locale.use(Locale.Messages.ERROR, err.error()), false));
            }
        });
        return 1;
    }
}

