/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.kromer.commands;

import cc.reconnected.kromer.Kromer;
import cc.reconnected.kromer.Locale;
import cc.reconnected.kromer.arguments.KromerArgumentType;
import cc.reconnected.kromer.database.Wallet;
import cc.reconnected.kromer.database.WelfareData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.alexdevs.solstice.Solstice;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import ovh.sad.jkromer.http.Result;
import ovh.sad.jkromer.http.addresses.GetAddress;
import ovh.sad.jkromer.http.internal.GiveMoney;
import ovh.sad.jkromer.http.misc.GetMotd;
import ovh.sad.jkromer.http.transactions.MakeTransaction;

public class KromerCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        LiteralArgumentBuilder versionCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"version").executes(context -> {
            String modVersion = ((ModContainer)FabricLoader.getInstance().getModContainer("rcc-kromer").get()).getMetadata().getVersion().getFriendlyString();
            ((CompletableFuture)CompletableFuture.supplyAsync(() -> GetMotd.execute(), Kromer.NETWORK_EXECUTOR).thenCompose(f -> f)).whenComplete((b, ex) -> {
                if (ex != null) {
                    ((class_2168)context.getSource()).method_9211().execute(() -> ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.ERROR, ex.getMessage()), false));
                    return;
                }
                if (b instanceof Result.Ok) {
                    Result.Ok ok = (Result.Ok)b;
                    ((class_2168)context.getSource()).method_9211().execute(() -> ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.VERSION, modVersion, ((GetMotd.GetMotdBody)ok.value()).motdPackage.version), false));
                } else if (b instanceof Result.Err) {
                    Result.Err err = (Result.Err)b;
                    ((class_2168)context.getSource()).method_9211().execute(() -> ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.ERROR, err.error()), false));
                }
            });
            return 1;
        });
        LiteralArgumentBuilder infoCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"info").executes(context -> {
            Wallet wallet = Kromer.database.getWallet(((class_2168)context.getSource()).method_44023().method_5667());
            if (wallet == null) {
                return 0;
            }
            ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.KROMER_INFORMATION, wallet.address, wallet.address, wallet.privatekey, wallet.privatekey), false);
            if (!Kromer.kromerStatus.booleanValue()) {
                ((class_2168)context.getSource()).method_9226(class_2561::method_43473, false);
                ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.KROMER_UNAVAILABLE, new Object[0]), false);
                return 0;
            }
            return 1;
        });
        LiteralArgumentBuilder giveWalletCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"givewallet").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            Kromer.grantWallet(player.method_5820(), player.method_5667(), player);
            return 1;
        }));
        LiteralArgumentBuilder setMoneyCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"addMoney").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"amount", (ArgumentType)KromerArgumentType.kromerArg()).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            BigDecimal amount = KromerArgumentType.getBigDecimal(context, "amount");
            ((CompletableFuture)CompletableFuture.supplyAsync(() -> GiveMoney.execute((String)Kromer.config.internal_key, (float)amount.floatValue(), (String)Kromer.database.getWallet((UUID)player.method_5667()).address), Kromer.NETWORK_EXECUTOR).thenCompose(f -> f)).whenComplete((b, ex) -> {
                if (ex != null) {
                    ((class_2168)context.getSource()).method_9211().execute(() -> ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.ERROR, ex.getMessage()), false));
                    return;
                }
                if (b instanceof Result.Ok) {
                    Result.Ok ok = (Result.Ok)b;
                    ((class_2168)context.getSource()).method_9211().execute(() -> ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.ADDED_KRO, amount, player.method_5820()), false));
                } else if (b instanceof Result.Err) {
                    Result.Err err = (Result.Err)b;
                    ((class_2168)context.getSource()).method_9211().execute(() -> ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.ERROR, err.error()), false));
                }
            });
            return 1;
        })));
        LiteralArgumentBuilder executeWelfare = (LiteralArgumentBuilder)class_2170.method_9247((String)"welfare").executes(context -> {
            Kromer.executeWelfare();
            return 1;
        });
        LiteralArgumentBuilder muteWelfare = (LiteralArgumentBuilder)class_2170.method_9247((String)"muteWelfare").executes(context -> {
            WelfareData welfareData = (WelfareData)Solstice.playerData.get(Objects.requireNonNull(((class_2168)context.getSource()).method_44023()).method_5667()).getData(WelfareData.class);
            if (welfareData.welfareMuted) {
                ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.WELFARE_NOT_MUTED, new Object[0]), false);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.WELFARE_MUTED, new Object[0]), false);
            }
            welfareData.welfareMuted = !welfareData.welfareMuted;
            return 1;
        });
        LiteralArgumentBuilder optInOfWelfare = (LiteralArgumentBuilder)class_2170.method_9247((String)"optIn").executes(context -> {
            WelfareData welfareData = (WelfareData)Solstice.playerData.get(((class_2168)context.getSource()).method_44023().method_5667()).getData(WelfareData.class);
            if (welfareData.optedOut) {
                welfareData.optedOut = false;
                ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.OPTED_IN_WELFARE, new Object[0]), false);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.ALREADY_OPTED_IN, new Object[0]), false);
            }
            return 1;
        });
        LiteralArgumentBuilder optOutOfWelfare = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"optOut").executes(context -> {
            WelfareData welfareData = (WelfareData)Solstice.playerData.get(((class_2168)context.getSource()).method_44023().method_5667()).getData(WelfareData.class);
            if (welfareData.optedOut) {
                ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.ALREADY_OPTED_OUT, new Object[0]), false);
                return 0;
            }
            ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.OPTOUT_WARNING, new Object[0]), false);
            ((class_2168)context.getSource()).method_9226(class_2561::method_43473, false);
            ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.OPTOUT_INFO, new Object[0]), false);
            ((class_2168)context.getSource()).method_9226(class_2561::method_43473, false);
            ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.CONFIRM_OPTOUT_BUTTON, new Object[0]), false);
            return 1;
        })).then(class_2170.method_9247((String)"confirm").executes(context -> {
            WelfareData welfareData = (WelfareData)Solstice.playerData.get(((class_2168)context.getSource()).method_44023().method_5667()).getData(WelfareData.class);
            welfareData.optedOut = true;
            Wallet wallet = Kromer.database.getWallet(((class_2168)context.getSource()).method_44023().method_5667());
            if (wallet == null) {
                return 0;
            }
            ((CompletableFuture)CompletableFuture.supplyAsync(() -> GetAddress.execute((String)wallet.address), Kromer.NETWORK_EXECUTOR).thenCompose(f -> f)).whenComplete((b, ex) -> {
                if (ex != null) {
                    ((class_2168)context.getSource()).method_9211().execute(() -> ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.ERROR, ex.getMessage()), false));
                    return;
                }
                if (b instanceof Result.Ok) {
                    Result.Ok ok = (Result.Ok)b;
                    ((CompletableFuture)CompletableFuture.supplyAsync(() -> MakeTransaction.execute((String)wallet.privatekey, (String)"serverwelf", (float)((GetAddress.GetAddressBody)ok.value()).address.balance, (String)"[rcc-kromer] relinquishing all kromer"), Kromer.NETWORK_EXECUTOR).thenCompose(f2 -> f2)).whenComplete((z, ex2) -> ((class_2168)context.getSource()).method_9211().execute(() -> ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.OPTED_OUT_WELFARE, new Object[0]), false)));
                }
            });
            return 1;
        }));
        LiteralArgumentBuilder rootCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"kromer").then((ArgumentBuilder)versionCommand)).then((ArgumentBuilder)infoCommand)).then((ArgumentBuilder)muteWelfare)).then((ArgumentBuilder)optInOfWelfare)).then((ArgumentBuilder)optOutOfWelfare)).then(giveWalletCommand.requires(scs -> scs.method_9259(4)))).then(setMoneyCommand.requires(scs -> scs.method_9259(4)))).then(executeWelfare.requires(scs -> scs.method_9259(4)));
        dispatcher.register(rootCommand);
    }
}

