/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.kromer.commands;

import cc.reconnected.kromer.Kromer;
import cc.reconnected.kromer.Locale;
import cc.reconnected.kromer.arguments.AddressArgumentType;
import cc.reconnected.kromer.arguments.KromerArgumentType;
import cc.reconnected.kromer.database.Wallet;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import ovh.sad.jkromer.http.Result;
import ovh.sad.jkromer.http.transactions.MakeTransaction;

public class PayCommand {
    private static final Map<UUID, PendingPayment> pendingPayments = new HashMap<UUID, PendingPayment>();

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"confirm_pay").executes(PayCommand::confirmPay));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"pay").then(class_2170.method_9244((String)"recipient", (ArgumentType)AddressArgumentType.address()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"amount", (ArgumentType)KromerArgumentType.kromerArg()).executes(PayCommand::executePay)).then(class_2170.method_9244((String)"metadata", (ArgumentType)StringArgumentType.greedyString()).executes(PayCommand::executePay)))));
    }

    public static String toSemicolonString(Map<String, Object> data) {
        return data.entrySet().stream().map(e -> (String)e.getKey() + "=" + String.valueOf(e.getValue())).collect(Collectors.joining(";"));
    }

    private static int executePay(CommandContext<class_2168> context) {
        pendingPayments.remove(((class_2168)context.getSource()).method_44023().method_5667());
        String recipientInput = AddressArgumentType.getAddress(context, "recipient");
        String kristAddress = null;
        String recipientName = null;
        if (!Kromer.kromerStatus.booleanValue()) {
            ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.KROMER_UNAVAILABLE, new Object[0]), false);
            return 0;
        }
        if (recipientInput.matches("^k[a-z0-9]{9}$") || recipientInput.matches("^(?:([a-z0-9-_]{1,32})@)?([a-z0-9]{1,64})\\.kro$")) {
            kristAddress = recipientInput;
            recipientName = recipientInput;
        } else {
            GameProfile otherProfile;
            try {
                otherProfile = ((class_2168)context.getSource()).method_9211().method_3793().method_14515(recipientInput).orElse(null);
            }
            catch (Exception e) {
                otherProfile = null;
            }
            if (otherProfile == null) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"User not found and not a valid address.").method_27692(class_124.field_1061), false);
                return 0;
            }
            Wallet otherWallet = Kromer.database.getWallet(otherProfile.getId());
            if (otherWallet == null) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Other user does not have a wallet. They haven't joined recently.").method_27692(class_124.field_1061), false);
                return 0;
            }
            kristAddress = otherWallet.address;
            recipientName = otherProfile.getName();
        }
        BigDecimal amount = KromerArgumentType.getBigDecimal(context, "amount");
        class_3222 thisPlayer = ((class_2168)context.getSource()).method_44023();
        Wallet wallet = Kromer.database.getWallet(thisPlayer.method_5667());
        if (wallet == null) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"You do not have a wallet. This should be impossible. Rejoin/contact a staff member.").method_27692(class_124.field_1061), false);
            return 0;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("return", wallet.address);
        data.put("username", thisPlayer.method_5820());
        data.put("useruuid", thisPlayer.method_5667());
        Object metadata = PayCommand.toSemicolonString(data);
        if (context.getNodes().size() > 3) {
            metadata = (String)metadata + ";" + StringArgumentType.getString(context, (String)"metadata");
        }
        PendingPayment payment = new PendingPayment();
        payment.to = kristAddress;
        payment.amount = amount;
        payment.metadata = metadata;
        payment.createdAt = System.currentTimeMillis();
        pendingPayments.put(thisPlayer.method_5667(), payment);
        String finalRecipientName = recipientName;
        class_5250 confirmButton = class_2561.method_43470((String)"[Confirm]").method_27694(style -> style.method_10977(class_124.field_1060).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, "/confirm_pay")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("Click to confirm payment of " + String.valueOf(amount) + "KRO to " + finalRecipientName)))));
        ((class_2168)context.getSource()).method_9226(() -> PayCommand.lambda$executePay$6(amount, finalRecipientName, (class_2561)confirmButton), false);
        return 1;
    }

    private static int confirmPay(CommandContext<class_2168> context) {
        PendingPayment payment;
        class_3222 player;
        try {
            player = Objects.requireNonNull(((class_2168)context.getSource()).method_44023());
            payment = pendingPayments.remove(player.method_5667());
        }
        catch (NullPointerException e) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"You must be online to use this command.").method_27692(class_124.field_1061), false);
            return 0;
        }
        if (payment == null) {
            ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.NO_PENDING, new Object[0]), false);
            return 0;
        }
        Wallet wallet = Kromer.database.getWallet(player.method_5667());
        if (wallet == null) {
            ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.NO_WALLET, new Object[0]), false);
            return 0;
        }
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> MakeTransaction.execute((String)wallet.privatekey, (String)payment.to, (float)payment.amount.floatValue(), (String)payment.metadata), Kromer.NETWORK_EXECUTOR).thenCompose(future -> future)).whenComplete((result, ex) -> ((class_2168)context.getSource()).method_9211().execute(() -> {
            if (ex != null) {
                ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.ERROR, ex.getMessage()), false);
                return;
            }
            if (result instanceof Result.Ok) {
                Result.Ok ok = (Result.Ok)result;
                ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.PAYMENT_CONFIRMED, payment.amount, payment.to), false);
            } else if (result instanceof Result.Err) {
                Result.Err err = (Result.Err)result;
                ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.ERROR, err.error()), false);
            }
        }));
        return 1;
    }

    private static /* synthetic */ class_2561 lambda$executePay$6(BigDecimal amount, String finalRecipientName, class_2561 confirmButton) {
        return class_2561.method_43470((String)"Are you sure you want to send ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(amount) + "KRO ")).method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"to ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)finalRecipientName).method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"? ").method_27692(class_124.field_1060)).method_10852(confirmButton);
    }

    private static class PendingPayment {
        String to;
        BigDecimal amount;
        String metadata;
        long createdAt;

        private PendingPayment() {
        }
    }
}

