/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.kromer.commands;

import cc.reconnected.kromer.Kromer;
import cc.reconnected.kromer.Locale;
import cc.reconnected.kromer.database.Wallet;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.placeholders.api.TextParserUtils;
import java.text.SimpleDateFormat;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import ovh.sad.jkromer.http.Result;
import ovh.sad.jkromer.http.addresses.GetAddressTransactions;
import ovh.sad.jkromer.models.Transaction;

public class TransactionsCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"transactions").executes(TransactionsCommand::checkTransactions)).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(TransactionsCommand::checkTransactions)));
    }

    public static int checkTransactions(CommandContext<class_2168> context) throws CommandSyntaxException {
        Wallet wallet = Kromer.database.getWallet(((class_2168)context.getSource()).method_44023().method_5667());
        if (!Kromer.kromerStatus.booleanValue()) {
            ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.KROMER_UNAVAILABLE, new Object[0]), false);
            return 0;
        }
        if (wallet == null) {
            ((class_2168)context.getSource()).method_9226(() -> Locale.use(Locale.Messages.NO_WALLET, new Object[0]), false);
            return 0;
        }
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        assert (player != null);
        int page = 1;
        try {
            page = IntegerArgumentType.getInteger(context, (String)"page");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        int offset = (page - 1) * 10;
        int finalPage = page;
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> GetAddressTransactions.execute((String)wallet.address, (Boolean)false, (Integer)10, (Integer)offset), Kromer.NETWORK_EXECUTOR).thenCompose(future -> future)).whenComplete((result, throwable) -> source.method_9211().execute(() -> {
            if (throwable != null) {
                source.method_9226(() -> Locale.use(Locale.Messages.ERROR, throwable), false);
                return;
            }
            if (result instanceof Result.Ok) {
                Result.Ok ok = (Result.Ok)result;
                GetAddressTransactions.GetAddressTransactionsBody responseObj = (GetAddressTransactions.GetAddressTransactionsBody)ok.value();
                source.method_9226(() -> Locale.use(Locale.Messages.TRANSACTIONS_INFO, player.method_5820(), finalPage), false);
                if (responseObj.transactions == null || responseObj.transactions.isEmpty()) {
                    source.method_9226(() -> Locale.use(Locale.Messages.TRANSACTIONS_EMPTY, new Object[0]), false);
                    return;
                }
                SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                f.setTimeZone(TimeZone.getTimeZone("UTC"));
                for (Transaction transaction : responseObj.transactions) {
                    source.method_9226(() -> Locale.useSafe(Locale.Messages.TRANSACTION, Objects.equals(transaction.type, "transfer") ? "<aqua>" : "<gold>", f.format(transaction.time), transaction.id, transaction.from, transaction.to, Float.valueOf(transaction.value), transaction.metadata), false);
                }
                boolean hasNextPage = responseObj.transactions.size() >= 10;
                boolean hasPreviousPage = finalPage > 1;
                StringBuilder nav = new StringBuilder("<green>Navigation: ");
                if (hasPreviousPage) {
                    nav.append("<run_cmd:'/transactions ").append(finalPage - 1).append("'><aqua>[Prev. Page]</aqua></run_cmd> ");
                }
                if (hasNextPage) {
                    nav.append("<run_cmd:'/transactions ").append(finalPage + 1).append("'><aqua>[Next Page]</aqua></run_cmd>");
                }
                source.method_9226(() -> TextParserUtils.formatText((String)nav.toString()), false);
            } else if (result instanceof Result.Err) {
                Result.Err err = (Result.Err)result;
                source.method_9226(() -> Locale.use(Locale.Messages.ERROR, err.error()), false);
            }
        }));
        return 1;
    }
}

