/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.kromer.common;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;

public class CommonMetaParser {
    private static ParseResult parseInternal(String input) {
        ParseResult result = new ParseResult();
        if (input == null || input.isEmpty()) {
            return result;
        }
        int len = input.length();
        int[] iArr = new int[]{0};
        int iterations = 0;
        int maxIterations = len * 10;
        Runnable skipWS = () -> {
            while (iArr[0] < len && (input.charAt(iArr[0]) == ' ' || input.charAt(iArr[0]) == '\t' || input.charAt(iArr[0]) == '\n' || input.charAt(iArr[0]) == '\r')) {
                iArr[0] = iArr[0] + 1;
            }
        };
        skipWS.run();
        try {
            while (iArr[0] < len) {
                if (++iterations > maxIterations) {
                    result.success = false;
                    result.error = "Maximum iterations exceeded (possible infinite loop)";
                } else {
                    char c;
                    while (iArr[0] < len && ((c = input.charAt(iArr[0])) == ' ' || c == '\t' || c == '\n' || c == '\r' || c == ';')) {
                        iArr[0] = iArr[0] + 1;
                    }
                    if (iArr[0] < len) {
                        char c2;
                        int startKey = iArr[0];
                        while (iArr[0] < len && (c2 = input.charAt(iArr[0])) != '=' && c2 != ';' && c2 != '\n' && c2 != '\r') {
                            iArr[0] = iArr[0] + 1;
                        }
                        String key = input.substring(startKey, iArr[0]).trim();
                        if (key.isEmpty()) {
                            iArr[0] = iArr[0] + 1;
                            continue;
                        }
                        String value = "";
                        if (iArr[0] < len && input.charAt(iArr[0]) == '=') {
                            iArr[0] = iArr[0] + 1;
                            int startValue = iArr[0];
                            while (iArr[0] < len && input.charAt(iArr[0]) != ';' && input.charAt(iArr[0]) != '\n' && input.charAt(iArr[0]) != '\r') {
                                iArr[0] = iArr[0] + 1;
                            }
                            value = input.substring(startValue, iArr[0]).trim();
                        }
                        result.pairs.put(key, value);
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            result.success = false;
            result.error = e.getMessage();
        }
        return result;
    }

    public static ParseResult parseWithResult(String input) {
        return CommonMetaParser.parseInternal(input);
    }

    public static Map<String, String> parsePairs(String input) {
        ParseResult r = CommonMetaParser.parseInternal(input);
        return r.success ? r.pairs : new HashMap<String, String>();
    }

    public static boolean isValid(String input) {
        return CommonMetaParser.parseInternal((String)input).success;
    }

    public static String getErrorMessage(String input) {
        return CommonMetaParser.parseInternal((String)input).error;
    }

    public static String toJson(String input) {
        return new Gson().toJson((Object)CommonMetaParser.parseInternal(input));
    }

    public static void main(String[] args) {
        String test = ";;name=John; email=john@example.com;;flag;;=bad;\ud83d\ude00=fun;";
        System.out.println(CommonMetaParser.toJson(test));
    }

    public static class ParseResult {
        public Map<String, String> pairs;
        public boolean success;
        public String error;

        public ParseResult() {
            this.pairs = new HashMap<String, String>();
            this.success = true;
        }

        public ParseResult(Map<String, String> pairs, boolean success, String error) {
            this.pairs = pairs;
            this.success = success;
            this.error = error;
        }
    }
}

