/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.kromer.database;

import cc.reconnected.kromer.database.Wallet;
import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import net.minecraft.class_3545;
import ovh.sad.jkromer.models.Transaction;

public class Database {
    private Connection connection;
    public Gson gson = new Gson();

    public Database() {
        try {
            this.connection = DriverManager.getConnection("jdbc:sqlite:rcc-kromer.sqlite");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void setWallet(UUID playerUuid, Wallet wallet) {
        try {
            if (this.getWallet(playerUuid) == null) {
                PreparedStatement stmt = this.connection.prepareStatement("    INSERT OR REPLACE INTO wallets (address, uuid, privatekey, incomingNotSeen, outgoingNotSeen)\n    VALUES (?, ?, ?, ?, ?)\n");
                stmt.setString(1, wallet.address);
                stmt.setString(2, playerUuid.toString());
                stmt.setString(3, wallet.privatekey);
                stmt.setString(4, this.gson.toJson((Object)wallet.incomingNotSeen, Transaction[].class));
                stmt.setString(5, this.gson.toJson((Object)wallet.outgoingNotSeen, Transaction[].class));
                stmt.executeUpdate();
                stmt.close();
            } else {
                PreparedStatement stmt = this.connection.prepareStatement("    UPDATE wallets\n    SET address = ?, privatekey = ?, incomingNotSeen = ?, outgoingNotSeen = ?\n    WHERE uuid = ?\n");
                stmt.setString(1, wallet.address);
                stmt.setString(2, wallet.privatekey);
                stmt.setString(3, this.gson.toJson((Object)wallet.incomingNotSeen, Transaction[].class));
                stmt.setString(4, this.gson.toJson((Object)wallet.outgoingNotSeen, Transaction[].class));
                stmt.setString(5, playerUuid.toString());
                stmt.executeUpdate();
                stmt.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Wallet getWallet(UUID playerUuid) {
        try {
            PreparedStatement stmt = this.connection.prepareStatement("    SELECT address, privatekey, incomingNotSeen, outgoingNotSeen FROM wallets WHERE uuid = ?\n");
            stmt.setString(1, playerUuid.toString());
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                return new Wallet(rs.getString("address"), rs.getString("privatekey"), (Transaction[])this.gson.fromJson(rs.getString("incomingNotSeen"), Transaction[].class), (Transaction[])this.gson.fromJson(rs.getString("outgoingNotSeen"), Transaction[].class));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public class_3545<UUID, Wallet> getWallet(String address) {
        try {
            PreparedStatement stmt = this.connection.prepareStatement("    SELECT uuid, privatekey, incomingNotSeen, outgoingNotSeen FROM wallets WHERE address = ?\n");
            stmt.setString(1, address);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                UUID uuid = UUID.fromString(rs.getString("uuid"));
                Wallet wallet = new Wallet(address, rs.getString("privatekey"), (Transaction[])this.gson.fromJson(rs.getString("incomingNotSeen"), Transaction[].class), (Transaction[])this.gson.fromJson(rs.getString("outgoingNotSeen"), Transaction[].class));
                return new class_3545((Object)uuid, (Object)wallet);
            }
        }
        catch (IllegalArgumentException | SQLException e) {
            e.printStackTrace();
        }
        return null;
    }
}

