/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.peripherals.posters;

import com.mojang.blaze3d.systems.RenderSystem;
import io.sc3.peripherals.Registration;
import io.sc3.peripherals.client.item.PosterRenderer;
import io.sc3.peripherals.posters.PosterPrintData;
import io.sc3.peripherals.posters.PosterState;
import io.sc3.peripherals.posters.PosterWorldKt;
import io.sc3.peripherals.util.BaseItem;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00182\u00020\u0001:\u0003\u0019\u001a\u0018B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ7\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lio/sc3/peripherals/posters/PosterItem;", "Lio/sc3/peripherals/util/BaseItem;", "Lnet/minecraft/class_1792$class_1793;", "settings", "<init>", "(Lnet/minecraft/class_1792$class_1793;)V", "Lnet/minecraft/class_1799;", "stack", "Ljava/util/Optional;", "Lnet/minecraft/class_5632;", "getTooltipData", "(Lnet/minecraft/class_1799;)Ljava/util/Optional;", "Lnet/minecraft/class_2561;", "getName", "(Lnet/minecraft/class_1799;)Lnet/minecraft/class_2561;", "Lnet/minecraft/class_1937;", "world", "", "tooltip", "Lnet/minecraft/class_1836;", "context", "", "appendTooltip", "(Lnet/minecraft/class_1799;Lnet/minecraft/class_1937;Ljava/util/List;Lnet/minecraft/class_1836;)V", "Companion", "PosterTooltipData", "PosterTooltipComponent", "sc-peripherals"})
@SourceDebugExtension(value={"SMAP\nPosterItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PosterItem.kt\nio/sc3/peripherals/posters/PosterItem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n1#2:196\n*E\n"})
public final class PosterItem
extends BaseItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String POSTER_KEY = "poster";

    public PosterItem(@NotNull class_1792.class_1793 settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(POSTER_KEY, settings);
    }

    @NotNull
    public Optional<class_5632> method_32346(@NotNull class_1799 stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Optional<class_5632> optional = Optional.of(new PosterTooltipData(stack));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        return optional;
    }

    @NotNull
    public class_2561 method_7864(@NotNull class_1799 stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        PosterPrintData posterPrintData = Companion.printData(stack);
        if (posterPrintData == null || (posterPrintData = posterPrintData.getLabelText()) == null) {
            class_2561 class_25612 = super.method_7864(stack);
            posterPrintData = class_25612;
            Intrinsics.checkNotNullExpressionValue((Object)class_25612, (String)"getName(...)");
        }
        return posterPrintData;
    }

    @Override
    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 world, @NotNull List<class_2561> tooltip, @NotNull class_1836 context) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String id = Companion.getPosterId(stack);
        PosterPrintData posterPrintData = Companion.printData(stack);
        if (posterPrintData == null) {
            return;
        }
        PosterPrintData data = posterPrintData;
        String string = data.getTooltip();
        if (string != null) {
            String it = string;
            boolean bl = false;
            class_5250 class_52502 = class_2561.method_43470((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
            tooltip.add((class_2561)class_52502);
        }
        if (context.method_8035()) {
            if (id != null) {
                Object[] objectArray = new Object[]{StringsKt.take((String)id, (int)8)};
                class_5250 class_52503 = class_2561.method_43469((String)(this.method_7876() + ".id"), (Object[])objectArray).method_27692(class_124.field_1080);
                Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"formatted(...)");
                v4 = tooltip.add((class_2561)class_52503);
            } else {
                class_5250 class_52504 = class_2561.method_43471((String)(this.method_7876() + ".unknown")).method_27692(class_124.field_1080);
                Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"formatted(...)");
                v4 = tooltip.add((class_2561)class_52504);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\u0007J\u000f\u0010\f\u001a\u00020\nH\u0000\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u001d\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ+\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00180\u001b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0019\u0010 \u001a\u0004\u0018\u00010\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b \u0010!J#\u0010\"\u001a\u0004\u0018\u00010\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010$\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lio/sc3/peripherals/posters/PosterItem$Companion;", "", "<init>", "()V", "", "posterId", "getPosterName", "(Ljava/lang/String;)Ljava/lang/String;", "posterName", "getIdFromName", "", "clientInit$sc_peripherals", "clientInit", "Lnet/minecraft/class_1937;", "world", "Lio/sc3/peripherals/posters/PosterPrintData;", "data", "Lnet/minecraft/class_1799;", "create", "(Lnet/minecraft/class_1937;Lio/sc3/peripherals/posters/PosterPrintData;)Lnet/minecraft/class_1799;", "stack", "id", "setPosterId", "(Lnet/minecraft/class_1799;Ljava/lang/String;Lio/sc3/peripherals/posters/PosterPrintData;)V", "Lio/sc3/peripherals/posters/PosterState;", "createPosterState", "(Lnet/minecraft/class_1799;Lnet/minecraft/class_1937;Lio/sc3/peripherals/posters/PosterPrintData;)Lio/sc3/peripherals/posters/PosterState;", "Lkotlin/Pair;", "allocatePosterId", "(Lnet/minecraft/class_1937;Lio/sc3/peripherals/posters/PosterPrintData;)Lkotlin/Pair;", "allocateHash", "(Lnet/minecraft/class_1937;Lio/sc3/peripherals/posters/PosterState;)Ljava/lang/String;", "getPosterId", "(Lnet/minecraft/class_1799;)Ljava/lang/String;", "getPosterState", "(Ljava/lang/String;Lnet/minecraft/class_1937;)Lio/sc3/peripherals/posters/PosterState;", "printData", "(Lnet/minecraft/class_1799;)Lio/sc3/peripherals/posters/PosterPrintData;", "POSTER_KEY", "Ljava/lang/String;", "sc-peripherals"})
    @SourceDebugExtension(value={"SMAP\nPosterItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PosterItem.kt\nio/sc3/peripherals/posters/PosterItem$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n1#2:196\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getPosterName(@NotNull String posterId) {
            Intrinsics.checkNotNullParameter((Object)posterId, (String)"posterId");
            return "posters/" + StringsKt.take((String)posterId, (int)2) + "/" + posterId;
        }

        @NotNull
        public final String getIdFromName(@NotNull String posterName) {
            Intrinsics.checkNotNullParameter((Object)posterName, (String)"posterName");
            return StringsKt.substringAfterLast$default((String)posterName, (char)'/', null, (int)2, null);
        }

        public final void clientInit$sc_peripherals() {
            TooltipComponentCallback.EVENT.register(Companion::clientInit$lambda$0);
        }

        @NotNull
        public final class_1799 create(@NotNull class_1937 world, @NotNull PosterPrintData data) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            class_1799 itemStack = new class_1799((class_1935)Registration.ModItems.INSTANCE.getPoster());
            String id = data.getPosterId();
            boolean bl = false;
            if (id != null) {
                Companion.setPosterId(itemStack, id, data);
            } else {
                Companion.createPosterState(itemStack, world, data);
            }
            return itemStack;
        }

        private final void setPosterId(class_1799 stack, String id, PosterPrintData data) {
            class_2487 $this$setPosterId_u24lambda_u242 = stack.method_7948();
            boolean bl = false;
            $this$setPosterId_u24lambda_u242.method_10582(PosterItem.POSTER_KEY, id);
            $this$setPosterId_u24lambda_u242.method_10543(data.toItemNbt());
        }

        private final PosterState createPosterState(class_1799 stack, class_1937 world, PosterPrintData data) {
            Pair<String, PosterState> pair = this.allocatePosterId(world, data);
            String i2 = (String)pair.component1();
            PosterState state = (PosterState)((Object)pair.component2());
            this.setPosterId(stack, i2, data);
            return state;
        }

        private final Pair<String, PosterState> allocatePosterId(class_1937 world, PosterPrintData data) {
            PosterState posterState;
            PosterState it = posterState = new PosterState();
            boolean bl = false;
            for (int x = 0; x < 128; ++x) {
                for (int y = 0; y < 128; ++y) {
                    it.setColor(x, y, data.getColors()[x + y * 128]);
                }
            }
            int n = data.getPalette().length;
            for (int i2 = 0; i2 < n; ++i2) {
                it.getPalette()[i2] = data.getPalette()[i2];
            }
            PosterState posterState2 = posterState;
            String i3 = this.allocateHash(world, posterState2);
            PosterWorldKt.putPosterState(world, this.getPosterName(i3), posterState2);
            return TuplesKt.to((Object)i3, (Object)((Object)posterState2));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String allocateHash(class_1937 world, PosterState data) {
            Object baos;
            Closeable closeable = new ByteArrayOutputStream();
            Throwable throwable = null;
            try {
                byte[] byArray;
                baos = (ByteArrayOutputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new DataOutputStream((OutputStream)baos);
                Throwable throwable2 = null;
                try {
                    DataOutputStream dos = (DataOutputStream)closeable2;
                    boolean bl2 = false;
                    class_2507.method_10628((class_2487)data.method_75(new class_2487()), (DataOutput)dos);
                    byArray = ((ByteArrayOutputStream)baos).toByteArray();
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                baos = byArray;
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object contents = baos;
            int disambiguation = 0;
            do {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                Intrinsics.checkNotNull((Object)contents);
                String bl = String.valueOf(disambiguation);
                byte[] byArray = bl.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                byte[] hash = digest.digest(ArraysKt.plus((byte[])contents, (byte[])byArray));
                Intrinsics.checkNotNull((Object)hash);
                String hex = ArraysKt.joinToString$default((byte[])hash, (CharSequence)"", null, null, (int)0, null, Companion::allocateHash$lambda$6, (int)30, null);
                PosterState existingData = PosterWorldKt.getPosterState(world, this.getPosterName(hex));
                if (existingData != null && !Intrinsics.areEqual((Object)((Object)existingData), (Object)((Object)data))) continue;
                return hex;
            } while (++disambiguation <= 128);
            throw new IllegalStateException("Likely infinite loop allocating poster ID, this should never happen!");
        }

        @Nullable
        public final String getPosterId(@Nullable class_1799 stack) {
            String string;
            class_1799 class_17992 = stack;
            if (class_17992 != null && (class_17992 = class_17992.method_7969()) != null) {
                class_1799 it = class_17992;
                boolean bl = false;
                string = it.method_10573(PosterItem.POSTER_KEY, 8) ? it.method_10558(PosterItem.POSTER_KEY) : null;
            } else {
                string = null;
            }
            return string;
        }

        @Nullable
        public final PosterState getPosterState(@Nullable String id, @Nullable class_1937 world) {
            PosterState posterState;
            if (id == null) {
                posterState = null;
            } else {
                class_1937 class_19372 = world;
                posterState = class_19372 != null ? PosterWorldKt.getPosterState(class_19372, this.getPosterName(id)) : null;
            }
            return posterState;
        }

        @Nullable
        public final PosterPrintData printData(@NotNull class_1799 stack) {
            PosterPrintData posterPrintData;
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            class_2487 class_24872 = stack.method_7969();
            if (class_24872 != null) {
                class_2487 it = class_24872;
                boolean bl = false;
                posterPrintData = PosterPrintData.Companion.fromNbt(it);
            } else {
                posterPrintData = null;
            }
            return posterPrintData;
        }

        private static final class_5684 clientInit$lambda$0(class_5632 it) {
            return it instanceof PosterTooltipData ? (class_5684)new PosterTooltipComponent(((PosterTooltipData)it).getStack(), (class_1937)class_310.method_1551().field_1687) : null;
        }

        private static final CharSequence allocateHash$lambda$6(byte it) {
            String string = "%02x";
            Object[] objectArray = new Object[]{it};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J/\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J&\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001a\u0010\u001f\u001a\u00020\u001e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003\u00a2\u0006\u0004\b\u001f\u0010 J\u0010\u0010!\u001a\u00020\nH\u00d6\u0001\u00a2\u0006\u0004\b!\u0010\u0013J\u0010\u0010#\u001a\u00020\"H\u00d6\u0001\u00a2\u0006\u0004\b#\u0010$R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010%\u001a\u0004\b&\u0010\u0017R\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010'\u001a\u0004\b(\u0010\u0019\u00a8\u0006)"}, d2={"Lio/sc3/peripherals/posters/PosterItem$PosterTooltipComponent;", "Lnet/minecraft/class_5684;", "Lnet/minecraft/class_1799;", "stack", "Lnet/minecraft/class_1937;", "world", "<init>", "(Lnet/minecraft/class_1799;Lnet/minecraft/class_1937;)V", "Lnet/minecraft/class_327;", "textRenderer", "", "tooltipX", "tooltipY", "Lnet/minecraft/class_332;", "ctx", "", "drawItems", "(Lnet/minecraft/class_327;IILnet/minecraft/class_332;)V", "getHeight", "()I", "getWidth", "(Lnet/minecraft/class_327;)I", "component1", "()Lnet/minecraft/class_1799;", "component2", "()Lnet/minecraft/class_1937;", "copy", "(Lnet/minecraft/class_1799;Lnet/minecraft/class_1937;)Lio/sc3/peripherals/posters/PosterItem$PosterTooltipComponent;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_1799;", "getStack", "Lnet/minecraft/class_1937;", "getWorld", "sc-peripherals"})
    public static final class PosterTooltipComponent
    implements class_5684 {
        @NotNull
        private final class_1799 stack;
        @Nullable
        private final class_1937 world;

        public PosterTooltipComponent(@NotNull class_1799 stack, @Nullable class_1937 world) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            this.stack = stack;
            this.world = world;
        }

        @NotNull
        public final class_1799 getStack() {
            return this.stack;
        }

        @Nullable
        public final class_1937 getWorld() {
            return this.world;
        }

        public void method_32666(@NotNull class_327 textRenderer, int tooltipX, int tooltipY, @NotNull class_332 ctx) {
            Intrinsics.checkNotNullParameter((Object)textRenderer, (String)"textRenderer");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            String string = Companion.getPosterId(this.stack);
            if (string == null) {
                return;
            }
            String posterId = string;
            PosterState posterState = Companion.getPosterState(posterId, this.world);
            if (posterState == null) {
                return;
            }
            PosterState posterState2 = posterState;
            class_4587 matrices = ctx.method_51448();
            int pad = 7;
            int size = 135 + pad;
            float scale = 0.5f;
            matrices.method_22903();
            matrices.method_22904((double)tooltipX + 3.0, (double)tooltipY + 3.0, 500.0);
            matrices.method_22905(scale, scale, 1.0f);
            RenderSystem.enableBlend();
            ctx.method_25291(PosterRenderer.INSTANCE.getPOSTER_BACKGROUND_RES(), -pad, -pad, -1, 0.0f, 0.0f, size, size, size, size);
            class_287 class_2872 = class_289.method_1348().method_1349();
            Intrinsics.checkNotNullExpressionValue((Object)class_2872, (String)"getBuffer(...)");
            class_287 buffer = class_2872;
            class_4597.class_4598 immediateBuffer = class_4597.method_22991((class_287)buffer);
            Intrinsics.checkNotNull((Object)matrices);
            Intrinsics.checkNotNull((Object)immediateBuffer);
            PosterRenderer.draw$default(PosterRenderer.INSTANCE, matrices, (class_4597)immediateBuffer, posterId, posterState2, 0xF000F0, false, 32, null);
            immediateBuffer.method_22993();
            matrices.method_22909();
        }

        public int method_32661() {
            String posterId = Companion.getPosterId(this.stack);
            PosterState posterState = Companion.getPosterState(posterId, this.world);
            return posterState != null ? 75 : 0;
        }

        public int method_32664(@NotNull class_327 textRenderer) {
            Intrinsics.checkNotNullParameter((Object)textRenderer, (String)"textRenderer");
            return 72;
        }

        @NotNull
        public final class_1799 component1() {
            return this.stack;
        }

        @Nullable
        public final class_1937 component2() {
            return this.world;
        }

        @NotNull
        public final PosterTooltipComponent copy(@NotNull class_1799 stack, @Nullable class_1937 world) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return new PosterTooltipComponent(stack, world);
        }

        public static /* synthetic */ PosterTooltipComponent copy$default(PosterTooltipComponent posterTooltipComponent, class_1799 class_17992, class_1937 class_19372, int n, Object object) {
            if ((n & 1) != 0) {
                class_17992 = posterTooltipComponent.stack;
            }
            if ((n & 2) != 0) {
                class_19372 = posterTooltipComponent.world;
            }
            return posterTooltipComponent.copy(class_17992, class_19372);
        }

        @NotNull
        public String toString() {
            return "PosterTooltipComponent(stack=" + this.stack + ", world=" + this.world + ")";
        }

        public int hashCode() {
            int result = this.stack.hashCode();
            result = result * 31 + (this.world == null ? 0 : this.world.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PosterTooltipComponent)) {
                return false;
            }
            PosterTooltipComponent posterTooltipComponent = (PosterTooltipComponent)other;
            if (!Intrinsics.areEqual((Object)this.stack, (Object)posterTooltipComponent.stack)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.world, (Object)posterTooltipComponent.world);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lio/sc3/peripherals/posters/PosterItem$PosterTooltipData;", "Lnet/minecraft/class_5632;", "Lnet/minecraft/class_1799;", "stack", "<init>", "(Lnet/minecraft/class_1799;)V", "component1", "()Lnet/minecraft/class_1799;", "copy", "(Lnet/minecraft/class_1799;)Lio/sc3/peripherals/posters/PosterItem$PosterTooltipData;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_1799;", "getStack", "sc-peripherals"})
    public static final class PosterTooltipData
    implements class_5632 {
        @NotNull
        private final class_1799 stack;

        public PosterTooltipData(@NotNull class_1799 stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            this.stack = stack;
        }

        @NotNull
        public final class_1799 getStack() {
            return this.stack;
        }

        @NotNull
        public final class_1799 component1() {
            return this.stack;
        }

        @NotNull
        public final PosterTooltipData copy(@NotNull class_1799 stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return new PosterTooltipData(stack);
        }

        public static /* synthetic */ PosterTooltipData copy$default(PosterTooltipData posterTooltipData, class_1799 class_17992, int n, Object object) {
            if ((n & 1) != 0) {
                class_17992 = posterTooltipData.stack;
            }
            return posterTooltipData.copy(class_17992);
        }

        @NotNull
        public String toString() {
            return "PosterTooltipData(stack=" + this.stack + ")";
        }

        public int hashCode() {
            return this.stack.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PosterTooltipData)) {
                return false;
            }
            PosterTooltipData posterTooltipData = (PosterTooltipData)other;
            return Intrinsics.areEqual((Object)this.stack, (Object)posterTooltipData.stack);
        }
    }
}

