/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.peripherals.posters;

import io.prometheus.client.Counter;
import io.sc3.library.networking.ScLibraryPacket;
import io.sc3.peripherals.ScPeripherals;
import io.sc3.peripherals.ScPeripheralsPrometheus;
import io.sc3.peripherals.posters.PosterItem;
import io.sc3.peripherals.posters.PosterState;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ/\u0010\u0014\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J \u0010\u0018\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001a\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010 \u001a\u00020\u001fH\u00d6\u0001\u00a2\u0006\u0004\b \u0010!J\u0010\u0010\"\u001a\u00020\u0003H\u00d6\u0001\u00a2\u0006\u0004\b\"\u0010#R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010$\u001a\u0004\b%\u0010\u0017R\u001a\u0010+\u001a\u00020&8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*\u00a8\u0006-"}, d2={"Lio/sc3/peripherals/posters/PosterRequestC2SPacket;", "Lio/sc3/library/networking/ScLibraryPacket;", "", "", "posterIds", "<init>", "(Ljava/util/List;)V", "Lnet/minecraft/class_2540;", "buf", "", "toBytes", "(Lnet/minecraft/class_2540;)V", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/class_3222;", "player", "Lnet/minecraft/class_3244;", "handler", "Lnet/fabricmc/fabric/api/networking/v1/PacketSender;", "responseSender", "onServerReceive", "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_3222;Lnet/minecraft/class_3244;Lnet/fabricmc/fabric/api/networking/v1/PacketSender;)V", "component1", "()Ljava/util/List;", "copy", "(Ljava/util/List;)Lio/sc3/peripherals/posters/PosterRequestC2SPacket;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Ljava/util/List;", "getPosterIds", "Lnet/minecraft/class_2960;", "id$1", "Lnet/minecraft/class_2960;", "getId", "()Lnet/minecraft/class_2960;", "id", "Companion", "sc-peripherals"})
public final class PosterRequestC2SPacket
extends ScLibraryPacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> posterIds;
    @NotNull
    private final class_2960 id$1;
    @NotNull
    private static final class_2960 id = ScPeripherals.INSTANCE.ModId$sc_peripherals("poster_request");
    private static final Counter requestCounter = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("sc_peripherals_posters_requested")).help("Number of posters requested by clients")).register(ScPeripheralsPrometheus.INSTANCE.getRegistry$sc_peripherals());
    private static final Counter responseCounter = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("sc_peripherals_posters_sent")).help("Number of posters sent by the server")).register(ScPeripheralsPrometheus.INSTANCE.getRegistry$sc_peripherals());

    public PosterRequestC2SPacket(@NotNull List<String> posterIds) {
        Intrinsics.checkNotNullParameter(posterIds, (String)"posterIds");
        this.posterIds = posterIds;
        this.id$1 = id;
    }

    @NotNull
    public final List<String> getPosterIds() {
        return this.posterIds;
    }

    @NotNull
    public class_2960 getId() {
        return this.id$1;
    }

    public void toBytes(@NotNull class_2540 buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        class_2540 $this$toBytes_u24lambda_u241 = buf;
        boolean bl = false;
        $this$toBytes_u24lambda_u241.method_34062((Collection)this.posterIds, PosterRequestC2SPacket::toBytes$lambda$1$lambda$0);
    }

    public void onServerReceive(@NotNull MinecraftServer server, @NotNull class_3222 player, @NotNull class_3244 handler, @NotNull PacketSender responseSender) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)responseSender, (String)"responseSender");
        server.method_20493(() -> PosterRequestC2SPacket.onServerReceive$lambda$3(this, server, responseSender));
    }

    @NotNull
    public final List<String> component1() {
        return this.posterIds;
    }

    @NotNull
    public final PosterRequestC2SPacket copy(@NotNull List<String> posterIds) {
        Intrinsics.checkNotNullParameter(posterIds, (String)"posterIds");
        return new PosterRequestC2SPacket(posterIds);
    }

    public static /* synthetic */ PosterRequestC2SPacket copy$default(PosterRequestC2SPacket posterRequestC2SPacket, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = posterRequestC2SPacket.posterIds;
        }
        return posterRequestC2SPacket.copy(list);
    }

    @NotNull
    public String toString() {
        return "PosterRequestC2SPacket(posterIds=" + this.posterIds + ")";
    }

    public int hashCode() {
        return ((Object)this.posterIds).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PosterRequestC2SPacket)) {
            return false;
        }
        PosterRequestC2SPacket posterRequestC2SPacket = (PosterRequestC2SPacket)((Object)other);
        return Intrinsics.areEqual(this.posterIds, posterRequestC2SPacket.posterIds);
    }

    private static final void toBytes$lambda$1$lambda$0(class_2540 b, String it) {
        b.method_10814(it);
    }

    private static final void onServerReceive$lambda$3(PosterRequestC2SPacket this$0, MinecraftServer $server, PacketSender $responseSender) {
        requestCounter.inc((double)this$0.posterIds.size());
        Iterator iterator = ((Iterable)this$0.posterIds).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            PosterState state;
            int idx = n++;
            String posterId = (String)iterator.next();
            if (idx >= 50) break;
            if (PosterItem.Companion.getPosterState(posterId, (class_1937)$server.method_30002()) == null) continue;
            boolean bl = false;
            $responseSender.sendPacket(state.toPacket(posterId));
            responseCounter.inc();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001c\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lio/sc3/peripherals/posters/PosterRequestC2SPacket$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_2540;", "buf", "Lio/sc3/peripherals/posters/PosterRequestC2SPacket;", "fromBytes", "(Lnet/minecraft/class_2540;)Lio/sc3/peripherals/posters/PosterRequestC2SPacket;", "Lnet/minecraft/class_2960;", "id", "Lnet/minecraft/class_2960;", "getId", "()Lnet/minecraft/class_2960;", "Lio/prometheus/client/Counter;", "kotlin.jvm.PlatformType", "requestCounter", "Lio/prometheus/client/Counter;", "responseCounter", "sc-peripherals"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_2960 getId() {
            return id;
        }

        @NotNull
        public final PosterRequestC2SPacket fromBytes(@NotNull class_2540 buf) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            class_2540 $this$fromBytes_u24lambda_u241 = buf;
            boolean bl = false;
            List list = $this$fromBytes_u24lambda_u241.method_34066(Companion::fromBytes$lambda$1$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readList(...)");
            return new PosterRequestC2SPacket(list);
        }

        private static final String fromBytes$lambda$1$lambda$0(class_2540 it) {
            return it.method_19772();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

