/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.peripherals.posters.printer;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.sc3.peripherals.posters.PosterPrintData;
import io.sc3.peripherals.posters.printer.PosterPrinterBlockEntity;
import io.sc3.peripherals.util.InventoryPeripheral;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 F2\u00020\u0001:\u0001FB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0011\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0004\b\u000e\u0010\bJ\u001d\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0011\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0004\b\u0013\u0010\bJ\u001d\u0010\u0015\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0012J/\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0016H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ'\u0010 \u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0016H\u0007\u00a2\u0006\u0004\b \u0010!J/\u0010$\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00162\u000e\u0010#\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\"H\u0007\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010'\u001a\u00020\u000b2\u000e\u0010&\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\"H\u0007\u00a2\u0006\u0004\b'\u0010(JH\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000/\"\n\b\u0000\u0010*\u0018\u0001*\u00020)2\u000e\u0010+\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\"2\u0014\b\u0004\u0010.\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00028\u00000,H\u0082\b\u00a2\u0006\u0004\b0\u00101J\u0017\u00104\u001a\u0002032\u0006\u00102\u001a\u00020\u0016H\u0007\u00a2\u0006\u0004\b4\u00105J\u000f\u00106\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b6\u0010\rJ\u000f\u00108\u001a\u000207H\u0007\u00a2\u0006\u0004\b8\u00109J\u000f\u0010:\u001a\u000207H\u0007\u00a2\u0006\u0004\b:\u00109J\u0017\u0010=\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020;H\u0016\u00a2\u0006\u0004\b=\u0010>J\u0017\u0010?\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020;H\u0016\u00a2\u0006\u0004\b?\u0010>J\u001a\u0010B\u001a\u0002032\b\u0010A\u001a\u0004\u0018\u00010@H\u0096\u0002\u00a2\u0006\u0004\bB\u0010CR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010D\u001a\u0004\bE\u0010\n\u00a8\u0006G"}, d2={"Lio/sc3/peripherals/posters/printer/PosterPrinterPeripheral;", "Lio/sc3/peripherals/util/InventoryPeripheral;", "Lio/sc3/peripherals/posters/printer/PosterPrinterBlockEntity;", "be", "<init>", "(Lio/sc3/peripherals/posters/printer/PosterPrinterBlockEntity;)V", "", "getType", "()Ljava/lang/String;", "getTarget", "()Lio/sc3/peripherals/posters/printer/PosterPrinterBlockEntity;", "", "reset", "()V", "getLabel", "Ljava/util/Optional;", "label", "setLabel", "(Ljava/util/Optional;)V", "getTooltip", "tooltip", "setTooltip", "", "index", "red", "green", "blue", "setPaletteColor", "(IIII)V", "x", "y", "color", "setPixel", "(III)V", "", "pixelMap", "blitPixels", "(IILjava/util/Map;)V", "paletteMap", "blitPalette", "(Ljava/util/Map;)V", "", "T", "table", "Lkotlin/Function1;", "", "transform", "", "luaTableToList", "(Ljava/util/Map;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "count", "", "commit", "(I)Z", "stop", "Ldan200/computercraft/api/lua/MethodResult;", "status", "()Ldan200/computercraft/api/lua/MethodResult;", "getInkLevel", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "computer", "attach", "(Ldan200/computercraft/api/peripheral/IComputerAccess;)V", "detach", "Ldan200/computercraft/api/peripheral/IPeripheral;", "other", "equals", "(Ldan200/computercraft/api/peripheral/IPeripheral;)Z", "Lio/sc3/peripherals/posters/printer/PosterPrinterBlockEntity;", "getBe", "Companion", "sc-peripherals"})
@SourceDebugExtension(value={"SMAP\nPosterPrinterPeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PosterPrinterPeripheral.kt\nio/sc3/peripherals/posters/printer/PosterPrinterPeripheral\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n98#1,11:164\n98#1,11:175\n1#2:186\n*S KotlinDebug\n*F\n+ 1 PosterPrinterPeripheral.kt\nio/sc3/peripherals/posters/printer/PosterPrinterPeripheral\n*L\n65#1:164,11\n83#1:175,11\n*E\n"})
public final class PosterPrinterPeripheral
extends InventoryPeripheral {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PosterPrinterBlockEntity be;
    @NotNull
    private static final String printStatusEvent = "poster_printer_state";
    @NotNull
    private static final String printCompleteEvent = "poster_printer_complete";

    public PosterPrinterPeripheral(@NotNull PosterPrinterBlockEntity be) {
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        super(be);
        this.be = be;
    }

    @NotNull
    public final PosterPrinterBlockEntity getBe() {
        return this.be;
    }

    @NotNull
    public String getType() {
        return "poster_printer";
    }

    @NotNull
    public PosterPrinterBlockEntity getTarget() {
        return this.be;
    }

    @LuaFunction(mainThread=true)
    public final void reset() {
        this.be.setData(new PosterPrintData(null, null, null, null, null, 31, null));
        this.be.dataUpdated();
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final String getLabel() {
        return this.be.getData().getLabel();
    }

    @LuaFunction(mainThread=true)
    public final void setLabel(@NotNull Optional<String> label) {
        Intrinsics.checkNotNullParameter(label, (String)"label");
        this.be.getData().setLabel(label.map(arg_0 -> PosterPrinterPeripheral.setLabel$lambda$1(PosterPrinterPeripheral::setLabel$lambda$0, arg_0)).orElse(null));
        this.be.dataUpdated();
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final String getTooltip() {
        return this.be.getData().getTooltip();
    }

    @LuaFunction(mainThread=true)
    public final void setTooltip(@NotNull Optional<String> tooltip) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        this.be.getData().setTooltip(tooltip.map(arg_0 -> PosterPrinterPeripheral.setTooltip$lambda$3(PosterPrinterPeripheral::setTooltip$lambda$2, arg_0)).orElse(null));
        this.be.dataUpdated();
    }

    @LuaFunction(value={"setPaletteColor", "setPaletteColour"}, mainThread=true)
    public final void setPaletteColor(int index, int red, int green, int blue) {
        if (!(1 <= index ? index < 64 : false)) {
            throw new LuaException("Palette index " + index + " out of range [1, 63]" + (index == 0 ? " (0 is reserved for transparent)" : ""));
        }
        this.be.getData().setPosterId(null);
        this.be.getData().getPalette()[index] = red << 16 | green << 8 | blue;
        this.be.dataUpdated();
    }

    @LuaFunction(mainThread=true)
    public final void setPixel(int x, int y, int color) {
        block5: {
            block4: {
                boolean bl = 1 <= x ? x < 129 : false;
                if (!bl) break block4;
                if (1 <= y ? y < 129 : false) break block5;
            }
            throw new LuaException("Invalid pixel coordinates");
        }
        if (!(0 <= color ? color < 64 : false)) {
            throw new LuaException("Color index " + color + " out of range [0, 63]");
        }
        this.be.getData().setPosterId(null);
        this.be.getData().getColors()[x - 1 + (y - 1) * 128] = (byte)color;
        this.be.dataUpdated();
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction(mainThread=true)
    public final void blitPixels(int x, int y, @NotNull Map<?, ?> pixelMap) {
        List pixels;
        ArrayList<Byte> arrayList;
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter(pixelMap, (String)"pixelMap");
                boolean bl = 1 <= x ? x < 129 : false;
                if (!bl) break block11;
                if (1 <= y ? y < 129 : false) break block12;
            }
            throw new LuaException("Invalid pixel coordinates");
        }
        PosterPrinterPeripheral posterPrinterPeripheral = this;
        Map<?, ?> table$iv = pixelMap;
        boolean $i$f$luaTableToList = false;
        Map<?, ?> $this$luaTableToList_u24lambda_u247$iv2 = table$iv;
        boolean bl = false;
        ArrayList<Byte> it$iv = arrayList = new ArrayList<Byte>($this$luaTableToList_u24lambda_u247$iv2.size());
        boolean bl2 = false;
        int i$iv = 1;
        int n = $this$luaTableToList_u24lambda_u247$iv2.size();
        if (i$iv <= n) {
            while (true) {
                void it;
                Object color$iv;
                double key$iv = i$iv;
                if (!CollectionsKt.contains((Iterable)$this$luaTableToList_u24lambda_u247$iv2.keySet(), (Object)key$iv)) break;
                if ($this$luaTableToList_u24lambda_u247$iv2.get(key$iv) == null) {
                    throw new IllegalStateException("Missing key " + key$iv);
                }
                Object obj = color$iv;
                ArrayList<Byte> arrayList2 = it$iv;
                boolean bl3 = false;
                Number number = it instanceof Number ? (Number)((Number)it) : (Number)null;
                if (number == null) {
                    throw new LuaException("Expected number");
                }
                arrayList2.add(number.byteValue());
                if (i$iv == n) break;
                ++i$iv;
            }
        }
        if ((pixels = (List)arrayList).size() > 16384) {
            throw new LuaException("Too many pixels");
        }
        this.be.getData().setPosterId(null);
        int n2 = ((Collection)pixels).size();
        for (int i2 = 0; i2 < n2; ++i2) {
            byte color = ((Number)pixels.get(i2)).byteValue();
            byte $this$luaTableToList_u24lambda_u247$iv2 = color;
            if (!(0 <= $this$luaTableToList_u24lambda_u247$iv2 ? $this$luaTableToList_u24lambda_u247$iv2 < 64 : false)) {
                throw new LuaException("Color index " + color + " out of range [0, 63]");
            }
            int index = x - 1 + (y - 1) * 128 + i2;
            if (index >= 16384) {
                throw new LuaException("Too many pixels");
            }
            this.be.getData().getColors()[index] = color;
        }
        this.be.dataUpdated();
    }

    /*
     * WARNING - void declaration
     */
    @LuaFunction(mainThread=true)
    public final void blitPalette(@NotNull Map<?, ?> paletteMap) {
        List palette;
        ArrayList<Integer> arrayList;
        Intrinsics.checkNotNullParameter(paletteMap, (String)"paletteMap");
        PosterPrinterPeripheral posterPrinterPeripheral = this;
        Map<?, ?> table$iv = paletteMap;
        boolean $i$f$luaTableToList = false;
        Map<?, ?> $this$luaTableToList_u24lambda_u247$iv = table$iv;
        boolean bl = false;
        ArrayList<Integer> it$iv = arrayList = new ArrayList<Integer>($this$luaTableToList_u24lambda_u247$iv.size());
        boolean bl2 = false;
        int i$iv = 1;
        int n = $this$luaTableToList_u24lambda_u247$iv.size();
        if (i$iv <= n) {
            while (true) {
                void it;
                Object color$iv;
                double key$iv = i$iv;
                if (!CollectionsKt.contains((Iterable)$this$luaTableToList_u24lambda_u247$iv.keySet(), (Object)key$iv)) break;
                if ($this$luaTableToList_u24lambda_u247$iv.get(key$iv) == null) {
                    throw new IllegalStateException("Missing key " + key$iv);
                }
                Object obj = color$iv;
                ArrayList<Integer> arrayList2 = it$iv;
                boolean bl3 = false;
                Number number = it instanceof Number ? (Number)((Number)it) : (Number)null;
                if (number == null) {
                    throw new LuaException("Expected number");
                }
                arrayList2.add(number.intValue());
                if (i$iv == n) break;
                ++i$iv;
            }
        }
        if ((palette = (List)arrayList).size() > 63) {
            throw new LuaException("Too many palette colors (max 63, got " + palette.size() + ")");
        }
        this.be.getData().setPosterId(null);
        int n2 = ((Collection)palette).size();
        for (int i2 = 0; i2 < n2; ++i2) {
            int color = ((Number)palette.get(i2)).intValue();
            if (!(0 <= color ? color < 0x1000000 : false)) {
                throw new LuaException("Invalid color");
            }
            this.be.getData().getPalette()[i2 + 1] = color;
        }
        this.be.dataUpdated();
    }

    private final /* synthetic */ <T extends Number> List<T> luaTableToList(Map<?, ?> table, Function1<Object, ? extends T> transform) {
        ArrayList<Object> arrayList;
        boolean $i$f$luaTableToList = false;
        Map<?, ?> $this$luaTableToList_u24lambda_u247 = table;
        boolean bl = false;
        ArrayList<Object> it = arrayList = new ArrayList<Object>($this$luaTableToList_u24lambda_u247.size());
        boolean bl2 = false;
        int i2 = 1;
        int n = $this$luaTableToList_u24lambda_u247.size();
        if (i2 <= n) {
            while (true) {
                Object color;
                double key = i2;
                if (!CollectionsKt.contains((Iterable)$this$luaTableToList_u24lambda_u247.keySet(), (Object)key)) break;
                if ($this$luaTableToList_u24lambda_u247.get(key) == null) {
                    throw new IllegalStateException("Missing key " + key);
                }
                it.add(transform.invoke(color));
                if (i2 == n) break;
                ++i2;
            }
        }
        return arrayList;
    }

    @LuaFunction(mainThread=true)
    public final boolean commit(int count) {
        boolean bl;
        this.be.setPrintCount(RangesKt.coerceIn((int)count, (int)0, (int)Integer.MAX_VALUE));
        boolean it = bl = this.be.getPrintCount() > 0;
        boolean bl2 = false;
        this.be.setPrinting(it);
        return bl;
    }

    @LuaFunction(mainThread=true)
    public final void stop() {
        this.be.setPrintCount(0);
        this.be.setPrinting(false);
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult status() {
        Pair<String, Object> pair = Companion.printerStatus(this.be);
        String status = (String)pair.component1();
        Object progress = pair.component2();
        Object[] objectArray = new Object[]{status, progress};
        MethodResult methodResult = MethodResult.of((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult getInkLevel() {
        Object[] objectArray = new Object[]{this.be.getInk(), 100000};
        MethodResult methodResult = MethodResult.of((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(...)");
        return methodResult;
    }

    public void attach(@NotNull IComputerAccess computer) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        this.be.getComputers().add(computer);
    }

    public void detach(@NotNull IComputerAccess computer) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        this.be.getComputers().remove(computer);
    }

    public boolean equals(@Nullable IPeripheral other) {
        return Intrinsics.areEqual((Object)this, (Object)other);
    }

    private static final String setLabel$lambda$0(String it) {
        Intrinsics.checkNotNull((Object)it);
        return StringsKt.take((String)it, (int)48);
    }

    private static final String setLabel$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String setTooltip$lambda$2(String it) {
        Intrinsics.checkNotNull((Object)it);
        return StringsKt.take((String)it, (int)256);
    }

    private static final String setTooltip$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lio/sc3/peripherals/posters/printer/PosterPrinterPeripheral$Companion;", "", "<init>", "()V", "Lio/sc3/peripherals/posters/printer/PosterPrinterBlockEntity;", "be", "Lkotlin/Pair;", "", "printerStatus", "(Lio/sc3/peripherals/posters/printer/PosterPrinterBlockEntity;)Lkotlin/Pair;", "", "sendPrintStatusEvent", "(Lio/sc3/peripherals/posters/printer/PosterPrinterBlockEntity;)V", "sendPrintCompleteEvent", "printStatusEvent", "Ljava/lang/String;", "printCompleteEvent", "sc-peripherals"})
    @SourceDebugExtension(value={"SMAP\nPosterPrinterPeripheral.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PosterPrinterPeripheral.kt\nio/sc3/peripherals/posters/printer/PosterPrinterPeripheral$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n1869#2,2:164\n1869#2,2:166\n*S KotlinDebug\n*F\n+ 1 PosterPrinterPeripheral.kt\nio/sc3/peripherals/posters/printer/PosterPrinterPeripheral$Companion\n*L\n154#1:164,2\n159#1:166,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<String, Object> printerStatus(@NotNull PosterPrinterBlockEntity be) {
            Intrinsics.checkNotNullParameter((Object)be, (String)"be");
            return be.getPrinting() || be.getPrintProgress() > 0 ? new Pair((Object)"busy", (Object)be.getPrintProgress()) : new Pair((Object)"idle", (Object)be.canPrint());
        }

        public final void sendPrintStatusEvent(@NotNull PosterPrinterBlockEntity be) {
            Intrinsics.checkNotNullParameter((Object)be, (String)"be");
            String status = (String)this.printerStatus(be).component1();
            Iterable $this$forEach$iv = be.getComputers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IComputerAccess it = (IComputerAccess)element$iv;
                boolean bl = false;
                Object[] objectArray = new Object[]{status};
                it.queueEvent(PosterPrinterPeripheral.printStatusEvent, objectArray);
            }
        }

        public final void sendPrintCompleteEvent(@NotNull PosterPrinterBlockEntity be) {
            Intrinsics.checkNotNullParameter((Object)be, (String)"be");
            int remaining = be.getPrintCount();
            Iterable $this$forEach$iv = be.getComputers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IComputerAccess it = (IComputerAccess)element$iv;
                boolean bl = false;
                Object[] objectArray = new Object[]{remaining};
                it.queueEvent(PosterPrinterPeripheral.printCompleteEvent, objectArray);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

