/*
 * Decompiled with CFR 0.152.
 */
package net.bytzo.sessility.mixins;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.bytzo.sessility.SessilePlayer;
import net.bytzo.sessility.Sessility;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerMixin {
    @Unique
    private static Set<String> advancementActionList = Stream.of("jump").collect(Collectors.collectingAndThen(Collectors.toCollection(HashSet::new), Collections::unmodifiableSet));
    @Unique
    double last_xRot;
    @Unique
    double last_yRot;

    @Unique
    private void processAdvancement(String advancement) {
        if (Sessility.settings().properties().detectAdvancementAction && advancementActionList.contains(advancement)) {
            ((SessilePlayer)((Object)this)).setSessile(false);
        }
    }

    @Inject(method={"awardStat(Lnet/minecraft/resources/ResourceLocation;)V"}, at={@At(value="HEAD")})
    private void preAwardStat(class_2960 res, CallbackInfo callbackInfo) {
        this.processAdvancement(res.method_12832());
    }

    @Inject(method={"awardStat(Lnet/minecraft/resources/ResourceLocation;I)V"}, at={@At(value="HEAD")})
    private void preAwardStat(class_2960 res, int value, CallbackInfo callbackInfo) {
        this.processAdvancement(res.method_12832());
    }

    @Inject(method={"travel(Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="HEAD")})
    private void preTravel(class_243 vec3, CallbackInfo callbackInfo) {
        if (!Sessility.settings().properties().detectRotation) {
            return;
        }
        class_1657 player = (class_1657)this;
        if (player.method_5854() != null || player.method_5765()) {
            return;
        }
        double xRot = player.method_36455();
        double yRot = player.method_36454();
        if (this.last_xRot != xRot || this.last_yRot != yRot) {
            ((SessilePlayer)player).setSessile(false);
        }
        this.last_xRot = xRot;
        this.last_yRot = yRot;
    }
}

