/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.discordbridge.discord;

import cc.reconnected.discordbridge.RccDiscord;
import cc.reconnected.discordbridge.discord.Events;
import club.minnced.discord.webhook.WebhookClient;
import club.minnced.discord.webhook.WebhookClientBuilder;
import java.util.EnumSet;
import java.util.List;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.SelfUser;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.message.MessageUpdateEvent;
import net.dv8tion.jda.api.events.session.ReadyEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.cache.CacheFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Client {
    private TextChannel chatChannel;
    private Webhook webhook;
    private JDA client;
    private final Events events = new Events();
    private Guild guild;
    @Nullable
    private Role role = null;
    private WebhookClient webhookClient;
    private boolean isReady = false;

    public Client() {
        this.initialize();
    }

    public TextChannel chatChannel() {
        return this.chatChannel;
    }

    public Webhook webhook() {
        return this.webhook;
    }

    public WebhookClient webhookClient() {
        return this.webhookClient;
    }

    public JDA client() {
        return this.client;
    }

    public Events events() {
        return this.events;
    }

    public Guild guild() {
        return this.guild;
    }

    public Role role() {
        return this.role;
    }

    public boolean isReady() {
        return this.isReady;
    }

    private void initialize() {
        this.client = JDABuilder.create((String)RccDiscord.CONFIG.token, EnumSet.of(GatewayIntent.GUILD_MESSAGES, GatewayIntent.GUILD_MEMBERS, GatewayIntent.MESSAGE_CONTENT)).disableCache(CacheFlag.ACTIVITY, new CacheFlag[]{CacheFlag.VOICE_STATE, CacheFlag.EMOJI, CacheFlag.STICKER, CacheFlag.CLIENT_STATUS, CacheFlag.ONLINE_STATUS, CacheFlag.SCHEDULED_EVENTS}).addEventListeners(new Object[]{new DiscordEvents()}).build();
    }

    private class DiscordEvents
    extends ListenerAdapter {
        private DiscordEvents() {
        }

        public void onReady(@NotNull ReadyEvent event) {
            SelfUser self = Client.this.client.getSelfUser();
            RccDiscord.LOGGER.info("Logged in as {}", (Object)self.getAsTag());
            Client.this.chatChannel = Client.this.client.getTextChannelById(RccDiscord.CONFIG.channelId);
            if (Client.this.chatChannel == null) {
                RccDiscord.LOGGER.error("Channel not found! Set an existing channel ID that I can see!");
                Client.this.client.shutdown();
                return;
            }
            Client.this.guild = Client.this.chatChannel.getGuild();
            Client.this.role = Client.this.guild.getRoleById(RccDiscord.CONFIG.roleId);
            String webhookName = RccDiscord.CONFIG.name;
            List webhooks = (List)Client.this.chatChannel.retrieveWebhooks().complete();
            webhooks.stream().filter(wh -> wh.getName().equals(webhookName)).findFirst().ifPresent(wh -> {
                Client.this.webhook = wh;
            });
            if (Client.this.webhook == null) {
                Client.this.webhook = (Webhook)Client.this.chatChannel.createWebhook(webhookName).complete();
            }
            if (Client.this.webhook == null) {
                RccDiscord.LOGGER.error("Attempt to create a webhook failed! Please create a WebHook by the name {} and restart the server", (Object)webhookName);
                Client.this.client.shutdown();
                return;
            }
            Client.this.webhookClient = new WebhookClientBuilder(Client.this.webhook.getUrl()).setDaemon(true).buildJDA();
            Client.this.guild.updateCommands().addCommands(new CommandData[]{Commands.slash((String)"link", (String)"Link your Minecraft profile with Discord.").addOption(OptionType.STRING, "code", "Linking code"), Commands.slash((String)"list", (String)"Get online players.")}).queue();
            Client.this.isReady = true;
        }

        public void onMessageReceived(@NotNull MessageReceivedEvent event) {
            Client.this.events.onMessageCreate(event);
        }

        public void onMessageUpdate(@NotNull MessageUpdateEvent event) {
            Client.this.events.onMessageEdit(event);
        }

        public void onSlashCommandInteraction(SlashCommandInteractionEvent event) {
            if (RccDiscord.CONFIG.enableSlashCommands) {
                Client.this.events.onSlashCommandInteraction(event);
            }
        }
    }
}

