/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.discordbridge;

import cc.reconnected.discordbridge.DiscordConfig;
import cc.reconnected.discordbridge.Utils;
import cc.reconnected.discordbridge.commands.DiscordCommand;
import cc.reconnected.discordbridge.discord.Client;
import club.minnced.discord.webhook.send.AllowedMentions;
import club.minnced.discord.webhook.send.WebhookEmbed;
import club.minnced.discord.webhook.send.WebhookEmbedBuilder;
import club.minnced.discord.webhook.send.WebhookMessage;
import club.minnced.discord.webhook.send.WebhookMessageBuilder;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bridge
implements ModInitializer {
    public static final String MOD_ID = "rcc-discord";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"rcc-discord");
    private static Bridge INSTANCE;
    public static final DiscordConfig CONFIG;
    private Client client;
    private static final Queue<Component> chatQueue;
    public static final HashMap<String, class_3222> linkCodes;
    public static ConcurrentHashMap<String, UUID> discordLinks;
    private static Path dataDirectory;

    public Bridge() {
        INSTANCE = this;
    }

    public static Bridge getInstance() {
        return INSTANCE;
    }

    public Client getClient() {
        return this.client;
    }

    public void onInitialize() {
        LOGGER.info("Initializing Discord Bridge");
        try {
            this.client = new Client();
        }
        catch (Exception e) {
            LOGGER.error("Error creating Discord client", (Throwable)e);
            return;
        }
        CommandRegistrationCallback.EVENT.register(DiscordCommand::register);
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            while (!chatQueue.isEmpty()) {
                Component message = chatQueue.poll();
                LOGGER.info(PlainTextComponentSerializer.plainText().serialize(message));
                List list = server.method_3760().method_14571();
                for (class_3222 player : list) {
                    player.sendMessage(message);
                }
            }
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            dataDirectory = server.method_27050(class_5218.field_24188).resolve("data").resolve(MOD_ID);
            if (!this.client.isReady()) {
                return;
            }
            this.sendServerStatus(":hourglass: **Server is starting...**", NamedTextColor.YELLOW.value());
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            Path mapPath;
            if (!dataDirectory.toFile().isDirectory() && !dataDirectory.toFile().mkdir()) {
                LOGGER.error("Failed to create rcc-discord data directory");
            }
            if ((mapPath = dataDirectory.resolve("links.json")).toFile().exists()) {
                try (BufferedReader stream = new BufferedReader(new FileReader(mapPath.toFile(), StandardCharsets.UTF_8));){
                    Type type = new TypeToken<ConcurrentHashMap<String, UUID>>(){}.getType();
                    discordLinks = (ConcurrentHashMap)new Gson().fromJson((Reader)stream, type);
                }
                catch (IOException e) {
                    LOGGER.error("Exception reading licenses data", (Throwable)e);
                }
            } else {
                discordLinks = new ConcurrentHashMap();
            }
            if (!this.client.isReady()) {
                return;
            }
            this.sendServerStatus(":up: **Server started!**", NamedTextColor.GREEN.value());
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            if (!this.client.isReady()) {
                return;
            }
            this.sendServerStatus(":electric_plug: **Server is stopping!**", NamedTextColor.RED.value());
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (!this.client.isReady()) {
                return;
            }
            String playerName = handler.field_14140.method_5476().getString();
            this.sendPlayerStatus(String.format("%s joined the server", playerName), NamedTextColor.GREEN.value(), Utils.getAvatarThumbnailUrl(handler.field_14140));
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            if (!this.client.isReady()) {
                return;
            }
            String playerName = handler.field_14140.method_5476().getString();
            this.sendPlayerStatus(String.format("%s left the server", playerName), NamedTextColor.RED.value(), Utils.getAvatarThumbnailUrl(handler.field_14140));
        });
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (!this.client.isReady()) {
                return;
            }
            if (!(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
            String message = damageSource.method_5506(entity).getString();
            String avatarUrl = Utils.getAvatarThumbnailUrl(player);
            this.sendPlayerStatus(message, NamedTextColor.GRAY.value(), avatarUrl);
        });
        ServerMessageEvents.CHAT_MESSAGE.register((message, sender, params) -> {
            if (!this.client.isReady()) {
                return;
            }
            String playerName = sender.method_5476().getString();
            String avatarUrl = Utils.getAvatarUrl(sender);
            this.sendPlayerMessage(message.message(), playerName, avatarUrl);
        });
    }

    public static void enqueueMessage(Component component) {
        chatQueue.offer(component);
    }

    public void sendServerStatus(String message, int color) {
        if (!this.client.isReady()) {
            return;
        }
        WebhookEmbed embed = new WebhookEmbedBuilder().setDescription(message).setColor(Integer.valueOf(color)).build();
        this.client.webhookClient().send(embed, new WebhookEmbed[0]);
    }

    public void sendPlayerStatus(String message, int color, String avatarUrl) {
        if (!this.client.isReady()) {
            return;
        }
        WebhookEmbed embed = new WebhookEmbedBuilder().setAuthor(new WebhookEmbed.EmbedAuthor(message, avatarUrl, null)).setColor(Integer.valueOf(color)).build();
        this.client.webhookClient().send(embed, new WebhookEmbed[0]);
    }

    public void sendPlayerMessage(String message, String name, String avatarUrl) {
        if (!this.client.isReady()) {
            return;
        }
        WebhookMessage webhookMessage = new WebhookMessageBuilder().setAvatarUrl(avatarUrl).setUsername(name).setContent(message).setAllowedMentions(new AllowedMentions().withParseUsers(true).withParseRoles(true).withParseEveryone(false)).build();
        this.client.webhookClient().send(webhookMessage);
    }

    public void saveData() {
        String output = new Gson().toJson(discordLinks);
        try (FileWriter stream = new FileWriter(dataDirectory.resolve("links.json").toFile(), StandardCharsets.UTF_8);){
            stream.write(output);
        }
        catch (IOException e) {
            LOGGER.error("Exception Discord links map data", (Throwable)e);
        }
    }

    static {
        CONFIG = DiscordConfig.createAndLoad();
        chatQueue = new ConcurrentLinkedQueue<Component>();
        linkCodes = new HashMap();
        discordLinks = new ConcurrentHashMap();
    }
}

