/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.prometheus;

import cc.tweaked.prometheus.CommentedConfigSpec;
import cc.tweaked.prometheus.Config;
import cc.tweaked.prometheus.ServerMetrics;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.GenericBuilder;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2960;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class FabricMod
implements ModInitializer {
    private static final class_5218 configDir;
    private static final String configName = "ccprometheus-server.toml";
    private static final CommentedConfigSpec configSpec;
    private Config config;

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTING.register(this::onServerStarting);
        class_2960 phase = class_2960.method_60655((String)"ccprometheus", (String)"after_cc");
        ServerLifecycleEvents.SERVER_STARTED.addPhaseOrdering(Event.DEFAULT_PHASE, phase);
        ServerLifecycleEvents.SERVER_STARTED.register(phase, server -> ServerMetrics.onServerStart(server, this.config));
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> ServerMetrics.onServerStop());
        ServerTickEvents.END_SERVER_TICK.register(server -> ServerMetrics.onServerTick());
    }

    private void onServerStarting(MinecraftServer server) {
        Path configPath = server.method_27050(configDir).resolve(configName);
        GenericBuilder configBuilder = CommentedFileConfig.builder((Path)configPath).onFileNotFound((path, format) -> {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            format.initEmptyFile(path);
            return false;
        }).preserveInsertionOrder();
        try (CommentedFileConfig config = (CommentedFileConfig)configBuilder.build();){
            config.load();
            configSpec.correct((com.electronwill.nightconfig.core.Config)config);
            config.save();
            this.config = new Config((String)config.get("host"), (Integer)config.get("port"), (Boolean)config.get("vanilla"), (Boolean)config.get("jvm"));
        }
    }

    static {
        try {
            Constructor constructor = class_5218.class.getDeclaredConstructor(String.class);
            constructor.setAccessible(true);
            configDir = (class_5218)constructor.newInstance("serverconfig");
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        configSpec = new CommentedConfigSpec();
        configSpec.comment("host", "The address the Prometheus exporter should be hosted on.");
        configSpec.define("host", "127.0.0.1");
        configSpec.comment("port", "The port the Prometheus exporter should be hosted on.");
        configSpec.defineInRange("port", Integer.valueOf(9226), Integer.valueOf(1), Integer.valueOf(65535));
        configSpec.comment("vanilla", "Whether to expose some metrics about the state of the vanilla server.");
        configSpec.define("vanilla", false);
        configSpec.comment("jvm", "Whether to expose some metrics about the state of the Java runtime.");
        configSpec.define("jvm", false);
    }
}

