/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.prometheus.collectors;

import cc.tweaked.prometheus.MetricContext;
import dan200.computercraft.core.metrics.Metric;
import dan200.computercraft.core.metrics.Metrics;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.metrics.ComputerMetricsObserver;
import dan200.computercraft.shared.computer.metrics.basic.Aggregate;
import dan200.computercraft.shared.computer.metrics.basic.AggregatedMetric;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import io.prometheus.client.SimpleCollector;
import io.prometheus.client.Summary;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.server.MinecraftServer;

public class ComputerFieldCollector
implements ComputerMetricsObserver {
    private final Map<Metric.Counter, Counter> counters = new HashMap<Metric.Counter, Counter>();
    private final Map<Metric.Event, Summary> summaries = new HashMap<Metric.Event, Summary>();
    private final Histogram computerTime;
    private final Histogram serverTime;

    private ComputerFieldCollector(CollectorRegistry registry) {
        for (Metric field : Metric.metrics().values()) {
            if (field == Metrics.COMPUTER_TASKS || field == Metrics.SERVER_TASKS) continue;
            if (field instanceof Metric.Counter) {
                Metric.Counter counter = (Metric.Counter)field;
                this.counters.put(counter, (Counter)ComputerFieldCollector.buildField(field, Counter.build()).register(registry));
                continue;
            }
            if (!(field instanceof Metric.Event)) continue;
            Metric.Event event = (Metric.Event)field;
            this.summaries.put(event, (Summary)ComputerFieldCollector.buildField(field, Summary.build()).register(registry));
        }
        this.computerTime = (Histogram)((Histogram.Builder)((Histogram.Builder)ComputerFieldCollector.buildField((Metric)Metrics.COMPUTER_TASKS, Histogram.build()).name("task_time")).unit("s")).register(registry);
        this.serverTime = (Histogram)((Histogram.Builder)ComputerFieldCollector.buildField((Metric)Metrics.SERVER_TASKS, Histogram.build()).unit("s")).buckets(new double[]{5.0E-4, 0.001, 0.005, 0.01, 0.025, 0.05, 0.1, 0.25}).register(registry);
    }

    public static void register(MetricContext context) {
        ServerContext.get((MinecraftServer)context.server()).metrics().addObserver((ComputerMetricsObserver)new ComputerFieldCollector(context.registry()));
    }

    public void observe(ServerComputer computer, Metric.Counter counter) {
        ((Counter.Child)this.counters.get(counter).labels(new String[]{Integer.toString(computer.getID())})).inc();
    }

    public void observe(ServerComputer computer, Metric.Event event, long value) {
        if (event == Metrics.SERVER_TASKS) {
            ((Histogram.Child)this.serverTime.labels(new String[]{Integer.toString(computer.getID())})).observe((double)value * 1.0E-9);
        } else if (event == Metrics.COMPUTER_TASKS) {
            ((Histogram.Child)this.computerTime.labels(new String[]{Integer.toString(computer.getID())})).observe((double)value * 1.0E-9);
        } else {
            ((Summary.Child)this.summaries.get(event).labels(new String[]{Integer.toString(computer.getID())})).observe((double)value);
        }
    }

    private static <B extends SimpleCollector.Builder<?, ?>> B buildField(Metric field, B builder) {
        return (B)builder.namespace("computercraft").name(field.name()).help(Objects.toString(new AggregatedMetric(field, Aggregate.NONE).displayName())).labelNames(new String[]{"computer_id"});
    }
}

