/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.server.trackers;

import cc.reconnected.server.RccServer;
import cc.reconnected.server.data.StateSaverAndLoader;
import cc.reconnected.server.data.WorldPlayerData;
import cc.reconnected.server.events.PlayerActivityEvents;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class AfkTracker {
    private static final int cycleDelay = 1;
    private static final int absentTimeTrigger = RccServer.CONFIG.afkTimeTrigger() * 20;
    private final HashMap<UUID, PlayerState> playerStates = new HashMap();

    public AfkTracker() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (server.method_3780() % 1 == 0) {
                this.updatePlayers(server);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            this.playerStates.put(player.method_5667(), new PlayerState(player, server.method_3780()));
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            this.updatePlayerActiveTime(handler.method_32311(), server.method_3780());
            this.playerStates.remove(handler.method_32311().method_5667());
        });
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            this.resetAfkState((class_3222)player, world.method_8503());
            return class_1269.field_5811;
        });
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            this.resetAfkState((class_3222)player, world.method_8503());
            return class_1269.field_5811;
        });
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            this.resetAfkState((class_3222)player, world.method_8503());
            return class_1269.field_5811;
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            this.resetAfkState((class_3222)player, world.method_8503());
            return class_1269.field_5811;
        });
        UseItemCallback.EVENT.register((player, world, hand) -> {
            this.resetAfkState((class_3222)player, world.method_8503());
            return class_1271.method_22430((Object)player.method_5998(hand));
        });
        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register((message, sender, params) -> {
            this.resetAfkState(sender, sender.method_5682());
            return true;
        });
        ServerMessageEvents.ALLOW_COMMAND_MESSAGE.register((message, source, params) -> {
            if (!source.method_43737()) {
                return true;
            }
            this.resetAfkState(source.method_44023(), source.method_9211());
            return true;
        });
    }

    private void updatePlayer(class_3222 player, MinecraftServer server) {
        int currentTick = server.method_3780();
        PlayerState playerState = this.playerStates.computeIfAbsent(player.method_5667(), uuid -> new PlayerState(player, currentTick));
        PlayerPosition oldPosition = playerState.position;
        PlayerPosition newPosition = new PlayerPosition(player);
        if (!oldPosition.equals(newPosition)) {
            playerState.position = newPosition;
            this.resetAfkState(player, server);
            return;
        }
        if (playerState.isAfk) {
            return;
        }
        if (playerState.lastUpdate + absentTimeTrigger <= currentTick) {
            this.updatePlayerActiveTime(player, currentTick);
            playerState.isAfk = true;
            ((PlayerActivityEvents.Afk)PlayerActivityEvents.AFK.invoker()).onAfk(player, server);
        }
    }

    private void updatePlayerActiveTime(class_3222 player, int currentTick) {
        PlayerState playerState = this.playerStates.get(player.method_5667());
        if (!playerState.isAfk) {
            WorldPlayerData worldPlayerData = StateSaverAndLoader.getPlayerState((class_1309)player);
            int interval = currentTick - playerState.activeStart;
            worldPlayerData.activeTime += interval / 20;
        }
    }

    private void updatePlayers(MinecraftServer server) {
        List players = server.method_3760().method_14571();
        players.forEach(player -> this.updatePlayer((class_3222)player, server));
    }

    private void resetAfkState(class_3222 player, MinecraftServer server) {
        if (!this.playerStates.containsKey(player.method_5667())) {
            return;
        }
        PlayerState playerState = this.playerStates.get(player.method_5667());
        playerState.lastUpdate = server.method_3780();
        if (playerState.isAfk) {
            playerState.isAfk = false;
            playerState.activeStart = server.method_3780();
            ((PlayerActivityEvents.AfkReturn)PlayerActivityEvents.AFK_RETURN.invoker()).onAfkReturn(player, server);
        }
    }

    public boolean isPlayerAfk(UUID playerUuid) {
        if (!this.playerStates.containsKey(playerUuid)) {
            return false;
        }
        return this.playerStates.get((Object)playerUuid).isAfk;
    }

    public void setPlayerAfk(class_3222 player, boolean afk) {
        if (!this.playerStates.containsKey(player.method_5667())) {
            return;
        }
        MinecraftServer server = player.method_37908().method_8503();
        if (afk) {
            this.playerStates.get((Object)player.method_5667()).lastUpdate = -absentTimeTrigger - 20;
        } else {
            this.resetAfkState(player, server);
        }
        this.updatePlayer(player, server);
    }

    public int getActiveTime(class_3222 player) {
        WorldPlayerData worldPlayerData = StateSaverAndLoader.getPlayerState((class_1309)player);
        return worldPlayerData.activeTime;
    }

    public static class PlayerState {
        public PlayerPosition position;
        public int lastUpdate;
        public boolean isAfk;
        public int activeStart;

        public PlayerState(class_3222 player, int lastUpdate) {
            this.position = new PlayerPosition(player);
            this.lastUpdate = lastUpdate;
            this.isAfk = false;
            this.activeStart = lastUpdate;
        }
    }

    public static class PlayerPosition {
        public String dimension;
        public double x;
        public double y;
        public double z;
        public float yaw;
        public float pitch;

        public boolean equals(PlayerPosition obj) {
            return this.x == obj.x && this.y == obj.y && this.z == obj.z && this.yaw == obj.yaw && this.pitch == obj.pitch && this.dimension.equals(obj.dimension);
        }

        public PlayerPosition(class_3222 player) {
            this.dimension = player.method_37908().method_27983().method_29177().toString();
            this.x = player.method_23317();
            this.y = player.method_23318();
            this.z = player.method_23321();
            this.yaw = player.method_36454();
            this.pitch = player.method_36455();
        }
    }
}

