/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.text.font;

import io.sc3.text.TextExtKt;
import io.sc3.text.font.FontCalculatorKt;
import io.sc3.text.font.TextVisitHelpers;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\u000b\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b\n\u0010\u0003J\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ/\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\b\b\u0002\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\f\u00a2\u0006\u0004\b\u001e\u0010\u000fR\"\u0010!\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\"\u0010(\u001a\u00020'8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\"\u0010.\u001a\u00020'8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010)\u001a\u0004\b/\u0010+\"\u0004\b0\u0010-\u00a8\u00061"}, d2={"Lio/sc3/text/font/FontCalculator;", "", "<init>", "()V", "Lnet/minecraft/class_2561;", "text", "padding", "center", "(Lnet/minecraft/class_2561;Lnet/minecraft/class_2561;)Lnet/minecraft/class_2561;", "", "init$sc_text", "init", "Lnet/minecraft/class_5348;", "", "lineCount", "(Lnet/minecraft/class_5348;)I", "Lnet/minecraft/class_5250;", "out", "", "char", "Lnet/minecraft/class_2583;", "style", "count", "pad", "(Lnet/minecraft/class_5250;Ljava/lang/String;Lnet/minecraft/class_2583;I)V", "surroundWithSpaces", "(Lnet/minecraft/class_2561;)Lnet/minecraft/class_2561;", "code", "", "bold", "width", "(IZ)I", "Lorg/slf4j/Logger;", "LOG", "Lorg/slf4j/Logger;", "getLOG", "()Lorg/slf4j/Logger;", "setLOG", "(Lorg/slf4j/Logger;)V", "", "boldGlyphSizes", "[B", "getBoldGlyphSizes", "()[B", "setBoldGlyphSizes", "([B)V", "glyphSizes", "getGlyphSizes", "setGlyphSizes", "sc-text"})
public final class FontCalculator {
    @NotNull
    public static final FontCalculator INSTANCE = new FontCalculator();
    @NotNull
    private static byte[] glyphSizes = new byte[65536];
    @NotNull
    private static byte[] boldGlyphSizes = new byte[65536];
    @NotNull
    private static Logger LOG;

    private FontCalculator() {
    }

    @NotNull
    public final byte[] getGlyphSizes() {
        return glyphSizes;
    }

    public final void setGlyphSizes(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        glyphSizes = byArray;
    }

    @NotNull
    public final byte[] getBoldGlyphSizes() {
        return boldGlyphSizes;
    }

    public final void setBoldGlyphSizes(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        boldGlyphSizes = byArray;
    }

    public final int width(int code, boolean bold) {
        if (code == 32) {
            return 4;
        }
        if (code > 65535) {
            return 8;
        }
        return bold ? boldGlyphSizes[code] : glyphSizes[code];
    }

    public static /* synthetic */ int width$default(FontCalculator fontCalculator, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return fontCalculator.width(n, bl);
    }

    public final int width(@NotNull class_5348 text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Ref.IntRef total = new Ref.IntRef();
        Ref.BooleanRef newLine = new Ref.BooleanRef();
        class_2583 class_25832 = class_2583.field_24360;
        Intrinsics.checkNotNullExpressionValue((Object)class_25832, (String)"EMPTY");
        TextVisitHelpers.INSTANCE.visitFormatted(text, class_25832, (arg_0, arg_1, arg_2) -> FontCalculator.width$lambda$0(newLine, total, arg_0, arg_1, arg_2));
        return total.element;
    }

    public final int lineCount(@NotNull class_5348 text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return (int)Math.ceil((double)this.width(text) / (double)320);
    }

    @NotNull
    public final class_2561 center(@NotNull class_2561 text, @NotNull class_2561 padding) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)padding, (String)"padding");
        int width = this.width((class_5348)text);
        if (width >= 320) {
            return text;
        }
        class_2561 innerText = text;
        int innerTextWidth = width;
        class_2561 withSpaces = this.surroundWithSpaces(text);
        int withSpacesWidth = this.width((class_5348)withSpaces);
        if (withSpacesWidth <= 320) {
            innerText = withSpaces;
            innerTextWidth = withSpacesWidth;
        }
        String padChar = padding.getString();
        int padWidth = this.width((class_5348)padding);
        if (padWidth < 1) {
            padChar = "=";
            padWidth = this.width((class_5348)padding);
        }
        class_2583 padStyle = padding.method_10866();
        if (padWidth == 0) {
            throw new IllegalArgumentException("Padding character has width 0");
        }
        class_5250 out = TextExtKt.of("", new class_124[0]);
        if (width == 0) {
            String string = padChar;
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNull((Object)padStyle);
            this.pad(out, string, padStyle, 320 / padWidth);
        } else {
            int padNeeded = 320 - innerTextWidth;
            int padCount = (int)Math.floor((double)padNeeded / (double)padWidth);
            int beforePad = (int)Math.floor((double)padCount / (double)2);
            int afterPad = padCount - beforePad - 1;
            String string = padChar;
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNull((Object)padStyle);
            this.pad(out, string, padStyle, beforePad);
            out.method_10852(innerText);
            string = padChar;
            Intrinsics.checkNotNull((Object)string);
            this.pad(out, string, padStyle, afterPad);
        }
        return (class_2561)out;
    }

    public static /* synthetic */ class_2561 center$default(FontCalculator fontCalculator, class_2561 class_25612, class_2561 class_25613, int n, Object object) {
        if ((n & 2) != 0) {
            class_25613 = (class_2561)TextExtKt.of("=", new class_124[0]);
        }
        return fontCalculator.center(class_25612, class_25613);
    }

    private final class_2561 surroundWithSpaces(class_2561 text) {
        class_5250 class_52502 = TextExtKt.of(" ", new class_124[0]).method_10852((class_2561)text.method_27661()).method_27693(" ");
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"append(...)");
        return (class_2561)class_52502;
    }

    private final void pad(class_5250 out, String string, class_2583 style, int count) {
        if (count <= 0) {
            return;
        }
        out.method_10852((class_2561)class_2561.method_43470((String)StringsKt.repeat((CharSequence)string, (int)count)).method_10862(style));
    }

    public final void init$sc_text() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void method_14491(@NotNull class_3300 rm) {
                Intrinsics.checkNotNullParameter((Object)rm, (String)"rm");
                Closeable closeable = rm.getResourceOrThrow(FontCalculatorKt.getSIZES_ID()).method_14482();
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    byte[] byArray = it.readNBytes(65536);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
                    FontCalculator.INSTANCE.setGlyphSizes(byArray);
                    byte[] byArray2 = it.readNBytes(65536);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"readNBytes(...)");
                    FontCalculator.INSTANCE.setBoldGlyphSizes(byArray2);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                FontCalculator.INSTANCE.getLOG().info("Loaded glyph sizes for {} glyphs", (Object)FontCalculator.INSTANCE.getGlyphSizes().length);
            }

            @NotNull
            public class_2960 getFabricId() {
                class_2960 class_29602 = FontCalculatorKt.getSIZES_ID();
                Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"<get-SIZES_ID>(...)");
                return class_29602;
            }
        });
    }

    @NotNull
    public final Logger getLOG() {
        return LOG;
    }

    public final void setLOG(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"<set-?>");
        LOG = logger;
    }

    private static final boolean width$lambda$0(Ref.BooleanRef $newLine, Ref.IntRef $total, int n, class_2583 style, int code) {
        Intrinsics.checkNotNullParameter((Object)$newLine, (String)"$newLine");
        Intrinsics.checkNotNullParameter((Object)$total, (String)"$total");
        if (code == 10) {
            if ($newLine.element) {
                $total.element += 320;
            } else {
                $total.element = (int)Math.ceil((double)$total.element / (double)320) * 320;
                $newLine.element = true;
            }
        } else {
            $total.element += INSTANCE.width(code, style.method_10984());
            $newLine.element = false;
        }
        return true;
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)"ScText/FontCalculator");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

