/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.text.pagination;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.sc3.text.TextExtKt;
import io.sc3.text.font.FontCalculator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 92\u00020\u0001:\u00019BG\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\u0004\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\tH&\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\tH&\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010\r\u001a\u00020\tH&\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J+\u0010\u001e\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b \u0010\u0019J\u0015\u0010!\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\t\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010#\u001a\u00020\tH&\u00a2\u0006\u0004\b#\u0010$R\u001b\u0010(\u001a\u00020\t8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010$R\"\u0010\u001b\u001a\u00020\t8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010)\u001a\u0004\b*\u0010$\"\u0004\b+\u0010\"R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010,R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010,R\"\u0010/\u001a\n .*\u0004\u0018\u00010-0-8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010)R\u0014\u00104\u001a\u0002038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0014\u0010\b\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010,R\u0014\u00106\u001a\u0002038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00105R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00107R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010,R\u0016\u00108\u001a\u0004\u0018\u00010\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u0010,\u00a8\u0006:"}, d2={"Lio/sc3/text/pagination/ActivePagination;", "", "Lnet/minecraft/class_2168;", "src", "Lnet/minecraft/class_2561;", "title", "header", "footer", "padding", "", "linesPerPage", "<init>", "(Lnet/minecraft/class_2168;Lnet/minecraft/class_2561;Lnet/minecraft/class_2561;Lnet/minecraft/class_2561;Lnet/minecraft/class_2561;I)V", "page", "calculateFooter", "(I)Lnet/minecraft/class_2561;", "", "hasNext", "(I)Z", "hasPrevious", "", "lines", "(I)Ljava/lang/Iterable;", "", "nextPage", "()V", "", "currentPage", "currentPageLines", "addContinuation", "padPage", "(Ljava/util/List;IZ)V", "previousPage", "specificPage", "(I)V", "totalPages", "()I", "contentLinesPerPage$delegate", "Lkotlin/Lazy;", "getContentLinesPerPage", "contentLinesPerPage", "I", "getCurrentPage", "setCurrentPage", "Lnet/minecraft/class_2561;", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "id", "Ljava/util/UUID;", "getId$sc_text", "()Ljava/util/UUID;", "Lnet/minecraft/class_5250;", "nextPageText", "Lnet/minecraft/class_5250;", "prevPageText", "Lnet/minecraft/class_2168;", "titleCentered", "Companion", "sc-text"})
@SourceDebugExtension(value={"SMAP\nActivePagination.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActivePagination.kt\nio/sc3/text/pagination/ActivePagination\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1855#2,2:132\n*S KotlinDebug\n*F\n+ 1 ActivePagination.kt\nio/sc3/text/pagination/ActivePagination\n*L\n72#1:132,2\n*E\n"})
public abstract class ActivePagination {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final class_2168 src;
    @Nullable
    private final class_2561 title;
    @Nullable
    private final class_2561 header;
    @Nullable
    private final class_2561 footer;
    @NotNull
    private final class_2561 padding;
    private final int linesPerPage;
    private final UUID id;
    private int currentPage;
    @Nullable
    private final class_2561 titleCentered;
    @NotNull
    private final class_5250 prevPageText;
    @NotNull
    private final class_5250 nextPageText;
    @NotNull
    private final Lazy contentLinesPerPage$delegate;
    @NotNull
    private static final SimpleCommandExceptionType PAGE_NO_PREV_EXCEPTION = new SimpleCommandExceptionType((Message)TextExtKt.of("There is no previous page.", new class_124[0]));
    @NotNull
    private static final SimpleCommandExceptionType PAGE_NO_NEXT_EXCEPTION = new SimpleCommandExceptionType((Message)TextExtKt.of("There is no next page.", new class_124[0]));

    public ActivePagination(@NotNull class_2168 src, @Nullable class_2561 title, @Nullable class_2561 header, @Nullable class_2561 footer, @NotNull class_2561 padding, int linesPerPage) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)padding, (String)"padding");
        this.src = src;
        this.title = title;
        this.header = header;
        this.footer = footer;
        this.padding = padding;
        this.linesPerPage = linesPerPage;
        this.id = UUID.randomUUID();
        this.currentPage = 1;
        this.titleCentered = this.title != null ? FontCalculator.INSTANCE.center(this.title, this.padding) : null;
        UUID uUID = this.id;
        Intrinsics.checkNotNull((Object)uUID);
        this.prevPageText = io.sc3.text.pagination.ActivePagination$Companion.pageText$default(Companion, uUID, "prev", "\u00ab", false, 8, null);
        uUID = this.id;
        Intrinsics.checkNotNull((Object)uUID);
        this.nextPageText = io.sc3.text.pagination.ActivePagination$Companion.pageText$default(Companion, uUID, "next", "\u00bb", false, 8, null);
        this.contentLinesPerPage$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ ActivePagination this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                int lines2 = ActivePagination.access$getLinesPerPage$p(this.this$0) - 1;
                if (ActivePagination.access$getTitle$p(this.this$0) != null) {
                    lines2 -= FontCalculator.INSTANCE.lineCount((class_5348)ActivePagination.access$getTitle$p(this.this$0));
                }
                if (ActivePagination.access$getHeader$p(this.this$0) != null) {
                    lines2 -= FontCalculator.INSTANCE.lineCount((class_5348)ActivePagination.access$getHeader$p(this.this$0));
                }
                if (ActivePagination.access$getFooter$p(this.this$0) != null) {
                    lines2 -= FontCalculator.INSTANCE.lineCount((class_5348)ActivePagination.access$getFooter$p(this.this$0));
                }
                return lines2;
            }
        }));
    }

    public /* synthetic */ ActivePagination(class_2168 class_21682, class_2561 class_25612, class_2561 class_25613, class_2561 class_25614, class_2561 class_25615, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            class_25612 = null;
        }
        if ((n2 & 4) != 0) {
            class_25613 = null;
        }
        if ((n2 & 8) != 0) {
            class_25614 = null;
        }
        if ((n2 & 0x10) != 0) {
            class_25615 = (class_2561)TextExtKt.of("=", new class_124[0]);
        }
        if ((n2 & 0x20) != 0) {
            n = 20;
        }
        this(class_21682, class_25612, class_25613, class_25614, class_25615, n);
    }

    public final UUID getId$sc_text() {
        return this.id;
    }

    protected final int getCurrentPage() {
        return this.currentPage;
    }

    protected final void setCurrentPage(int n) {
        this.currentPage = n;
    }

    protected final int getContentLinesPerPage() {
        Lazy lazy = this.contentLinesPerPage$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @NotNull
    public abstract Iterable<class_2561> lines(int var1);

    public abstract boolean hasPrevious(int var1);

    public abstract boolean hasNext(int var1);

    public abstract int totalPages();

    public void nextPage() {
        if (!this.hasNext(this.currentPage)) {
            CommandSyntaxException commandSyntaxException = PAGE_NO_NEXT_EXCEPTION.create();
            Intrinsics.checkNotNullExpressionValue((Object)commandSyntaxException, (String)"create(...)");
            throw (Throwable)commandSyntaxException;
        }
        this.specificPage(this.currentPage + 1);
    }

    public void previousPage() {
        if (!this.hasPrevious(this.currentPage)) {
            CommandSyntaxException commandSyntaxException = PAGE_NO_PREV_EXCEPTION.create();
            Intrinsics.checkNotNullExpressionValue((Object)commandSyntaxException, (String)"create(...)");
            throw (Throwable)commandSyntaxException;
        }
        this.specificPage(this.currentPage - 1);
    }

    public final void specificPage(int page) {
        this.currentPage = RangesKt.coerceAtLeast((int)page, (int)1);
        List out = new ArrayList();
        if (this.titleCentered != null) {
            out.add(this.titleCentered);
        }
        if (this.header != null) {
            out.add(this.header);
        }
        CollectionsKt.addAll((Collection)out, this.lines(page));
        out.add(this.calculateFooter(page));
        if (this.footer != null) {
            out.add(this.footer);
        }
        Iterable $this$forEach$iv = out;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_2561 it = (class_2561)element$iv;
            boolean bl = false;
            this.src.method_9226(() -> ActivePagination.specificPage$lambda$1$lambda$0(it), false);
        }
    }

    private final class_2561 calculateFooter(int page) {
        boolean hasPrevious = this.hasPrevious(page);
        boolean hasNext = this.hasNext(page);
        int totalPages = this.totalPages();
        class_5250 out = TextExtKt.of("", new class_124[0]);
        if (hasPrevious) {
            TextExtKt.plus(TextExtKt.plus(out, (class_2561)this.prevPageText), " ");
        } else {
            TextExtKt.plus(out, "\u00ab ");
        }
        if (totalPages > 1) {
            UUID uUID = this.id;
            Intrinsics.checkNotNull((Object)uUID);
            class_5250 currentPageText = Companion.pageText(uUID, page);
            UUID uUID2 = this.id;
            Intrinsics.checkNotNull((Object)uUID2);
            class_5250 lastPageText = Companion.pageText(uUID2, totalPages);
            TextExtKt.plus(TextExtKt.plus(TextExtKt.plus(TextExtKt.plus(out, (class_2561)currentPageText), "/"), (class_2561)lastPageText), " ");
        }
        if (hasNext) {
            TextExtKt.plus(TextExtKt.plus(out, (class_2561)this.nextPageText), " ");
        } else {
            TextExtKt.plus(out, "\u00bb");
        }
        TextExtKt.color(out, this.padding.method_10866().method_10973());
        if (this.title != null) {
            out.method_10862(this.title.method_10866());
        }
        return FontCalculator.INSTANCE.center((class_2561)out, this.padding);
    }

    public final void padPage(@NotNull List<class_2561> currentPage, int currentPageLines, boolean addContinuation) {
        Intrinsics.checkNotNullParameter(currentPage, (String)"currentPage");
        int contentLinesPerPage2 = this.getContentLinesPerPage();
        for (int i = currentPageLines; i < contentLinesPerPage2; ++i) {
            if (addContinuation && i == contentLinesPerPage2 - 1) {
                currentPage.add((class_2561)TextExtKt.of("...", new class_124[0]));
                continue;
            }
            class_5250 class_52502 = class_2561.method_43473();
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"empty(...)");
            currentPage.add(0, (class_2561)class_52502);
        }
    }

    private static final class_2561 specificPage$lambda$1$lambda$0(class_2561 $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return $it;
    }

    public static final /* synthetic */ int access$getLinesPerPage$p(ActivePagination $this) {
        return $this.linesPerPage;
    }

    public static final /* synthetic */ class_2561 access$getTitle$p(ActivePagination $this) {
        return $this.title;
    }

    public static final /* synthetic */ class_2561 access$getHeader$p(ActivePagination $this) {
        return $this.header;
    }

    public static final /* synthetic */ class_2561 access$getFooter$p(ActivePagination $this) {
        return $this.footer;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ1\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\t\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lio/sc3/text/pagination/ActivePagination$Companion;", "", "<init>", "()V", "Ljava/util/UUID;", "id", "", "page", "Lnet/minecraft/class_5250;", "pageText", "(Ljava/util/UUID;I)Lnet/minecraft/class_5250;", "", "text", "", "formatting", "(Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;Z)Lnet/minecraft/class_5250;", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "PAGE_NO_NEXT_EXCEPTION", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "PAGE_NO_PREV_EXCEPTION", "sc-text"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_5250 pageText(@NotNull UUID id, @NotNull String page, @NotNull String text, boolean formatting) {
            class_5250 class_52502;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)page, (String)"page");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            if (formatting) {
                class_124[] class_124Array = new class_124[]{class_124.field_1078, class_124.field_1073};
                class_52502 = TextExtKt.of(text, class_124Array);
            } else {
                class_52502 = TextExtKt.of(text, new class_124[0]);
            }
            return TextExtKt.shiftInsertText(TextExtKt.hover(TextExtKt.runCommand(class_52502, "/sc-text:pagination " + id + " " + page), (class_2561)TextExtKt.of("/page " + page, new class_124[0])), "/sc-text:page " + page);
        }

        public static /* synthetic */ class_5250 pageText$default(Companion companion, UUID uUID, String string, String string2, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = string;
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            return companion.pageText(uUID, string, string2, bl);
        }

        @NotNull
        public final class_5250 pageText(@NotNull UUID id, int page) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            String string = String.valueOf(page);
            String string2 = "%,d";
            Object[] objectArray = new Object[]{page};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            return this.pageText(id, string, string3, false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

