/*
 * Decompiled with CFR 0.152.
 */
package ct.discordbridge;

import club.minnced.discord.webhook.send.AllowedMentions;
import club.minnced.discord.webhook.send.WebhookEmbed;
import club.minnced.discord.webhook.send.WebhookEmbedBuilder;
import club.minnced.discord.webhook.send.WebhookMessage;
import club.minnced.discord.webhook.send.WebhookMessageBuilder;
import ct.discordbridge.DiscordConfig;
import ct.discordbridge.Utils;
import ct.discordbridge.discord.Client;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bridge
implements ModInitializer {
    public static final String MOD_ID = "ct-discord";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ct-discord");
    private static Bridge INSTANCE;
    public static final DiscordConfig CONFIG;
    private Client client;
    private static final Queue<Component> chatQueue;

    public Bridge() {
        INSTANCE = this;
    }

    public static Bridge getInstance() {
        return INSTANCE;
    }

    public Client getClient() {
        return this.client;
    }

    public void onInitialize() {
        LOGGER.info("Initializing Discord Bridge");
        try {
            this.client = new Client();
        }
        catch (Exception e) {
            LOGGER.error("Error creating Discord client", (Throwable)e);
            return;
        }
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            while (!chatQueue.isEmpty()) {
                Component message = chatQueue.poll();
                LOGGER.info(PlainTextComponentSerializer.plainText().serialize(message));
                List list = server.method_3760().method_14571();
                for (class_3222 player : list) {
                    player.sendMessage(message);
                }
            }
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> this.sendServerStatus(":hourglass: **Server is starting...**", NamedTextColor.YELLOW.value()));
        ServerLifecycleEvents.SERVER_STARTED.register(server -> this.sendServerStatus(":up: **Server started!**", NamedTextColor.GREEN.value()));
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> this.sendServerStatus(":electric_plug: **Server is stopping!**", NamedTextColor.RED.value()));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            String playerName = handler.field_14140.method_5476().getString();
            this.sendPlayerStatus(String.format("%s joined the server", playerName), NamedTextColor.GREEN.value(), Utils.getAvatarThumbnailUrl(handler.field_14140));
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            String playerName = handler.field_14140.method_5476().getString();
            this.sendPlayerStatus(String.format("%s left the server", playerName), NamedTextColor.RED.value(), Utils.getAvatarThumbnailUrl(handler.field_14140));
        });
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (!(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
            String message = damageSource.method_5506(entity).getString();
            String avatarUrl = Utils.getAvatarThumbnailUrl(player);
            this.sendPlayerStatus(message, NamedTextColor.GRAY.value(), avatarUrl);
        });
        ServerMessageEvents.CHAT_MESSAGE.register((message, sender, params) -> {
            String playerName = sender.method_5476().getString();
            String avatarUrl = Utils.getAvatarUrl(sender);
            this.sendPlayerMessage(message.message(), playerName, avatarUrl);
        });
    }

    public static void enqueueMessage(Component component) {
        chatQueue.offer(component);
    }

    public void sendServerStatus(String message, int color) {
        WebhookEmbed embed = new WebhookEmbedBuilder().setDescription(message).setColor(Integer.valueOf(color)).build();
        this.client.webhookClient().send(embed, new WebhookEmbed[0]);
    }

    public void sendPlayerStatus(String message, int color, String avatarUrl) {
        WebhookEmbed embed = new WebhookEmbedBuilder().setAuthor(new WebhookEmbed.EmbedAuthor(message, avatarUrl, null)).setColor(Integer.valueOf(color)).build();
        this.client.webhookClient().send(embed, new WebhookEmbed[0]);
    }

    public void sendPlayerMessage(String message, String name, String avatarUrl) {
        WebhookMessage webhookMessage = new WebhookMessageBuilder().setAvatarUrl(avatarUrl).setUsername(name).setContent(message).setAllowedMentions(new AllowedMentions().withParseUsers(true).withParseRoles(true).withParseEveryone(false)).build();
        this.client.webhookClient().send(webhookMessage);
    }

    static {
        CONFIG = DiscordConfig.createAndLoad();
        chatQueue = new ConcurrentLinkedQueue<Component>();
    }
}

