/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.config;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.cortex.nvidium.Nvidium;
import me.cortex.nvidium.config.StatisticsLoggingLevel;
import me.cortex.nvidium.config.TranslucencySortingLevel;
import net.fabricmc.loader.api.FabricLoader;

public class NvidiumConfig {
    public int extra_rd = 100;
    public boolean enable_temporal_coherence = true;
    public int max_geometry_memory = 2048;
    public boolean automatic_memory = true;
    public boolean async_bfs = true;
    public int region_keep_distance = 32;
    public boolean render_fog = true;
    public TranslucencySortingLevel translucency_sorting_level = TranslucencySortingLevel.QUADS;
    public StatisticsLoggingLevel statistics_level = StatisticsLoggingLevel.NONE;
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();

    private NvidiumConfig() {
    }

    public static NvidiumConfig loadOrCreate() {
        Path path = NvidiumConfig.getConfigPath();
        if (Files.exists(path, new LinkOption[0])) {
            NvidiumConfig nvidiumConfig;
            FileReader reader = new FileReader(path.toFile());
            try {
                nvidiumConfig = (NvidiumConfig)GSON.fromJson((Reader)reader, NvidiumConfig.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Nvidium.LOGGER.error("Could not parse config", (Throwable)e);
                }
            }
            reader.close();
            return nvidiumConfig;
        }
        return new NvidiumConfig();
    }

    public void save() {
        try {
            Files.writeString(NvidiumConfig.getConfigPath(), (CharSequence)GSON.toJson((Object)this), new OpenOption[0]);
        }
        catch (IOException e) {
            Nvidium.LOGGER.error("Failed to write config file", (Throwable)e);
        }
    }

    private static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("nvidium-config.json");
    }
}

