/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger.utility;

import com.github.quiltservertools.ledger.database.Tables;
import com.github.quiltservertools.ledger.utility.ExtensionsKt;
import com.github.quiltservertools.ledger.utility.MessageUtils;
import com.github.quiltservertools.ledger.utility.TextColorPallet;
import java.time.Instant;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0001&B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0013J8\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u0019\u001a\u00020\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u0011R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001f\u001a\u0004\b \u0010\u000fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010!\u001a\u0004\b\"\u0010\u0011R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010#\u001a\u0004\b$\u0010\u0013R\u0017\u0010\b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010#\u001a\u0004\b%\u0010\u0013\u00a8\u0006'"}, d2={"Lcom/github/quiltservertools/ledger/utility/PlayerResult;", "", "Ljava/util/UUID;", "uuid", "", "name", "Ljava/time/Instant;", "firstJoin", "lastJoin", "<init>", "(Ljava/util/UUID;Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;)V", "Lnet/minecraft/class_2561;", "toText", "()Lnet/minecraft/class_2561;", "component1", "()Ljava/util/UUID;", "component2", "()Ljava/lang/String;", "component3", "()Ljava/time/Instant;", "component4", "copy", "(Ljava/util/UUID;Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;)Lcom/github/quiltservertools/ledger/utility/PlayerResult;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/util/UUID;", "getUuid", "Ljava/lang/String;", "getName", "Ljava/time/Instant;", "getFirstJoin", "getLastJoin", "Companion", "ledger"})
public final class PlayerResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID uuid;
    @NotNull
    private final String name;
    @NotNull
    private final Instant firstJoin;
    @NotNull
    private final Instant lastJoin;

    public PlayerResult(@NotNull UUID uuid, @NotNull String name, @NotNull Instant firstJoin, @NotNull Instant lastJoin) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)firstJoin, (String)"firstJoin");
        Intrinsics.checkNotNullParameter((Object)lastJoin, (String)"lastJoin");
        this.uuid = uuid;
        this.name = name;
        this.firstJoin = firstJoin;
        this.lastJoin = lastJoin;
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Instant getFirstJoin() {
        return this.firstJoin;
    }

    @NotNull
    public final Instant getLastJoin() {
        return this.lastJoin;
    }

    @NotNull
    public final class_2561 toText() {
        Object[] objectArray = new Object[]{ExtensionsKt.literal(this.name).method_10862(TextColorPallet.INSTANCE.getLight()), MessageUtils.INSTANCE.instantToText(this.firstJoin).method_10862(TextColorPallet.INSTANCE.getPrimaryVariant()), MessageUtils.INSTANCE.instantToText(this.lastJoin).method_10862(TextColorPallet.INSTANCE.getPrimaryVariant())};
        class_5250 class_52502 = class_2561.method_43469((String)"text.ledger.player.result", (Object[])objectArray).method_10862(TextColorPallet.INSTANCE.getSecondary());
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"setStyle(...)");
        return (class_2561)class_52502;
    }

    @NotNull
    public final UUID component1() {
        return this.uuid;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final Instant component3() {
        return this.firstJoin;
    }

    @NotNull
    public final Instant component4() {
        return this.lastJoin;
    }

    @NotNull
    public final PlayerResult copy(@NotNull UUID uuid, @NotNull String name, @NotNull Instant firstJoin, @NotNull Instant lastJoin) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)firstJoin, (String)"firstJoin");
        Intrinsics.checkNotNullParameter((Object)lastJoin, (String)"lastJoin");
        return new PlayerResult(uuid, name, firstJoin, lastJoin);
    }

    public static /* synthetic */ PlayerResult copy$default(PlayerResult playerResult, UUID uUID, String string, Instant instant, Instant instant2, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = playerResult.uuid;
        }
        if ((n & 2) != 0) {
            string = playerResult.name;
        }
        if ((n & 4) != 0) {
            instant = playerResult.firstJoin;
        }
        if ((n & 8) != 0) {
            instant2 = playerResult.lastJoin;
        }
        return playerResult.copy(uUID, string, instant, instant2);
    }

    @NotNull
    public String toString() {
        return "PlayerResult(uuid=" + this.uuid + ", name=" + this.name + ", firstJoin=" + this.firstJoin + ", lastJoin=" + this.lastJoin + ")";
    }

    public int hashCode() {
        int result = this.uuid.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.firstJoin.hashCode();
        result = result * 31 + this.lastJoin.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PlayerResult)) {
            return false;
        }
        PlayerResult playerResult = (PlayerResult)other;
        if (!Intrinsics.areEqual((Object)this.uuid, (Object)playerResult.uuid)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)playerResult.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.firstJoin, (Object)playerResult.firstJoin)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.lastJoin, (Object)playerResult.lastJoin);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/github/quiltservertools/ledger/utility/PlayerResult$Companion;", "", "<init>", "()V", "Lcom/github/quiltservertools/ledger/database/Tables$Player;", "row", "Lcom/github/quiltservertools/ledger/utility/PlayerResult;", "fromRow", "(Lcom/github/quiltservertools/ledger/database/Tables$Player;)Lcom/github/quiltservertools/ledger/utility/PlayerResult;", "ledger"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PlayerResult fromRow(@NotNull Tables.Player row) {
            Intrinsics.checkNotNullParameter((Object)((Object)row), (String)"row");
            return new PlayerResult(row.getPlayerId(), row.getPlayerName(), row.getFirstJoin(), row.getLastJoin());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

