/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.cerberus.client;

import cc.reconnected.cerberus.client.HashedModDefinition;
import cc.reconnected.cerberus.client.Packets.ResourcesPacket;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModOrigin;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3288;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class CerberusClient
implements ClientModInitializer {
    public static final String MOD_ID = "Cerberus";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Cerberus");
    private final Gson gson = new GsonBuilder().create();
    public static final class_2960 USED_RESOURCES_IDENTIFIER = new class_2960("protoyap", "used_resources");

    public void onInitializeClient() {
        LOGGER.info("Throw me a bone will ya?");
        ClientLoginNetworking.registerGlobalReceiver((class_2960)USED_RESOURCES_IDENTIFIER, (client, handler, buf, responseSender) -> client.method_5385(() -> {
            try {
                String modList = this.getMods();
                return ResourcesPacket.createResourcePacket(this.getResourcePacks(), modList);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private String[] getResourcePacks() {
        return (String[])class_310.method_1551().method_1520().method_14444().stream().map(class_3288::method_14463).toArray(String[]::new);
    }

    private List<Path> getModPath(ModContainer mod) {
        if (mod.getOrigin().getKind() == ModOrigin.Kind.UNKNOWN) {
            return null;
        }
        if (mod.getOrigin().getKind() == ModOrigin.Kind.NESTED) {
            if (mod.getContainingMod().isPresent()) {
                return this.getModPath((ModContainer)mod.getContainingMod().get());
            }
            return null;
        }
        return mod.getOrigin().getPaths();
    }

    private String getMods() {
        try {
            HashSet<HashedModDefinition> modHashes = new HashSet<HashedModDefinition>();
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
                List<Path> modPaths = this.getModPath(mod);
                LinkedList<String> hashes = new LinkedList<String>();
                if (modPaths != null) {
                    for (Path path : modPaths) {
                        try {
                            if (Files.isDirectory(path, new LinkOption[0])) continue;
                            String modhash = CerberusClient.bytesToHex(digest.digest(Files.readAllBytes(path)));
                            hashes.add(modhash);
                        }
                        catch (AccessDeniedException e) {
                            hashes.add("EACCES");
                        }
                        hashes.sort(String::compareTo);
                    }
                } else {
                    hashes.add("ENOENT");
                }
                modHashes.add(new HashedModDefinition(mod.getMetadata(), hashes));
            }
            return this.gson.toJson(modHashes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(0xFF & hash[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

