/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.cerberus.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;

@Environment(value=EnvType.CLIENT)
public class ModDefinition {
    private final String id;
    private final String name;
    private final String version;
    private final String description;
    private final String type;
    private final ArrayList<ModPerson> authors = new ArrayList();
    private final ArrayList<ModPerson> contributors = new ArrayList();
    private final ModContact contact;
    private final HashMap<String, String> customValues = new HashMap();
    private final ArrayList<ModDep> dependencies = new ArrayList();
    private final ArrayList<String> provides = new ArrayList();
    private final ArrayList<String> license = new ArrayList();

    public ModDefinition(ModMetadata metadata) {
        this.id = metadata.getId();
        this.name = metadata.getName();
        this.version = metadata.getVersion().getFriendlyString();
        this.description = metadata.getDescription();
        this.type = metadata.getType();
        metadata.getAuthors().forEach(author -> this.authors.add(new ModPerson((Person)author)));
        this.contact = new ModContact(metadata.getContact());
        metadata.getContributors().forEach(contributor -> this.contributors.add(new ModPerson((Person)contributor)));
        metadata.getDependencies().forEach(dependency -> this.dependencies.add(new ModDep(dependency.getModId(), dependency.getKind().getKey(), dependency.getKind().isPositive(), dependency.getKind().isSoft())));
        this.provides.addAll(metadata.getProvides());
        this.license.addAll(metadata.getLicense());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public ArrayList<ModPerson> getAuthors() {
        return this.authors;
    }

    public ArrayList<ModPerson> getContributors() {
        return this.contributors;
    }

    public ModContact getContact() {
        return this.contact;
    }

    public HashMap<String, String> getCustomValues() {
        return this.customValues;
    }

    public ArrayList<ModDep> getDependencies() {
        return this.dependencies;
    }

    public ArrayList<String> getProvides() {
        return this.provides;
    }

    public ArrayList<String> getLicense() {
        return this.license;
    }

    @Environment(value=EnvType.CLIENT)
    public class ModContact {
        Map<String, String> information;

        public ModContact(ContactInformation information) {
            this.information = information.asMap();
        }

        Optional<String> get(String key) {
            return Optional.ofNullable(this.information.get(key));
        }

        Map<String, String> asMap() {
            return this.information;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class ModDep {
        String modId;
        String kindKey;
        boolean isPositive;
        boolean isSoft;

        public ModDep(String modId, String kindKey, boolean isPositive, boolean isSoft) {
            this.modId = modId;
            this.kindKey = kindKey;
            this.isPositive = isPositive;
            this.isSoft = isSoft;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class ModPerson {
        String name;
        ModContact contact;

        public ModPerson(Person author) {
            this.name = author.getName();
            this.contact = new ModContact(author.getContact());
        }

        public ModPerson(String name, ModContact contact) {
            this.contact = contact;
        }
    }
}

