/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.managers;

import me.cortex.nvidium.gl.buffers.Buffer;
import me.cortex.nvidium.gl.shader.Shader;
import me.cortex.nvidium.gl.shader.ShaderType;
import me.cortex.nvidium.sodiumCompat.ShaderLoader;
import me.cortex.nvidium.util.DownloadTaskStream;
import net.minecraft.class_2960;
import org.lwjgl.opengl.GL42;
import org.lwjgl.opengl.NVMeshShader;
import org.lwjgl.system.MemoryUtil;

public class RegionVisibilityTracker {
    private final Shader shader = Shader.make().addSource(ShaderType.MESH, ShaderLoader.parse(class_2960.method_43902((String)"nvidium", (String)"occlusion/queries/region/mesh.glsl"))).addSource(ShaderType.FRAGMENT, ShaderLoader.parse(class_2960.method_43902((String)"nvidium", (String)"occlusion/queries/region/fragment.frag"))).compile();
    private final DownloadTaskStream downStream;
    private final int[] frustum;
    private final int[] visible;
    private int fram = 0;

    public RegionVisibilityTracker(DownloadTaskStream downStream, int maxRegions) {
        this.downStream = downStream;
        this.visible = new int[maxRegions];
        this.frustum = new int[maxRegions];
        for (int i = 0; i < maxRegions; ++i) {
            this.frustum[i] = 0;
            this.visible[i] = 0;
        }
    }

    public void computeVisibility(int regionCount, Buffer regionVisibilityBuffer, short[] regionMapping) {
        this.shader.bind();
        ++this.fram;
        NVMeshShader.glDrawMeshTasksNV((int)0, (int)regionCount);
        GL42.glMemoryBarrier((int)8192);
        this.downStream.download(regionVisibilityBuffer, 0L, regionCount, ptr -> {
            for (int i = 0; i < regionMapping.length; ++i) {
                if (MemoryUtil.memGetByte((long)(ptr + (long)i)) == 1) {
                    short s = regionMapping[i];
                    this.frustum[s] = this.frustum[s] + 1;
                    this.visible[regionMapping[i]] = this.fram;
                    continue;
                }
                short s = regionMapping[i];
                this.frustum[s] = this.frustum[s] + 1;
            }
        });
    }

    public void delete() {
        this.shader.delete();
    }

    public void resetRegion(int id) {
        this.frustum[id] = 0;
        this.visible[id] = 0;
    }

    public int findMostLikelyLeastSeenRegion(int maxIndex) {
        int maxRank = Integer.MIN_VALUE;
        int id = -1;
        for (int i = 0; i < maxIndex; ++i) {
            int rank;
            if (this.frustum[i] <= 200 || maxRank >= (rank = -this.visible[i])) continue;
            maxRank = rank;
            id = i;
        }
        return id;
    }
}

