/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.library.config;

import cc.reconnected.library.RccLibrary;
import cc.reconnected.library.config.Config;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().setDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").create();

    public static Path getPath(String id) {
        return FabricLoader.getInstance().getConfigDir().resolve(id + ".json");
    }

    public static <T> T load(Class<T> clazz) throws IOException {
        if (!clazz.isAnnotationPresent(Config.class)) {
            throw new IllegalArgumentException("Config is not annotated with @Config");
        }
        String id = clazz.getAnnotation(Config.class).value();
        Path path = ConfigManager.getPath(id);
        if (!path.toFile().exists()) {
            T config;
            try {
                config = clazz.getConstructor(null).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            ConfigManager.save(config);
            return config;
        }
        BufferedReader bf = new BufferedReader(new FileReader(path.toFile(), StandardCharsets.UTF_8));
        Object config = gson.fromJson((Reader)bf, clazz);
        bf.close();
        ConfigManager.save(config);
        return (T)config;
    }

    public static <T> void save(T config) {
        String id = config.getClass().getAnnotation(Config.class).value();
        Path path = ConfigManager.getPath(id);
        String json = gson.toJson(config);
        try (FileWriter fw = new FileWriter(path.toFile(), StandardCharsets.UTF_8);){
            fw.write(json);
        }
        catch (Exception e) {
            RccLibrary.LOGGER.error("Error saving {} config file.", (Object)id, (Object)e);
        }
    }
}

