/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core.executor;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import io.sc3.plethora.Plethora;
import io.sc3.plethora.api.method.FutureMethodResult;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Task {
    private volatile boolean done = false;
    private Callable<FutureMethodResult> callback;
    private FutureMethodResult.Resolver resolver;
    private boolean resolved;
    MethodResult result;
    LuaException error;

    Task(Callable<FutureMethodResult> callback, FutureMethodResult.Resolver resolver) {
        this.callback = callback;
        this.resolver = resolver;
    }

    private void finish(@Nullable MethodResult result) {
        this.done = true;
        this.result = result;
        this.whenDone();
    }

    private void finish(@Nonnull LuaException error) {
        this.done = true;
        this.error = error;
        this.whenDone();
    }

    public boolean update() {
        while (!this.done && (this.resolved || (this.resolved = this.resolver.update()) && this.canWork())) {
            long start = System.nanoTime();
            try {
                FutureMethodResult next = this.callback.call();
                if (next.isFinal()) {
                    this.finish(next.getResult());
                    boolean bl = true;
                    return bl;
                }
                this.resolver = next.getResolver();
                this.resolved = false;
                this.callback = next.getCallback();
            }
            catch (LuaException e) {
                this.finish(e);
                boolean bl = true;
                return bl;
            }
            catch (Exception | LinkageError | VirtualMachineError e) {
                this.finish(new LuaException("Java Exception Thrown: " + e));
                Plethora.log.error("Unexpected error", e);
                boolean bl = true;
                return bl;
            }
            catch (Error e) {
                this.finish(new LuaException("Java Exception Thrown: " + e));
                Plethora.log.error("Unexpected error", (Throwable)e);
                throw e;
            }
            finally {
                this.submitTiming(System.nanoTime() - start);
            }
        }
        return this.done;
    }

    final void cancel() {
        this.done = true;
    }

    final boolean isDone() {
        return this.done;
    }

    void whenDone() {
    }

    void submitTiming(long time) {
    }

    boolean canWork() {
        return true;
    }
}

