/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.gameplay.modules;

import io.sc3.plethora.api.method.IContextBuilder;
import io.sc3.plethora.api.module.IModuleAccess;
import io.sc3.plethora.api.reference.IReference;
import io.sc3.plethora.gameplay.modules.ModuleItem;
import io.sc3.plethora.gameplay.modules.RangeInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b&\u0018\u0000 %2\u00020\u0001:\u0001%B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J7\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0018\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010 \u001a\u00020\u001d8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\"\u001a\u00020\u001d8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u0014\u0010$\u001a\u00020\u001d8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001f\u00a8\u0006&"}, d2={"Lio/sc3/plethora/gameplay/modules/LevelableModuleItem;", "Lio/sc3/plethora/gameplay/modules/ModuleItem;", "", "itemName", "Lnet/minecraft/class_1792$class_1793;", "settings", "<init>", "(Ljava/lang/String;Lnet/minecraft/class_1792$class_1793;)V", "Lnet/minecraft/class_1799;", "stack", "Lnet/minecraft/class_1937;", "world", "", "Lnet/minecraft/class_2561;", "tooltip", "Lnet/minecraft/class_1836;", "context", "", "appendTooltip", "(Lnet/minecraft/class_1799;Lnet/minecraft/class_1937;Ljava/util/List;Lnet/minecraft/class_1836;)V", "Lio/sc3/plethora/api/module/IModuleAccess;", "access", "Lio/sc3/plethora/api/method/IContextBuilder;", "builder", "getAdditionalContext", "(Lnet/minecraft/class_1799;Lio/sc3/plethora/api/module/IModuleAccess;Lio/sc3/plethora/api/method/IContextBuilder;)V", "", "hasGlint", "(Lnet/minecraft/class_1799;)Z", "", "getBaseRange", "()I", "baseRange", "getLevelCost", "levelCost", "getMaxRange", "maxRange", "Companion", "Plethora-Fabric"})
public abstract class LevelableModuleItem
extends ModuleItem {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public LevelableModuleItem(@NotNull String itemName, @NotNull class_1792.class_1793 settings) {
        Intrinsics.checkNotNullParameter((Object)itemName, (String)"itemName");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(itemName, settings);
    }

    public abstract int getBaseRange();

    public abstract int getMaxRange();

    public abstract int getLevelCost();

    @Override
    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 world, @NotNull List<class_2561> tooltip, @NotNull class_1836 context) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.method_7851(stack, world, tooltip, context);
        int level = Companion.getLevel(stack);
        if (level < 0) {
            return;
        }
        int range = io.sc3.plethora.gameplay.modules.LevelableModuleItem$Companion.getEffectiveRange$default(Companion, stack, 0, 2, null);
        Object[] objectArray = new Object[]{level, range};
        class_5250 class_52502 = class_2561.method_43469((String)"item.plethora.module.level", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(...)");
        tooltip.add((class_2561)class_52502);
    }

    public boolean method_7886(@NotNull class_1799 stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return super.method_7886(stack) || Companion.getLevel(stack) > 0;
    }

    @Override
    public void getAdditionalContext(@NotNull class_1799 stack, @NotNull IModuleAccess access, @NotNull IContextBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.getAdditionalContext(stack, access, builder);
        builder.addContext(this.getModule().toString(), (IReference)RangeInfo.Companion.of(Companion.getLevel(stack), arg_0 -> LevelableModuleItem.getAdditionalContext$lambda$0(this, arg_0), arg_0 -> LevelableModuleItem.getAdditionalContext$lambda$1(this, arg_0)));
    }

    private static final int getAdditionalContext$lambda$0(LevelableModuleItem this$0, int it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return it * this$0.getLevelCost();
    }

    private static final int getAdditionalContext$lambda$1(LevelableModuleItem this$0, int it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return Companion.getEffectiveRange(this$0.getBaseRange(), this$0.getMaxRange(), it);
    }

    @JvmStatic
    public static final int getLevel(@Nullable class_1799 stack) {
        return Companion.getLevel(stack);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\b\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\fJ\u0019\u0010\r\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/sc3/plethora/gameplay/modules/LevelableModuleItem$Companion;", "", "<init>", "()V", "", "baseRange", "maxRange", "level", "getEffectiveRange", "(III)I", "Lnet/minecraft/class_1799;", "stack", "(Lnet/minecraft/class_1799;I)I", "getLevel", "(Lnet/minecraft/class_1799;)I", "Plethora-Fabric"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final int getLevel(@Nullable class_1799 stack) {
            if (stack == null || stack.method_7960()) {
                return 0;
            }
            class_2487 nbt = stack.method_7969();
            return nbt != null && nbt.method_10573("level", 99) ? nbt.method_10550("level") : 0;
        }

        public final int getEffectiveRange(int baseRange, int maxRange, int level) {
            return maxRange <= baseRange || level <= 0 ? baseRange : baseRange + (int)Math.ceil((1.0 - Math.pow(0.5, level)) * (double)(maxRange - baseRange));
        }

        public final int getEffectiveRange(@Nullable class_1799 stack, int level) {
            class_1799 class_17992 = stack;
            class_1792 item2 = class_17992 != null ? class_17992.method_7909() : null;
            return item2 != null && item2 instanceof LevelableModuleItem ? this.getEffectiveRange(((LevelableModuleItem)item2).getBaseRange(), ((LevelableModuleItem)item2).getMaxRange(), level) : 0;
        }

        public static /* synthetic */ int getEffectiveRange$default(Companion companion, class_1799 class_17992, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = companion.getLevel(class_17992);
            }
            return companion.getEffectiveRange(class_17992, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

