/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.gameplay.modules.introspection;

import dan200.computercraft.api.lua.LuaException;
import io.sc3.plethora.api.WorldLocation;
import io.sc3.plethora.api.method.IContext;
import io.sc3.plethora.api.method.IUnbakedContext;
import io.sc3.plethora.api.module.IModuleContainer;
import io.sc3.plethora.core.ContextHelpers;
import io.sc3.plethora.integration.EntityIdentifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.server.MinecraftServer;

public class IntrospectionContextHelpers {
    public static IntrospectionContext getContext(@Nonnull IUnbakedContext<IModuleContainer> unbaked) throws LuaException {
        IContext<IModuleContainer> ctx = unbaked.bake();
        EntityIdentifier entity = ContextHelpers.fromSubtarget(ctx, EntityIdentifier.class);
        MinecraftServer server = null;
        class_1297 anyEntity = ContextHelpers.fromContext(ctx, class_1297.class);
        if (anyEntity != null) {
            server = anyEntity.method_5682();
        }
        WorldLocation anyLocation = ContextHelpers.fromContext(ctx, WorldLocation.class);
        if (server == null && anyLocation != null) {
            server = anyLocation.getWorld().method_8503();
        }
        return new IntrospectionContext(ctx, entity, server);
    }

    public static ServerContext getServerContext(@Nonnull IUnbakedContext<IModuleContainer> unbaked) throws LuaException {
        IntrospectionContext ctx = IntrospectionContextHelpers.getContext(unbaked);
        MinecraftServer server = ctx.server;
        if (server == null) {
            throw new LuaException("Could not get canvas instance");
        }
        return new ServerContext(ctx.context, ctx.entity, server);
    }

    public static PlayerContext getPlayerContext(@Nonnull IUnbakedContext<IModuleContainer> unbaked) throws LuaException {
        ServerContext ctx = IntrospectionContextHelpers.getServerContext(unbaked);
        EntityIdentifier.Player player = ContextHelpers.fromSubtarget(ctx.context, EntityIdentifier.Player.class);
        if (player == null) {
            throw new LuaException("Must be run on a player");
        }
        return new PlayerContext(ctx.context, ctx.entity, player, ctx.server);
    }

    public record IntrospectionContext(IContext<IModuleContainer> context, EntityIdentifier entity, @Nullable MinecraftServer server) {
    }

    public record ServerContext(IContext<IModuleContainer> context, EntityIdentifier entity, MinecraftServer server) {
    }

    public record PlayerContext(IContext<IModuleContainer> context, EntityIdentifier entity, EntityIdentifier.Player player, MinecraftServer server) {
    }
}

