/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.server.commands;

import cc.reconnected.server.RccServer;
import cc.reconnected.server.struct.ServerPosition;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public class TeleportAskCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        LiteralCommandNode node = dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"tpa").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            class_3324 playerManager = ((class_2168)context.getSource()).method_9211().method_3760();
            return class_2172.method_9253((String[])playerManager.method_14580(), (SuggestionsBuilder)builder);
        }).executes(context -> {
            TeleportAskCommand.execute((CommandContext<class_2168>)context);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"tpask").redirect((CommandNode)node));
    }

    private static void execute(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9226(() -> class_2561.method_30163((String)"This command can only be executed by players!"), false);
            return;
        }
        MinecraftServer server = source.method_9211();
        class_3222 player = source.method_44023();
        String targetName = StringArgumentType.getString(context, (String)"player");
        class_3324 playerManager = server.method_3760();
        class_3222 target = playerManager.method_14566(targetName);
        if (target == null) {
            source.method_9226(() -> class_2561.method_43470((String)("Player \"" + targetName + "\" not found!")).method_10862(class_2583.field_24360.method_10977(class_124.field_1061)), false);
            return;
        }
        TeleportRequest request = new TeleportRequest(player.method_5667(), target.method_5667());
        ConcurrentLinkedDeque<TeleportRequest> targetRequests = RccServer.teleportRequests.get(target.method_5667());
        targetRequests.addLast(request);
        Component requestMessage = ((TextComponent)Component.empty().append((ComponentLike)player.method_5476())).appendSpace().append((Component)Component.text((String)"requested to teleport to you.", (TextColor)NamedTextColor.GOLD)).appendNewline().appendSpace().append(TeleportAskCommand.makeButton((ComponentLike)Component.text((String)"Accept", (TextColor)NamedTextColor.GREEN), (ComponentLike)Component.text((String)"Click to accept request"), "/tpaccept " + String.valueOf(request.requestId))).appendSpace().append(TeleportAskCommand.makeButton((ComponentLike)Component.text((String)"Refuse", (TextColor)NamedTextColor.RED), (ComponentLike)Component.text((String)"Click to refuse request"), "/tpdeny " + String.valueOf(request.requestId)));
        target.sendMessage(requestMessage);
        source.method_9226(() -> class_2561.method_43470((String)"Teleport request sent.").method_10862(class_2583.field_24360.method_10977(class_124.field_1060)), false);
    }

    public static Component makeButton(ComponentLike text, ComponentLike hoverText, String command) {
        return ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append((Component)Component.text((String)"["))).append(text)).append((Component)Component.text((String)"]"))).color((TextColor)NamedTextColor.AQUA)).hoverEvent((HoverEventSource)HoverEvent.showText((ComponentLike)hoverText))).clickEvent(ClickEvent.runCommand((String)command));
    }

    public static void teleport(class_3222 sourcePlayer, class_3222 targetPlayer) {
        RccServer.lastPlayerPositions.put(sourcePlayer.method_5667(), new ServerPosition(sourcePlayer));
        sourcePlayer.method_14251(targetPlayer.method_51469(), targetPlayer.method_23317(), targetPlayer.method_23318(), targetPlayer.method_23321(), targetPlayer.method_36454(), targetPlayer.method_36455());
    }

    public static class TeleportRequest {
        public UUID requestId = UUID.randomUUID();
        public UUID player;
        public UUID target;
        public int remainingTicks;

        public TeleportRequest(UUID player, UUID target) {
            this.player = player;
            this.target = target;
            this.remainingTicks = RccServer.CONFIG.teleportRequestTimeout() * 20;
        }

        public void expire() {
            this.remainingTicks = 0;
        }
    }
}

