/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.server;

import cc.reconnected.server.RccServerConfig;
import cc.reconnected.server.commands.RccCommand;
import cc.reconnected.server.database.PlayerData;
import cc.reconnected.server.events.PlayerWelcome;
import cc.reconnected.server.events.Ready;
import cc.reconnected.server.http.ServiceServer;
import java.io.IOException;
import java.util.Date;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RccServer
implements ModInitializer {
    public static final String MOD_ID = "rcc-server";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"rcc-server");
    public static final RccServerConfig CONFIG = RccServerConfig.createAndLoad();
    private static float currentTps = 0.0f;
    private static float currentMspt = 0.0f;
    private static int currentPlayerCount = 0;
    private static RccServer INSTANCE;
    private ServiceServer serviceServer;
    private LuckPerms luckPerms;

    public static RccServer getInstance() {
        return INSTANCE;
    }

    public ServiceServer serviceServer() {
        return this.serviceServer;
    }

    public LuckPerms luckPerms() {
        return this.luckPerms;
    }

    public static float getTPS() {
        return currentTps;
    }

    public static float getMSPT() {
        return currentMspt;
    }

    public static int getPlayerCount() {
        return currentPlayerCount;
    }

    public RccServer() {
        INSTANCE = this;
    }

    public void onInitialize() {
        LOGGER.info("Starting rcc-server");
        CommandRegistrationCallback.EVENT.register(RccCommand::register);
        try {
            this.serviceServer = new ServiceServer();
        }
        catch (IOException e) {
            LOGGER.error("Unable to start HTTP server", (Throwable)e);
        }
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.luckPerms = LuckPermsProvider.get();
            ((Ready)Ready.READY.invoker()).ready(server, this.luckPerms);
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            currentMspt = server.method_3830();
            if (currentMspt != 0.0f) {
                currentTps = Math.min(20.0f, 1000.0f / currentMspt);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            LOGGER.info("Stopping HTTP services");
            this.serviceServer.httpServer().stop(0);
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            currentPlayerCount = server.method_3788() + 1;
            class_3222 player = handler.method_32311();
            PlayerData playerData = PlayerData.getPlayer(player.method_5667());
            playerData.set("username", player.method_5477().getString());
            Date firstJoinedDate = playerData.getDate("first_joined_date");
            boolean isNewPlayer = false;
            if (firstJoinedDate == null) {
                playerData.setDate("first_joined_date", new Date());
                isNewPlayer = true;
            }
            if (isNewPlayer) {
                ((PlayerWelcome)PlayerWelcome.PLAYER_WELCOME.invoker()).playerWelcome(player, playerData, server);
                LOGGER.info("Player {} joined for the first time!", (Object)player.method_5477().getString());
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            currentPlayerCount = server.method_3788() - 1;
        });
    }

    public void broadcastMessage(MinecraftServer server, class_2561 message) {
        for (class_3222 player : server.method_3760().method_14571()) {
            player.method_7353(message, false);
        }
    }
}

