/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.util;

import com.mojang.authlib.GameProfile;
import io.sc3.plethora.api.IPlayerOwnable;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3966;

public class PlayerHelpers {
    @Nullable
    public static GameProfile getProfile(class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return player.method_7334();
        }
        if (entity instanceof IPlayerOwnable) {
            IPlayerOwnable playerOwnable = (IPlayerOwnable)entity;
            return playerOwnable.getOwningProfile();
        }
        return null;
    }

    @Nullable
    public static GameProfile readProfile(@Nonnull class_2487 nbt) {
        if (!nbt.method_10573("owner", 10)) {
            return null;
        }
        class_2487 owner = nbt.method_10562("owner");
        return new GameProfile(new UUID(owner.method_10537("id_upper"), owner.method_10537("id_lower")), owner.method_10558("name"));
    }

    public static void writeProfile(@Nonnull class_2487 nbt, @Nullable GameProfile profile) {
        if (profile == null) {
            nbt.method_10551("owner");
        } else {
            class_2487 owner = new class_2487();
            nbt.method_10566("owner", (class_2520)owner);
            owner.method_10544("id_upper", profile.getId().getMostSignificantBits());
            owner.method_10544("id_lower", profile.getId().getLeastSignificantBits());
            owner.method_10582("name", profile.getName());
        }
    }

    public static class_239 raycast(class_3222 player) {
        return PlayerHelpers.raycast(player, 4.0f);
    }

    public static class_239 raycast(class_3222 player, float range) {
        class_238 box;
        class_243 rotationVec;
        class_243 end;
        float tickDelta = 1.0f;
        class_239 blockHit = player.method_5745((double)range, tickDelta, false);
        class_243 vec3d = player.method_5836(tickDelta);
        class_243 vec3d2 = player.method_5828(tickDelta);
        class_243 vec3d3 = vec3d.method_1031(vec3d2.field_1352 * (double)range, vec3d2.field_1351 * (double)range, vec3d2.field_1350 * (double)range);
        class_243 cam = player.method_5836(tickDelta);
        class_3966 entityHit = class_1675.method_18075((class_1297)player, (class_243)cam, (class_243)(end = cam.method_1019((rotationVec = player.method_5828(tickDelta)).method_1021((double)range))), (class_238)(box = player.method_5829().method_18804(rotationVec.method_1021((double)range)).method_1014(1.0)), e -> !e.method_7325() && e.method_5709(), (double)(range * range));
        if (entityHit != null) {
            double blockDistance;
            double entityDistance = cam.method_1025(entityHit.method_17784());
            double d = blockDistance = blockHit != null ? cam.method_1025(blockHit.method_17784()) : Double.MAX_VALUE;
            if (blockHit == null || entityDistance < blockDistance) {
                return entityHit;
            }
            return blockHit;
        }
        return blockHit;
    }
}

