/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.chatbox.command;

import cc.reconnected.chatbox.RccChatbox;
import cc.reconnected.chatbox.command.ChatboxCommand;
import cc.reconnected.chatbox.license.Capability;
import cc.reconnected.chatbox.license.License;
import cc.reconnected.chatbox.license.LicenseManager;
import cc.reconnected.chatbox.ws.CloseCodes;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class LicenseSubCommand {
    private static Component getLicenseRegistrationOutput(License license, boolean isNew) {
        TextComponent capabilitiesComponent = Component.empty();
        Capability[] capabilities = license.capabilities().toArray(new Capability[0]);
        for (int i = 0; i < capabilities.length; ++i) {
            Capability cap = capabilities[i];
            capabilitiesComponent = (TextComponent)capabilitiesComponent.append(Component.text((String)cap.name()).color((TextColor)NamedTextColor.GOLD));
            if (i >= capabilities.length - 1) continue;
            capabilitiesComponent = (TextComponent)capabilitiesComponent.append((Component)Component.text((String)", "));
        }
        capabilitiesComponent = (TextComponent)capabilitiesComponent.append((Component)Component.text((String)"."));
        Component output = Component.empty().append((ComponentLike)ChatboxCommand.prefix);
        if (isNew) {
            output = output.append(Component.text((String)"Your license has been created!").color((TextColor)NamedTextColor.GREEN)).appendNewline().appendNewline();
        }
        output = output.append((Component)Component.text((String)"Your chatbox license key is:")).appendNewline().append((Component)Component.text((String)"  ")).append(Component.text((String)license.uuid().toString()).style(Style.style((TextColor)NamedTextColor.AQUA).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to copy"))).clickEvent(ClickEvent.copyToClipboard((String)license.uuid().toString())))).appendNewline().appendNewline().append((Component)Component.text((String)"Register the key in a computer by running:")).appendNewline().append((Component)Component.text((String)"  ")).append(Component.text((String)("chatbox register " + license.uuid().toString())).style(Style.style((TextColor)NamedTextColor.AQUA).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to copy"))).clickEvent(ClickEvent.copyToClipboard((String)("chatbox register " + license.uuid().toString()))))).appendNewline().appendNewline().append((Component)Component.text((String)"Your license capabilities are: ")).append((Component)capabilitiesComponent);
        return output;
    }

    public static LiteralArgumentBuilder<class_2168> register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"license").executes(context -> {
            UUID userId;
            if (!((class_2168)context.getSource()).method_43737()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"This command can only be executed by players!"), false);
                return 0;
            }
            LicenseManager manager = RccChatbox.licenseManager();
            License userLicense = manager.getLicenseFromUser(userId = ((class_2168)context.getSource()).method_44023().method_5667());
            if (userLicense == null) {
                Component text = ((TextComponent)Component.empty().append(Component.text((String)"You currently do not have a license!").color((TextColor)NamedTextColor.RED))).appendNewline().appendNewline().append((Component)Component.text((String)"Register a new license by running:")).appendNewline().append((Component)Component.text((String)"  ")).append(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"/chatbox license register").color((TextColor)NamedTextColor.BLUE)).decorate(TextDecoration.UNDERLINED)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to suggest")))).clickEvent(ClickEvent.copyToClipboard((String)"/chatbox license register ")));
                ((class_2168)context.getSource()).sendMessage(text);
                return 1;
            }
            ((class_2168)context.getSource()).sendMessage(LicenseSubCommand.getLicenseRegistrationOutput(userLicense, false));
            return 1;
        })).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"register").requires(Permissions.require((String)"chatbox.register", (boolean)true))).executes(context -> {
            boolean createNew;
            UUID userId;
            if (!((class_2168)context.getSource()).method_43737()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"This command can only be executed by players!"), false);
                return 0;
            }
            LicenseManager manager = RccChatbox.licenseManager();
            License userLicense = manager.getLicenseFromUser(userId = ((class_2168)context.getSource()).method_44023().method_5667());
            boolean bl = createNew = userLicense == null;
            if (createNew) {
                userLicense = manager.createLicense(userId, Capability.DEFAULT);
            }
            ((class_2168)context.getSource()).sendMessage(LicenseSubCommand.getLicenseRegistrationOutput(userLicense, createNew));
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"revoke").requires(Permissions.require((String)"chatbox.revoke", (boolean)true))).executes(context -> {
            if (!((class_2168)context.getSource()).method_43737()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"This command can only be executed by players!"), false);
                return 0;
            }
            LicenseManager manager = RccChatbox.licenseManager();
            License userLicense = manager.getLicenseFromUser(((class_2168)context.getSource()).method_44023().method_5667());
            if (userLicense == null) {
                TextComponent text = (TextComponent)((TextComponent)Component.empty().append((ComponentLike)ChatboxCommand.prefix)).append(Component.text((String)"You already do not have a license!").color((TextColor)NamedTextColor.RED));
                ((class_2168)context.getSource()).sendMessage((Component)text);
                return 1;
            }
            UUID licenseUuid = userLicense.uuid();
            boolean success = manager.deleteLicense(userLicense.uuid());
            if (success) {
                TextComponent text = (TextComponent)((TextComponent)Component.empty().append((ComponentLike)ChatboxCommand.prefix)).append(Component.text((String)"Your license has been revoked!").color((TextColor)NamedTextColor.GREEN));
                ((class_2168)context.getSource()).sendMessage((Component)text);
                RccChatbox.getInstance().wss().closeLicenseClients(licenseUuid, CloseCodes.CHANGED_LICENSE_KEY);
            } else {
                TextComponent text = (TextComponent)((TextComponent)Component.empty().append((ComponentLike)ChatboxCommand.prefix)).append(Component.text((String)"There was an error revoking your license!").color((TextColor)NamedTextColor.RED));
                ((class_2168)context.getSource()).sendMessage((Component)text);
            }
            return 1;
        }));
    }
}

