/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.chatbox.listeners;

import cc.reconnected.chatbox.RccChatbox;
import cc.reconnected.chatbox.api.events.ClientConnectionEvents;
import cc.reconnected.chatbox.license.Capability;
import cc.reconnected.chatbox.listeners.ChatboxEvents;
import cc.reconnected.chatbox.models.User;
import cc.reconnected.chatbox.packets.serverPackets.events.AfkEvent;
import cc.reconnected.chatbox.packets.serverPackets.events.ServerRestartCancelledEvent;
import cc.reconnected.chatbox.packets.serverPackets.events.ServerRestartScheduledEvent;
import cc.reconnected.chatbox.utils.DateUtils;
import cc.reconnected.essentials.api.events.PlayerActivityEvents;
import cc.reconnected.essentials.api.events.RestartEvents;
import cc.reconnected.essentials.core.BossBarManager;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.Date;
import org.jetbrains.annotations.Nullable;

public class EssentialsEvents {
    @Nullable
    private static BossBarManager.TimeBar restartBar = null;
    @Nullable
    private static ServerRestartScheduledEvent restartScheduledEvent = null;

    public static void register() {
        ClientConnectionEvents.CONNECT.register((conn, license, isGuest) -> {
            if (license.capabilities().contains((Object)Capability.READ)) {
                String playersPacket = RccChatbox.GSON.toJson((Object)ChatboxEvents.createPlayersPacket());
                conn.send(playersPacket);
                if (restartBar != null) {
                    EssentialsEvents.fixRestartTime();
                    String restartPacket = RccChatbox.GSON.toJson((Object)restartScheduledEvent);
                    conn.send(restartPacket);
                }
            }
        });
        PlayerActivityEvents.AFK.register((player, server) -> {
            AfkEvent packet = new AfkEvent();
            packet.user = User.create(player);
            packet.time = DateUtils.getTime(new Date());
            RccChatbox.getInstance().wss().broadcastEvent(packet, Capability.READ);
        });
        PlayerActivityEvents.AFK_RETURN.register((player, server) -> {
            AfkEvent packet = new AfkEvent();
            packet.user = User.create(player);
            packet.time = DateUtils.getTime(new Date());
            RccChatbox.getInstance().wss().broadcastEvent(packet, Capability.READ);
        });
        RestartEvents.SCHEDULED.register(timeBar -> {
            restartBar = timeBar;
            ServerRestartScheduledEvent packet = new ServerRestartScheduledEvent();
            Date now = new Date();
            Duration duration = Duration.ofSeconds(timeBar.getTime());
            Temporal restartAt = duration.addTo(now.toInstant());
            Date restartAtDate = Date.from(Instant.from(restartAt));
            packet.time = DateUtils.getTime(now);
            packet.restartAt = DateUtils.getTime(restartAtDate);
            packet.restartType = "automatic";
            EssentialsEvents.fixRestartTime();
            RccChatbox.getInstance().wss().broadcastEvent(packet, Capability.READ);
        });
        RestartEvents.CANCELED.register(timeBar -> {
            if (restartScheduledEvent == null) {
                return;
            }
            ServerRestartCancelledEvent packet = new ServerRestartCancelledEvent();
            packet.time = DateUtils.getTime(new Date());
            packet.restartType = EssentialsEvents.restartScheduledEvent.restartType;
            restartBar = null;
            restartScheduledEvent = null;
            RccChatbox.getInstance().wss().broadcastEvent(packet, Capability.READ);
        });
    }

    private static void fixRestartTime() {
        if (restartScheduledEvent == null) {
            return;
        }
        EssentialsEvents.restartScheduledEvent.restartSeconds = restartBar.getRemainingSeconds();
    }
}

