/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.chatbox.models;

import cc.reconnected.chatbox.models.DiscordUser;
import cc.reconnected.discordbridge.RccDiscord;
import cc.reconnected.essentials.core.AfkTracker;
import cc.reconnected.library.data.PlayerMeta;
import java.util.UUID;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.UserSnowflake;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class User {
    public String type = "ingame";
    public String name;
    public String uuid;
    public String displayName;
    public String group;
    public String pronouns;
    public String world;
    public boolean afk;
    public boolean alt;
    public boolean bot;
    public int supporter;
    @Nullable
    public DiscordUser linkedUser;

    private static void fillInData(User user, @Nullable class_3222 entity, boolean resolveDiscord) {
        Member member;
        String discordId;
        PlayerMeta playerData;
        if (entity != null) {
            playerData = PlayerMeta.getPlayer((class_3222)entity);
            user.afk = AfkTracker.getInstance().isPlayerAfk(entity.method_5667());
        } else {
            playerData = PlayerMeta.getPlayer((UUID)UUID.fromString(user.uuid));
            user.afk = false;
        }
        user.group = playerData.getPrimaryGroup();
        user.pronouns = playerData.get("pronouns");
        user.alt = playerData.getBoolean("is_alt");
        user.bot = playerData.getBoolean("is_bot");
        user.supporter = 0;
        String supporterStr = playerData.get("supporter_level");
        if (supporterStr != null) {
            user.supporter = Integer.parseInt(supporterStr);
        }
        user.linkedUser = null;
        if (resolveDiscord && (discordId = playerData.get("discord_id")) != null && (member = RccDiscord.getInstance().getClient().guild().getMember(UserSnowflake.fromId((String)discordId))) != null) {
            user.linkedUser = DiscordUser.fromMember(member, false);
        }
    }

    public static User create(class_3222 player, boolean resolveDiscord) {
        User user = new User();
        user.name = player.method_5820();
        user.uuid = player.method_5845();
        user.displayName = player.method_5476().getString();
        user.world = player.method_37908().method_27983().method_29177().toString();
        User.fillInData(user, player, resolveDiscord);
        return user;
    }

    public static User create(class_3222 player) {
        return User.create(player, false);
    }

    public static User tryGet(UUID playerUuid, boolean resolveDiscord) {
        User user = new User();
        PlayerMeta playerData = PlayerMeta.getPlayer((UUID)playerUuid);
        user.uuid = playerUuid.toString();
        user.name = playerData.getEffectiveName();
        user.displayName = playerData.getEffectiveName();
        user.world = null;
        User.fillInData(user, null, resolveDiscord);
        return user;
    }

    public static User tryGet(UUID playerUuid) {
        return User.tryGet(playerUuid, false);
    }
}

