/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.bossbar;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.neznamy.tab.api.bossbar.BarColor;
import me.neznamy.tab.api.bossbar.BarStyle;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.shared.chat.TabComponent;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BossBar;
import org.jetbrains.annotations.NotNull;

public class BukkitBossBar
implements me.neznamy.tab.shared.platform.BossBar {
    private static final org.bukkit.boss.BarStyle[] styles = org.bukkit.boss.BarStyle.values();
    @NotNull
    private final BukkitTabPlayer player;
    @NotNull
    private final Map<UUID, BossBar> bossBars = new HashMap<UUID, BossBar>();

    @Override
    public void create(@NotNull UUID id, @NotNull String title, float progress, @NotNull BarColor color, @NotNull BarStyle style) {
        if (this.bossBars.containsKey(id)) {
            return;
        }
        BossBar bar = Bukkit.createBossBar((String)this.player.getPlatform().toBukkitFormat(TabComponent.optimized(title), this.player.getVersion().supportsRGB()), (org.bukkit.boss.BarColor)org.bukkit.boss.BarColor.valueOf((String)color.name()), (org.bukkit.boss.BarStyle)styles[style.ordinal()], (BarFlag[])new BarFlag[0]);
        bar.setProgress((double)progress);
        bar.addPlayer(this.player.getPlayer());
        this.bossBars.put(id, bar);
    }

    @Override
    public void update(@NotNull UUID id, @NotNull String title) {
        this.bossBars.get(id).setTitle(this.player.getPlatform().toBukkitFormat(TabComponent.optimized(title), this.player.getVersion().supportsRGB()));
    }

    @Override
    public void update(@NotNull UUID id, float progress) {
        this.bossBars.get(id).setProgress((double)progress);
    }

    @Override
    public void update(@NotNull UUID id, @NotNull BarStyle style) {
        this.bossBars.get(id).setStyle(styles[style.ordinal()]);
    }

    @Override
    public void update(@NotNull UUID id, @NotNull BarColor color) {
        this.bossBars.get(id).setColor(org.bukkit.boss.BarColor.valueOf((String)color.name()));
    }

    @Override
    public void remove(@NotNull UUID id) {
        this.bossBars.remove(id).removePlayer(this.player.getPlayer());
    }

    public BukkitBossBar(@NotNull BukkitTabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.player = player;
    }
}

