/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.nms;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.BiFunction;
import me.neznamy.tab.platforms.bukkit.nms.BukkitReflection;
import me.neznamy.tab.shared.chat.ChatModifier;
import me.neznamy.tab.shared.chat.SimpleComponent;
import me.neznamy.tab.shared.chat.StructuredComponent;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.util.FunctionWithException;
import me.neznamy.tab.shared.util.ReflectionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentConverter {
    @Nullable
    public static ComponentConverter INSTANCE;
    private final FunctionWithException<String, Object> newTextComponent;
    private final BiFunction<ChatModifier, Boolean, Object> convertModifier;
    private final Class<?> ChatModifier = BukkitReflection.getClass("network.chat.Style", "network.chat.ChatModifier", "ChatModifier");
    private final Class<Enum> EnumChatFormat = BukkitReflection.getClass("ChatFormatting", "EnumChatFormat");
    private final Constructor<?> newChatModifier;
    private final Method ChatBaseComponent_addSibling;
    private final Field Component_modifier;
    private final List<Field> magicCodes = ReflectionUtils.getFields(this.ChatModifier, Boolean.class);
    private Method ChatModifier_setColor;
    private Method ChatHexColor_fromRGB;
    private Method ResourceLocation_tryParse;

    private ComponentConverter() throws ReflectiveOperationException {
        Class<?> IChatBaseComponent = BukkitReflection.getClass("network.chat.Component", "network.chat.IChatBaseComponent", "IChatBaseComponent");
        if (BukkitReflection.getMinorVersion() >= 19) {
            Method IChatBaseComponent_b = ReflectionUtils.getMethod(IChatBaseComponent, new String[]{"b", "literal"}, String.class);
            this.newTextComponent = text -> IChatBaseComponent_b.invoke(null, text);
            Class<?> IChatMutableComponent = BukkitReflection.getClass("network.chat.MutableComponent", "network.chat.IChatMutableComponent", "IChatMutableComponent");
            this.Component_modifier = ReflectionUtils.getOnlyField(IChatMutableComponent, this.ChatModifier);
            this.ChatBaseComponent_addSibling = ReflectionUtils.getOnlyMethod(IChatMutableComponent, IChatMutableComponent, IChatBaseComponent);
        } else {
            Class<?> ChatComponentText = BukkitReflection.getClass("network.chat.TextComponent", "network.chat.ChatComponentText", "ChatComponentText");
            Constructor<?> newChatComponentText = ChatComponentText.getConstructor(String.class);
            this.newTextComponent = xva$0 -> newChatComponentText.newInstance(xva$0);
            Class<?> ChatBaseComponent = BukkitReflection.getClass("network.chat.BaseComponent", "network.chat.ChatBaseComponent", "ChatBaseComponent");
            this.Component_modifier = ReflectionUtils.getOnlyField(ChatBaseComponent, this.ChatModifier);
            this.ChatBaseComponent_addSibling = ReflectionUtils.getOnlyMethod(ChatComponentText, IChatBaseComponent, IChatBaseComponent);
        }
        if (BukkitReflection.getMinorVersion() >= 16) {
            Class<?> chatHexColor = BukkitReflection.getClass("network.chat.TextColor", "network.chat.ChatHexColor", "ChatHexColor");
            Class<?> ResourceLocation = BukkitReflection.getClass("resources.ResourceLocation", "resources.MinecraftKey", "MinecraftKey");
            Class<?> chatClickable = BukkitReflection.getClass("network.chat.ClickEvent", "network.chat.ChatClickable", "ChatClickable");
            Class<?> chatHoverable = BukkitReflection.getClass("network.chat.HoverEvent", "network.chat.ChatHoverable", "ChatHoverable");
            this.ResourceLocation_tryParse = ReflectionUtils.getMethod(ResourceLocation, new String[]{"tryParse", "m_135820_", "a"}, String.class);
            this.ChatHexColor_fromRGB = ReflectionUtils.getMethods(chatHexColor, chatHexColor, Integer.TYPE).get(0);
            this.newChatModifier = ReflectionUtils.setAccessible(this.ChatModifier.getDeclaredConstructor(chatHexColor, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, chatClickable, chatHoverable, String.class, ResourceLocation));
            this.convertModifier = this::createModifierModern;
        } else {
            this.newChatModifier = this.ChatModifier.getConstructor(new Class[0]);
            this.ChatModifier_setColor = ReflectionUtils.getOnlyMethod(this.ChatModifier, this.ChatModifier, this.EnumChatFormat);
            this.convertModifier = (modifier, protocolVersion) -> this.createModifierLegacy((ChatModifier)modifier);
        }
    }

    public Object convert(@NotNull TabComponent component, boolean modern) {
        if (component instanceof SimpleComponent) {
            return this.newTextComponent.apply(((SimpleComponent)component).getText());
        }
        StructuredComponent component1 = (StructuredComponent)component;
        Object nmsComponent = this.newTextComponent.apply(component1.getText());
        this.Component_modifier.set(nmsComponent, this.convertModifier.apply(component1.getModifier(), modern));
        for (StructuredComponent extra : component1.getExtra()) {
            this.ChatBaseComponent_addSibling.invoke(nmsComponent, this.convert(extra, modern));
        }
        return nmsComponent;
    }

    private Object createModifierModern(@NotNull ChatModifier modifier, boolean modern) {
        Object color = null;
        if (modifier.getColor() != null) {
            color = modern ? this.ChatHexColor_fromRGB.invoke(null, modifier.getColor().getRgb()) : this.ChatHexColor_fromRGB.invoke(null, modifier.getColor().getLegacyColor().getRgb());
        }
        return this.newChatModifier.newInstance(color, modifier.isBold(), modifier.isItalic(), modifier.isUnderlined(), modifier.isStrikethrough(), modifier.isObfuscated(), null, null, null, modifier.getFont() == null ? null : this.ResourceLocation_tryParse.invoke(null, modifier.getFont()));
    }

    private Object createModifierLegacy(@NotNull ChatModifier modifier) {
        Object nmsModifier = this.newChatModifier.newInstance(new Object[0]);
        if (modifier.getColor() != null) {
            this.ChatModifier_setColor.invoke(nmsModifier, Enum.valueOf(this.EnumChatFormat, modifier.getColor().getLegacyColor().name()));
        }
        if (modifier.isBold()) {
            this.magicCodes.get(0).set(nmsModifier, true);
        }
        if (modifier.isItalic()) {
            this.magicCodes.get(1).set(nmsModifier, true);
        }
        if (modifier.isStrikethrough()) {
            this.magicCodes.get(2).set(nmsModifier, true);
        }
        if (modifier.isUnderlined()) {
            this.magicCodes.get(3).set(nmsModifier, true);
        }
        if (modifier.isObfuscated()) {
            this.magicCodes.get(4).set(nmsModifier, true);
        }
        return nmsModifier;
    }

    public static void tryLoad() {
        try {
            INSTANCE = new ComponentConverter();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void ensureAvailable() {
        if (INSTANCE == null) {
            throw new IllegalStateException("Component converter is not available");
        }
    }
}

