/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord;

import me.neznamy.tab.platforms.bungeecord.BungeeBossBar;
import me.neznamy.tab.platforms.bungeecord.BungeePlatform;
import me.neznamy.tab.platforms.bungeecord.BungeeScoreboard;
import me.neznamy.tab.platforms.bungeecord.tablist.BungeeTabList;
import me.neznamy.tab.platforms.bungeecord.tablist.BungeeTabList1193;
import me.neznamy.tab.platforms.bungeecord.tablist.BungeeTabList17;
import me.neznamy.tab.platforms.bungeecord.tablist.BungeeTabList18;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.hook.PremiumVanishHook;
import me.neznamy.tab.shared.platform.BossBar;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.proxy.ProxyTabPlayer;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BungeeTabPlayer
extends ProxyTabPlayer {
    @NotNull
    private final BungeeScoreboard scoreboard = new BungeeScoreboard(this);
    @NotNull
    private final BungeeTabList tabList1_7 = new BungeeTabList17(this);
    @NotNull
    private final BungeeTabList tabList1_8 = new BungeeTabList18(this);
    @NotNull
    private final BungeeTabList tabList1_19_3 = new BungeeTabList1193(this);
    @NotNull
    private final BossBar bossBar = new BungeeBossBar(this);

    public BungeeTabPlayer(@NotNull BungeePlatform platform, @NotNull ProxiedPlayer p) {
        super(platform, p, p.getUniqueId(), p.getName(), p.getServer() != null ? p.getServer().getInfo().getName() : "-", p.getPendingConnection().getVersion());
    }

    @Override
    public boolean hasPermission0(@NotNull String permission) {
        return this.getPlayer().hasPermission(permission);
    }

    @Override
    public int getPing() {
        return this.getPlayer().getPing();
    }

    @Override
    public void sendMessage(@NotNull TabComponent message) {
        block2: {
            try {
                this.getPlayer().sendMessage((BaseComponent)message.convert(this.getVersion()));
            }
            catch (NullPointerException BungeeCordBug) {
                if (!TAB.getInstance().getConfiguration().isDebugMode()) break block2;
                TAB.getInstance().getErrorManager().printError("Failed to send message to player " + this.getName() + " (online = " + this.getPlayer().isConnected() + "): " + message.convert(this.getVersion()), BungeeCordBug);
            }
        }
    }

    @Override
    @Nullable
    public TabList.Skin getSkin() {
        LoginResult loginResult = ((InitialHandler)this.getPlayer().getPendingConnection()).getLoginProfile();
        if (loginResult == null) {
            return null;
        }
        Property[] properties = loginResult.getProperties();
        if (properties == null || properties.length == 0) {
            return null;
        }
        return new TabList.Skin(properties[0].getValue(), properties[0].getSignature());
    }

    @NotNull
    public ProxiedPlayer getPlayer() {
        return (ProxiedPlayer)this.player;
    }

    @Override
    public BungeePlatform getPlatform() {
        return (BungeePlatform)this.platform;
    }

    @Override
    public void sendPluginMessage(byte[] message) {
        block3: {
            if (!this.getPlayer().isConnected()) {
                return;
            }
            try {
                this.getPlayer().getServer().sendData("tab:bridge-5", message);
            }
            catch (NullPointerException BungeeCordBug) {
                if (!TAB.getInstance().getConfiguration().isDebugMode()) break block3;
                TAB.getInstance().getErrorManager().printError("Failed to deliver plugin message to player " + this.getName() + " (online = " + this.getPlayer().isConnected() + ")", BungeeCordBug);
            }
        }
    }

    @Override
    public boolean isVanished() {
        if (PremiumVanishHook.getInstance() != null && PremiumVanishHook.getInstance().isVanished(this)) {
            return true;
        }
        return super.isVanished();
    }

    @NotNull
    public BungeeTabList getTabList() {
        int version = this.getPlayer().getPendingConnection().getVersion();
        if (version >= ProtocolVersion.V1_19_3.getNetworkId()) {
            return this.tabList1_19_3;
        }
        if (version >= ProtocolVersion.V1_8.getNetworkId()) {
            return this.tabList1_8;
        }
        return this.tabList1_7;
    }

    public void sendPacket(@NotNull DefinedPacket packet) {
        block3: {
            if (!this.getPlayer().isConnected()) {
                return;
            }
            try {
                ((UserConnection)this.getPlayer()).sendPacketQueued(packet);
            }
            catch (NullPointerException BungeeCordBug) {
                if (!TAB.getInstance().getConfiguration().isDebugMode()) break block3;
                TAB.getInstance().getErrorManager().printError("Failed to deliver packet to player " + this.getName() + " (online = " + this.getPlayer().isConnected() + "): " + packet, BungeeCordBug);
            }
        }
    }

    @NotNull
    public BungeeScoreboard getScoreboard() {
        return this.scoreboard;
    }

    @NotNull
    public BungeeTabList getTabList1_7() {
        return this.tabList1_7;
    }

    @NotNull
    public BungeeTabList getTabList1_8() {
        return this.tabList1_8;
    }

    @NotNull
    public BungeeTabList getTabList1_19_3() {
        return this.tabList1_19_3;
    }

    @Override
    @NotNull
    public BossBar getBossBar() {
        return this.bossBar;
    }
}

