/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord.tablist;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.platforms.bungeecord.BungeeTabPlayer;
import me.neznamy.tab.platforms.bungeecord.tablist.BungeeTabList;
import me.neznamy.tab.shared.platform.TabList;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.PlayerListItemRemove;
import net.md_5.bungee.protocol.packet.PlayerListItemUpdate;
import org.jetbrains.annotations.Nullable;

public class BungeeTabList1193
extends BungeeTabList {
    private static final Map<TabList.Action, EnumSet<PlayerListItemUpdate.Action>> actions = new EnumMap<TabList.Action, EnumSet<PlayerListItemUpdate.Action>>(TabList.Action.class);

    public BungeeTabList1193(@NonNull BungeeTabPlayer player) {
        super(player);
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
    }

    @Override
    public void removeEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.removeUuid(entry);
        PlayerListItemRemove remove = new PlayerListItemRemove();
        remove.setUuids(new UUID[]{entry});
        ((BungeeTabPlayer)this.player).sendPacket((DefinedPacket)remove);
    }

    @Override
    public void updateDisplayName0(@NonNull UUID entry, @Nullable BaseComponent displayName) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        PlayerListItem.Item item = this.item(entry);
        item.setDisplayName(displayName);
        this.sendPacket(TabList.Action.UPDATE_DISPLAY_NAME, item);
    }

    @Override
    public void updateLatency(@NonNull UUID entry, int latency) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        PlayerListItem.Item item = this.item(entry);
        item.setPing(Integer.valueOf(latency));
        this.sendPacket(TabList.Action.UPDATE_LATENCY, item);
    }

    @Override
    public void updateGameMode(@NonNull UUID entry, int gameMode) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        PlayerListItem.Item item = this.item(entry);
        item.setGamemode(Integer.valueOf(gameMode));
        this.sendPacket(TabList.Action.UPDATE_GAME_MODE, item);
    }

    @Override
    public void updateListed(@NonNull UUID entry, boolean listed) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        PlayerListItem.Item item = this.item(entry);
        item.setListed(Boolean.valueOf(listed));
        this.sendPacket(TabList.Action.UPDATE_LISTED, item);
    }

    @Override
    public void addEntry0(@NonNull UUID id, @NonNull String name, @Nullable TabList.Skin skin, boolean listed, int latency, int gameMode, @Nullable BaseComponent displayName) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.addUuid(id);
        this.sendPacket(TabList.Action.ADD_PLAYER, this.entryToItem(id, name, skin, listed, latency, gameMode, displayName));
    }

    private void sendPacket(@NonNull TabList.Action action, @NonNull PlayerListItem.Item item) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        PlayerListItemUpdate packet = new PlayerListItemUpdate();
        packet.setActions(actions.get((Object)action));
        packet.setItems(new PlayerListItem.Item[]{item});
        ((BungeeTabPlayer)this.player).sendPacket((DefinedPacket)packet);
    }

    static {
        actions.put(TabList.Action.ADD_PLAYER, EnumSet.allOf(PlayerListItemUpdate.Action.class));
        actions.put(TabList.Action.UPDATE_GAME_MODE, EnumSet.of(PlayerListItemUpdate.Action.UPDATE_GAMEMODE));
        actions.put(TabList.Action.UPDATE_DISPLAY_NAME, EnumSet.of(PlayerListItemUpdate.Action.UPDATE_DISPLAY_NAME));
        actions.put(TabList.Action.UPDATE_LATENCY, EnumSet.of(PlayerListItemUpdate.Action.UPDATE_LATENCY));
        actions.put(TabList.Action.UPDATE_LISTED, EnumSet.of(PlayerListItemUpdate.Action.UPDATE_LISTED));
    }
}

