/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.sponge8;

import java.io.File;
import me.neznamy.tab.libs.org.bstats.charts.SimplePie;
import me.neznamy.tab.libs.org.bstats.sponge.Metrics;
import me.neznamy.tab.platforms.sponge8.Sponge8TAB;
import me.neznamy.tab.platforms.sponge8.SpongeEventListener;
import me.neznamy.tab.platforms.sponge8.SpongeTabPlayer;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.backend.BackendPlatform;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.features.injection.PipelineInjector;
import me.neznamy.tab.shared.features.nametags.NameTag;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.hook.AdventureHook;
import me.neznamy.tab.shared.placeholders.expansion.EmptyTabExpansion;
import me.neznamy.tab.shared.placeholders.expansion.TabExpansion;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;

public class SpongePlatform
implements BackendPlatform {
    @NotNull
    private final Sponge8TAB plugin;
    private final ProtocolVersion serverVersion = ProtocolVersion.fromFriendlyName(Sponge.game().platform().minecraftVersion().name());

    @Override
    public void registerUnknownPlaceholder(@NotNull String identifier) {
        this.registerDummyPlaceholder(identifier);
    }

    @Override
    public void loadPlayers() {
        for (ServerPlayer player : Sponge.server().onlinePlayers()) {
            TAB.getInstance().addPlayer(new SpongeTabPlayer(this, player));
        }
    }

    @Override
    @Nullable
    public PipelineInjector createPipelineInjector() {
        return null;
    }

    @Override
    @NotNull
    public NameTag getUnlimitedNameTags() {
        return new NameTag();
    }

    @Override
    @NotNull
    public TabExpansion createTabExpansion() {
        return new EmptyTabExpansion();
    }

    @Override
    @Nullable
    public TabFeature getPerWorldPlayerList() {
        return null;
    }

    @Override
    public void logInfo(@NotNull TabComponent message) {
        Sponge.systemSubject().sendMessage(Component.text((String)"[TAB] ").append(AdventureHook.toAdventureComponent(message, true)));
    }

    @Override
    public void logWarn(@NotNull TabComponent message) {
        Sponge.systemSubject().sendMessage(Component.text((String)"[TAB] [WARN] ").append(AdventureHook.toAdventureComponent(message, true)));
    }

    @Override
    @NotNull
    public String getServerVersionInfo() {
        return "[Sponge] " + Sponge.platform().minecraftVersion().name();
    }

    @Override
    public void registerListener() {
        Sponge.game().eventManager().registerListeners(this.plugin.getContainer(), (Object)new SpongeEventListener());
    }

    @Override
    public void registerCommand() {
    }

    @Override
    public void startMetrics() {
        Metrics metrics = this.plugin.getMetricsFactory().make(17732);
        metrics.startup(null);
        metrics.addCustomChart(new SimplePie("server_version", this.serverVersion::getFriendlyName));
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return this.plugin.getConfigDir().toFile();
    }

    public Component convertComponent(@NotNull TabComponent component, boolean modern) {
        return AdventureHook.toAdventureComponent(component, modern);
    }

    @Override
    public double getTPS() {
        return Sponge.server().ticksPerSecond();
    }

    @Override
    public double getMSPT() {
        return Sponge.server().averageTickTime();
    }

    public SpongePlatform(@NotNull Sponge8TAB plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.plugin = plugin;
    }

    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }
}

