/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.velocity;

import com.imaginarycode.minecraft.redisbungee.RedisBungeeAPI;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import java.io.File;
import me.neznamy.tab.libs.org.bstats.charts.SimplePie;
import me.neznamy.tab.platforms.velocity.VelocityEventListener;
import me.neznamy.tab.platforms.velocity.VelocityTAB;
import me.neznamy.tab.platforms.velocity.VelocityTabCommand;
import me.neznamy.tab.platforms.velocity.VelocityTabPlayer;
import me.neznamy.tab.platforms.velocity.features.VelocityRedisSupport;
import me.neznamy.tab.platforms.velocity.hook.VelocityPremiumVanishHook;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.features.injection.PipelineInjector;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.hook.AdventureHook;
import me.neznamy.tab.shared.hook.PremiumVanishHook;
import me.neznamy.tab.shared.proxy.ProxyPlatform;
import me.neznamy.tab.shared.util.ReflectionUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VelocityPlatform
extends ProxyPlatform {
    @NotNull
    private final VelocityTAB plugin;
    private static final ComponentLogger logger = ComponentLogger.logger((String)"TAB");
    private final MinecraftChannelIdentifier MCI = MinecraftChannelIdentifier.from((String)"tab:bridge-5");

    public VelocityPlatform(VelocityTAB plugin) {
        this.plugin = plugin;
        if (plugin.getServer().getPluginManager().isLoaded("premiumvanish")) {
            PremiumVanishHook.setInstance(new VelocityPremiumVanishHook());
        }
    }

    @Override
    public void loadPlayers() {
        for (Player p : this.plugin.getServer().getAllPlayers()) {
            TAB.getInstance().addPlayer(new VelocityTabPlayer(this, p));
        }
    }

    @Override
    @Nullable
    public RedisSupport getRedisSupport() {
        if (ReflectionUtils.classExists("com.imaginarycode.minecraft.redisbungee.RedisBungeeAPI") && RedisBungeeAPI.getRedisBungeeApi() != null) {
            return new VelocityRedisSupport(this.plugin);
        }
        return null;
    }

    @Override
    public void logInfo(@NotNull TabComponent message) {
        logger.info(AdventureHook.toAdventureComponent(message, true));
    }

    @Override
    public void logWarn(@NotNull TabComponent message) {
        logger.warn(((TextComponent)Component.text((String)"").color((TextColor)NamedTextColor.RED)).append(AdventureHook.toAdventureComponent(message, true)));
    }

    @Override
    @NotNull
    public String getServerVersionInfo() {
        return "[Velocity] " + this.plugin.getServer().getVersion().getName() + " - " + this.plugin.getServer().getVersion().getVersion();
    }

    @Override
    public void registerListener() {
        this.plugin.getServer().getEventManager().register((Object)this.plugin, (Object)new VelocityEventListener());
    }

    @Override
    public void registerCommand() {
        CommandManager cmd = this.plugin.getServer().getCommandManager();
        cmd.register(cmd.metaBuilder("btab").build(), (Command)new VelocityTabCommand());
    }

    @Override
    public void startMetrics() {
        this.plugin.getMetricsFactory().make(this.plugin, 10533).addCustomChart(new SimplePie("global_playerlist_enabled", () -> TAB.getInstance().getFeatureManager().isFeatureEnabled("GlobalPlayerList") ? "Yes" : "No"));
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return this.plugin.getDataFolder().toFile();
    }

    public Component convertComponent(@NotNull TabComponent component, boolean modern) {
        return AdventureHook.toAdventureComponent(component, modern);
    }

    @Override
    @Nullable
    public PipelineInjector createPipelineInjector() {
        return null;
    }

    @Override
    public void registerChannel() {
        this.plugin.getServer().getChannelRegistrar().register(new ChannelIdentifier[]{this.MCI});
    }

    public MinecraftChannelIdentifier getMCI() {
        return this.MCI;
    }
}

